/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser.fx;

import com.tridium.crypto.core.io.CryptoCoreClientSocketFactory;
import com.tridium.pdf.gx.PdfGraphics;
import com.tridium.security.UrlWhitelist;
import com.tridium.ui.fx.BFxWidget;
import com.tridium.workbench.shell.BFontSize;
import com.tridium.workbench.shell.BGeneralOptions;
import com.tridium.workbench.shell.BNiagaraWbWebShell;
import com.tridium.workbench.web.browser.BIWebBrowserImpl;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BWebWidget;
import com.tridium.workbench.web.browser.BrowserUtil;
import com.tridium.workbench.web.browser.IJs;
import com.tridium.workbench.web.browser.audio.AudioPlayer;
import com.tridium.workbench.web.browser.fx.JsNetscape;
import com.tridium.workbench.web.browser.fx.WebSourceFactory;
import com.tridium.workbench.web.browser.fx.debug.FxWebBrowserDebugServer;
import com.tridium.workbench.web.browser.fx.interop.Console;
import com.tridium.workbench.web.browser.fx.interop.FxBroadcastChannel;
import com.tridium.workbench.web.browser.interop.BroadcastChannel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.animation.FadeTransition;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.util.Duration;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.net.HttpsConnection;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import javax.swing.SwingUtilities;
import sun.net.www.protocol.https.Handler;

public final class BFxWebBrowserImpl
extends BFxWidget
implements BIWebBrowserImpl {
    public static final Type TYPE = Sys.loadType(BFxWebBrowserImpl.class);
    private Runnable onLoaded;
    private Runnable onRegisterFunctions;
    private static final boolean enableWebViewCache = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.enableWebViewCache"));
    private static final List<WebView> webViewCache = new ArrayList<WebView>();
    private static final Logger log = Logger.getLogger("webBrowser");
    private volatile boolean webEngInit;
    private volatile boolean isLoadExplicit;
    private volatile boolean historyEntryAppended;
    private BObject content;
    private Context context;
    private volatile BWebBrowser.IWebBrowserDropHandler dropHandler;
    private static boolean customUrlHandlersLoaded;
    private WebView webView;
    private volatile FadeTransition progressTransition;
    private volatile BorderPane progressPane;
    private volatile ProgressIndicator progress;
    private ChangeListener<String> locationListener;
    private ChangeListener<Number> workDoneListener;
    private ChangeListener<Boolean> progressListener;
    private ChangeListener<Throwable> loadExceptionListener;
    private ChangeListener<String> titleListener;
    private ChangeListener<Number> historyIndexListener;
    private ListChangeListener<WebHistory.Entry> historyEntryListener;
    private ChangeListener<Worker.State> loadStateListener;
    private ChangeListener<String> loadMessageListener;
    private ChangeListener<Number> opacityListener;
    private final ArrayList<Object> registeredObjects = new ArrayList();
    private volatile boolean userCancelled;
    private volatile boolean closed;
    private static final Lexicon LEX;
    private static final BroadcastChannel BROADCAST_CHANNEL_INTEROP;
    private static final String BLANK_PAGE_URL = "about:blank";
    private static final boolean WEBBROWSER_CONSOLE;
    private static boolean DISABLE_CERT_DIALOG;
    private UrlWhitelist whitelist;

    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean preInitialize(Map<String, String> options) {
        if (!options.getOrDefault("forceStationBrowserInit", "").equals(Boolean.TRUE.toString()) && Sys.isStation()) {
            return false;
        }
        try {
            Class.forName("javafx.scene.Node");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public void browserChanged(Property prop, Context cx) {
        if (prop == BWebBrowser.ord && this.content == null) {
            BFxWebBrowserImpl.postfx(() -> {
                this.context = cx;
                this.load();
            });
        } else if (prop == BWebBrowser.contextMenuEnabled && this.webEngInit) {
            BFxWebBrowserImpl.postfx(() -> this.webView.setContextMenuEnabled(this.getBrowser().getContextMenuEnabled()));
        } else if (prop == BWebBrowser.showProgressIndicator && this.webEngInit && this.progressTransition != null && this.progressPane != null) {
            BFxWebBrowserImpl.postfx(() -> {
                this.progressTransition.stop();
                this.progressPane.setOpacity(0.0);
            });
        }
    }

    public void stopped() throws Exception {
        if (this.webEngInit) {
            this.dropHandler = null;
            BWebBrowser browser = this.getBrowser();
            browser.fireClosing(null);
            BFxWebBrowserImpl.postfx(() -> {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("FxBrowser stopped");
                }
                WebEngine engine = this.webView.getEngine();
                engine.setOnAlert(null);
                engine.setConfirmHandler(null);
                engine.setPromptHandler(null);
                engine.setOnStatusChanged(null);
                engine.locationProperty().removeListener(this.locationListener);
                engine.getLoadWorker().workDoneProperty().removeListener(this.workDoneListener);
                engine.getLoadWorker().runningProperty().removeListener(this.progressListener);
                engine.getLoadWorker().exceptionProperty().removeListener(this.loadExceptionListener);
                engine.getLoadWorker().messageProperty().removeListener(this.loadMessageListener);
                engine.titleProperty().removeListener(this.titleListener);
                engine.getHistory().currentIndexProperty().removeListener(this.historyIndexListener);
                engine.getHistory().getEntries().removeListener(this.historyEntryListener);
                engine.getLoadWorker().stateProperty().removeListener(this.loadStateListener);
                this.progressPane.opacityProperty().removeListener(this.opacityListener);
                if (browser.isCloseOnStop()) {
                    this.close();
                }
                this.detachInterop();
                FxWebBrowserDebugServer.disconnect(this.webView);
            });
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.detachInterop();
        this.registeredObjects.clear();
        BFxWebBrowserImpl.postfx(() -> {
            WebEngine engine = this.webView.getEngine();
            AccessController.doPrivileged(() -> {
                engine.load(BLANK_PAGE_URL);
                return null;
            });
            if (log.isLoggable(Level.FINE)) {
                log.fine("FxBrowser close");
            }
            if (enableWebViewCache) {
                List<WebView> list = webViewCache;
                synchronized (list) {
                    if (!webViewCache.contains(this.webView)) {
                        webViewCache.add(this.webView);
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("FxBrowser to cache");
                    }
                }
            } else if (log.isLoggable(Level.FINE)) {
                log.fine("FxBrowser disposed");
            }
            this.webEngInit = false;
        });
    }

    public void paint(Graphics g) {
        if (g instanceof PdfGraphics) {
            try {
                g.drawImage((BImage)this.snapshot().get(), 0.0, 0.0);
            }
            catch (InterruptedException | ExecutionException e) {
                log.log(Level.SEVERE, "Could not render WebWidget PDF image", e);
            }
        } else {
            super.paint(g);
        }
    }

    @Override
    public void browserReload() {
        if (this.webEngInit) {
            BFxWebBrowserImpl.postfx(() -> this.webView.getEngine().reload());
            this.userCancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createNode() {
        StackPane pane = new StackPane();
        List<WebView> list = webViewCache;
        synchronized (list) {
            if (webViewCache.isEmpty()) {
                this.webView = new WebView();
                if (BWebWidget.DEBUG_DELAY) {
                    String debugUrl = this.getDebugUrl();
                    Clipboard.getDefault().setContents(TransferEnvelope.make((String)debugUrl));
                    System.out.println("debug URL Copied to Clipboard:");
                    System.out.println(debugUrl);
                }
                if (!Sys.isStation() && BGeneralOptions.make().getFontSize() == BFontSize.large) {
                    this.webView.setFontScale(1.1);
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("FxBrowser new");
                }
            } else {
                this.webView = webViewCache.remove(0);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("FxBrowser from cache");
                }
            }
        }
        this.webView.getEngine().getHistory().setMaxSize(0);
        pane.getChildren().add((Object)this.webView);
        this.progress = new ProgressBar(0.0);
        this.progress.setVisible(false);
        this.progressPane = new BorderPane();
        this.progressPane.setStyle("-fx-background-color: rgba(255, 255, 255, 0.5);");
        this.progressPane.setCenter((Node)this.progress);
        this.progressPane.setVisible(this.getBrowser().getShowProgressIndicator());
        pane.getChildren().add((Object)this.progressPane);
        this.progressTransition = new FadeTransition(Duration.millis((double)300.0), (Node)this.progressPane);
        this.progressTransition.setFromValue(1.0);
        this.progressTransition.setToValue(0.0);
        return pane;
    }

    protected void fxInitialized() {
        this.initWebView(this.webView);
        if (!this.webEngInit) {
            this.webEngInit = true;
            this.load();
        }
        BWidget.invokeLater(() -> this.getBrowser().fireInitialized(null));
    }

    private void initWebView(WebView view) {
        BFxWebBrowserImpl.registerCustomUrlHandlers();
        view.setContextMenuEnabled(this.getBrowser().getContextMenuEnabled());
        WebEngine engine = view.getEngine();
        engine.setOnAlert(event -> BWidget.invokeLater(() -> BDialog.info((BWidget)this, (Object)event.getData())));
        engine.setConfirmHandler(msg -> BDialog.confirm((BWidget)this, (Object)msg) == 4);
        engine.setPromptHandler(data -> BDialog.prompt((BWidget)this, (String)"", (String)data.getMessage(), (int)20));
        engine.setOnStatusChanged(event -> {
            String msg = (String)event.getData();
            if (msg != null && !msg.isEmpty()) {
                BWidget.invokeLater(() -> this.getBrowser().fireStatusMsg(BString.make((String)msg)));
            }
        });
        this.locationListener = (value, oldLoc, newLoc) -> {
            if (!this.isWhitelisted((String)newLoc)) {
                this.onLoaded = null;
                engine.load(BLANK_PAGE_URL);
                engine.loadContent(BWebBrowser.getWhitelistBlockedMessage(this.context));
                return;
            }
            BWidget.invokeLater(() -> this.getBrowser().setLocation((String)newLoc));
        };
        engine.locationProperty().addListener(this.locationListener);
        this.workDoneListener = (value, oldNumber, newNumber) -> {
            double val = newNumber.doubleValue();
            if (this.getBrowser().getShowProgressIndicator() && val != 0.0) {
                this.progressTransition.stop();
                this.progressPane.setOpacity(1.0);
            }
            double newVal = val == -1.0 ? 0.0 : val;
            BWidget.invokeLater(() -> this.getBrowser().setProgress(newVal));
            if (this.getBrowser().getShowProgressIndicator()) {
                this.progress.setProgress(newVal / 100.0);
            }
        };
        engine.getLoadWorker().workDoneProperty().addListener(this.workDoneListener);
        this.progressListener = (value, oldRunning, newRunning) -> {
            BBoolean started = BBoolean.make((boolean)newRunning);
            BWidget.invokeLater(() -> this.getBrowser().setProgressRunning(started.getBoolean()));
            if (this.getBrowser().getShowProgressIndicator() && newRunning.booleanValue()) {
                this.progress.setVisible(true);
            }
        };
        engine.getLoadWorker().runningProperty().addListener(this.progressListener);
        this.loadExceptionListener = (value, oldThrowable, newThrowable) -> {
            if (newThrowable == null) {
                return;
            }
            String hostName = LEX.getText("unknownHost.site");
            try {
                int port;
                URI uri = new URI(this.getActiveOrd().toString());
                if (uri.getHost() != null) {
                    hostName = uri.getHost();
                }
                if ((port = uri.getPort()) == -1) {
                    port = 443;
                }
                int finalPort = port;
                CryptoCoreClientSocketFactory clientSocketFactory = new CryptoCoreClientSocketFactory();
                try (Socket socket = clientSocketFactory.createSocket(uri.getHost(), finalPort);){
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "Socket available: " + socket);
                    }
                }
                catch (SSLException exception) {
                    String html = new String(BrowserUtil.makeErrorPage(BString.make((String)BWebBrowser.getCertificateBlockedMessage(this.context)), hostName).getStore().read());
                    engine.load(BLANK_PAGE_URL);
                    engine.loadContent(html);
                    if (!DISABLE_CERT_DIALOG && !Sys.isStation()) {
                        BWidget.invokeLater(() -> {
                            try {
                                SocketFactory socketFactory = HttpsConnection.getDefaultSocketFactory();
                                try (Socket socket = socketFactory.createSocket(uri.getHost(), finalPort);){
                                    if (log.isLoggable(Level.FINER)) {
                                        log.log(Level.FINER, "Socket available after Cert Dialog: " + socket);
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.warning("The main web resource will not load due to certificate warning: " + uri);
                            }
                        });
                    } else {
                        log.warning("The main web resource will not load due to certificate warning: " + uri);
                    }
                    return;
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, "Problem handling load error", e);
            }
            BWebBrowser.log.log(Level.WARNING, LEX.getText("unknownHost.loadFail"), (Throwable)newThrowable);
            String finalHostName = hostName;
            BWidget.invokeLater(() -> this.getBrowser().fireError(BString.make((String)(LEX.getText("unknownHost", new Object[]{finalHostName}) + "##"))));
        };
        engine.getLoadWorker().exceptionProperty().addListener(this.loadExceptionListener);
        this.titleListener = (value, oldTitle, newTitle) -> BWidget.invokeLater(() -> this.getBrowser().setTitle(newTitle == null ? "" : newTitle));
        engine.titleProperty().addListener(this.titleListener);
        this.loadMessageListener = (value, oldMsg, newMsg) -> {
            if (!this.isLoadExplicit) {
                this.isLoadExplicit = oldMsg.isEmpty() && !newMsg.isEmpty();
            }
        };
        engine.getLoadWorker().messageProperty().addListener(this.loadMessageListener);
        this.historyEntryListener = c -> {
            if (this.isLoadExplicit) {
                return;
            }
            while (c.next()) {
                if (!c.wasAdded()) continue;
                c.getAddedSubList().iterator().forEachRemaining(entry -> {
                    BWidget.invokeLater(() -> this.getBrowser().fireAppendHistory(BOrd.make((String)entry.getUrl())));
                    this.historyEntryAppended = true;
                });
            }
        };
        engine.getHistory().getEntries().addListener(this.historyEntryListener);
        this.historyIndexListener = (value, oldNumber, newNumber) -> {
            if (oldNumber.intValue() > newNumber.intValue()) {
                BWidget.invokeLater(() -> this.getBrowser().fireBack(null));
            } else {
                BWidget.invokeLater(() -> this.getBrowser().fireForward(null));
            }
        };
        engine.getHistory().currentIndexProperty().addListener(this.historyIndexListener);
        this.loadStateListener = (value, oldState, newState) -> {
            if (newState == Worker.State.SCHEDULED) {
                this.detachInterop();
            } else if (newState == Worker.State.SUCCEEDED) {
                this.attachAndInjectInterop();
            }
            if (oldState == Worker.State.RUNNING && newState == Worker.State.CANCELLED && !this.userCancelled) {
                if (engine.getLoadWorker().getProgress() == 0.0 && this.webView.getEngine().getLocation().equals(this.getBrowser().getLocation())) {
                    try {
                        URL url = new URL(this.webView.getEngine().getLocation());
                        this.tryFileDownload(url);
                        this.webView.getEngine().reload();
                    }
                    catch (MalformedURLException mue) {
                        BWebBrowser.log.log(Level.WARNING, "Unable to create URL for " + this.webView.getEngine().getLocation(), mue);
                    }
                    catch (Exception e) {
                        BWebBrowser.log.log(Level.WARNING, "Unable to reload " + this.webView.getEngine().getLocation(), e);
                    }
                }
            } else {
                this.userCancelled = false;
            }
            if (newState == Worker.State.SUCCEEDED || newState == Worker.State.CANCELLED || newState == Worker.State.FAILED) {
                BWebBrowser browser;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("FxBrowser load");
                }
                if ((browser = this.getBrowser()).isUri() && !this.isLoadExplicit && !this.historyEntryAppended) {
                    BWidget.invokeLater(() -> browser.fireAppendHistory(BOrd.make((String)browser.getLocation())));
                }
                this.isLoadExplicit = false;
                this.historyEntryAppended = false;
                if (newState == Worker.State.SUCCEEDED) {
                    if (this.onRegisterFunctions != null) {
                        this.onRegisterFunctions.run();
                    }
                    if (this.onLoaded != null) {
                        this.onLoaded.run();
                    }
                }
                BWidget.invokeLater(() -> browser.fireLoaded(BBoolean.make((newState == Worker.State.SUCCEEDED ? 1 : 0) != 0)));
                if (browser.getShowProgressIndicator()) {
                    this.progressTransition.playFromStart();
                }
                BWidget.invokeLater(() -> browser.setProgress(0.0));
            }
        };
        engine.getLoadWorker().stateProperty().addListener(this.loadStateListener);
        this.opacityListener = (value, oldValue, newValue) -> {
            double val = newValue.doubleValue();
            if (val <= 0.0 || val >= 1.0) {
                this.progressPane.setVisible(val >= 1.0);
            }
        };
        this.progressPane.opacityProperty().addListener(this.opacityListener);
    }

    private void tryFileDownload(URL url) {
        try {
            URLConnection conn = url.openConnection();
            conn.connect();
            if (!BFxWebBrowserImpl.shouldDoFileDownloadForConnection(conn)) {
                return;
            }
            String filename = FileUtil.getDownloadFilename((URLConnection)conn);
            try {
                this.promptAndDownload(conn, filename);
            }
            catch (Exception e) {
                BWebBrowser.log.log(Level.SEVERE, "Failed to download " + filename, e);
            }
        }
        catch (IOException e) {
            BWebBrowser.log.log(Level.SEVERE, "Failed to start file download: " + e.getMessage(), e);
        }
    }

    private static boolean shouldDoFileDownloadForConnection(URLConnection conn) {
        String contentType = conn.getContentType().toLowerCase();
        int paramPos = contentType.indexOf(59);
        if (paramPos > -1) {
            contentType = contentType.substring(0, paramPos).trim();
        }
        return !"text/html".equals(contentType) && !"application/xhtml+xml".equals(contentType);
    }

    private void promptAndDownload(final URLConnection conn, String suggestedFilename) throws Exception {
        AtomicBoolean retVal = new AtomicBoolean(false);
        final AtomicReference<Object> destinationFileRef = new AtomicReference<Object>(null);
        try {
            SwingUtilities.invokeAndWait(() -> {
                BFileChooser chooser = BFileChooser.makeSave((BWidget)this);
                chooser.setDefaultFileName(suggestedFilename);
                BOrd[] ords = chooser.show(false);
                if (ords.length > 0) {
                    BIFile bfile = (BIFile)ords[0].get();
                    destinationFileRef.set(BFileSystem.INSTANCE.pathToLocalFile(bfile.getFilePath()));
                    retVal.set(true);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        if (retVal.get()) {
            SwingUtilities.invokeLater(() -> {
                final Lexicon lex = Lexicon.make(BFxWebBrowserImpl.class);
                BProgressDialog.open((BWidget)this, (String)lex.get("download"), (BProgressDialog.Worker)new BProgressDialog.Worker(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void doRun() throws Exception {
                        long contentLength = conn.getContentLengthLong();
                        boolean done = false;
                        File tmp = File.createTempFile("niagara-wbdownload", null);
                        try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));){
                            int len;
                            byte[] buf = new byte[4096];
                            long total = 0L;
                            while (!BFxWebBrowserImpl.this.isCancelled() && (len = ((InputStream)in).read(buf)) > -1) {
                                total += (long)len;
                                ((OutputStream)out).write(buf, 0, len);
                                if (contentLength <= -1L) continue;
                                int progress = (int)(total / contentLength * 100L);
                                this.updateProgress(progress, lex.getText("downloading", new Object[]{((File)destinationFileRef.get()).getName()}));
                            }
                            if (!BFxWebBrowserImpl.this.isCancelled()) {
                                done = true;
                            }
                        }
                        catch (Exception e) {
                            BWebBrowser.log.log(Level.SEVERE, "Failed to download file: " + e.getMessage(), e);
                        }
                        finally {
                            BFxWebBrowserImpl.finish(done, tmp, (File)destinationFileRef.get());
                        }
                    }

                    public void doCancel() throws Exception {
                        BFxWebBrowserImpl.this.userCancelled = true;
                    }
                });
            });
        }
    }

    private static void finish(boolean done, File tmp, File dest) {
        try {
            if (done) {
                boolean rename = true;
                if (dest.exists() && !dest.delete()) {
                    BWebBrowser.log.severe("Failed to remove existing file - " + dest.getName());
                    rename = false;
                }
                if (rename && !tmp.renameTo(dest)) {
                    BWebBrowser.log.severe("Failed to rename downloaded file - " + tmp.getName());
                }
            }
            if (tmp.exists() && !tmp.delete()) {
                BWebBrowser.log.severe("Failed to delete temporary file - " + tmp.getName());
            }
        }
        catch (Exception e) {
            BWebBrowser.log.log(Level.SEVERE, "Failed to finish file download", e);
        }
    }

    private boolean isCancelled() {
        return this.userCancelled;
    }

    private BOrd getActiveOrd() {
        String location = this.getBrowser().getLocation();
        if (location.isEmpty() || location.equals(BLANK_PAGE_URL)) {
            return BrowserUtil.getActiveOrd(this.context);
        }
        return BOrd.make((String)location);
    }

    @Override
    public String getScheme() {
        BOrd ord = this.getActiveOrd();
        String scheme = BrowserUtil.getScheme(this.getActiveOrd());
        if (scheme != null) {
            return scheme;
        }
        throw new IllegalStateException("Could not determine scheme from activeOrd " + ord);
    }

    @Override
    public String getHostname() {
        BOrd ord = this.getActiveOrd();
        String hostname = BrowserUtil.getHostname(ord);
        if (hostname != null) {
            return hostname;
        }
        throw new IllegalStateException("Could not determine hostname from activeOrd " + ord);
    }

    @Override
    public int getPort() {
        BOrd ord = this.getActiveOrd();
        Integer port = BrowserUtil.getPort(ord);
        if (port != null) {
            return port;
        }
        throw new IllegalStateException("Could not determine port from activeOrd " + ord);
    }

    @Override
    public void load(BObject object, Context cx) {
        if (object instanceof BOrd && object.isNull()) {
            return;
        }
        BFxWebBrowserImpl.postfx(() -> {
            this.content = object;
            this.context = cx;
            if (!this.isInitialized()) {
                return;
            }
            Worker.State state = this.webView.getEngine().getLoadWorker().getState();
            if (state == Worker.State.RUNNING || state == Worker.State.SCHEDULED) {
                this.userCancelled = true;
            }
            try {
                AccessController.doPrivileged(() -> {
                    WebSourceFactory.makeSource(object, cx).load(this.webView.getEngine());
                    return null;
                });
            }
            catch (Exception e) {
                if (e instanceof PrivilegedActionException) {
                    e = ((PrivilegedActionException)e).getException();
                }
                BWebBrowser.log.log(Level.WARNING, "Failed to load browser content: " + object, e);
            }
        });
    }

    @Override
    public void setWhitelist(UrlWhitelist whitelist) {
        this.whitelist = whitelist;
    }

    private boolean isWhitelisted(String url) {
        if (url == null || url.isEmpty() || BLANK_PAGE_URL.equals(url)) {
            return true;
        }
        return this.whitelist == null || this.whitelist.test(url);
    }

    @Override
    public void setOnRegisterFunctions(Runnable onRegisterFunctions) {
        this.onRegisterFunctions = onRegisterFunctions;
    }

    @Override
    public void setOnLoaded(Runnable onLoaded) {
        this.onLoaded = onLoaded;
    }

    private void load() {
        this.load((BObject)(this.content != null ? this.content : this.getBrowser().getOrd()), this.context);
    }

    @Override
    public IJs executeScript(String script) {
        if (!BFxWidget.isFxThread()) {
            throw new BajaRuntimeException("Not JavaFX Thread");
        }
        return this.makeJs(this.webView.getEngine().executeScript(script));
    }

    @Override
    public IJs executeScriptAndWait(String script) {
        if (BFxWidget.isFxThread()) {
            return this.makeJs(this.webView.getEngine().executeScript(script));
        }
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference exceptionRef = new AtomicReference();
        AtomicReference ref = new AtomicReference();
        BFxWebBrowserImpl.postfx(() -> {
            try {
                IJs result = this.makeJs(this.webView.getEngine().executeScript(script));
                ref.set(result);
            }
            catch (Exception e) {
                exceptionRef.set(e);
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to executeScript", e);
        }
        Exception e = (Exception)exceptionRef.get();
        if (e != null) {
            throw new RuntimeException("Failed to executeScript", e);
        }
        return (IJs)ref.get();
    }

    @Override
    public void executeScriptAsync(String script) {
        BFxWebBrowserImpl.postfx(() -> this.webView.getEngine().executeScript(script));
    }

    @Override
    public boolean canUseLocalWbResources() {
        return true;
    }

    @Override
    public void setUserAgentStyleSheetLocation(String location) {
        AccessController.doPrivileged(() -> {
            this.webView.getEngine().setUserStyleSheetLocation(location);
            return null;
        });
    }

    @Override
    public boolean isInitialized() {
        return this.webEngInit;
    }

    @Override
    public void post(Runnable r) {
        BFxWidget.postfx((Runnable)r);
    }

    @Override
    public Optional<String> fromJsToString(Object o) {
        if (o == null) {
            return Optional.empty();
        }
        if (o instanceof IJs) {
            return Optional.of(o.toString());
        }
        if (o instanceof String) {
            return Optional.of((String)o);
        }
        IJs js = JsNetscape.make(o, this.getBrowser());
        if (js.isNull()) {
            return Optional.empty();
        }
        return Optional.of(js.toString());
    }

    @Override
    public boolean isCookiePresent(URI uri, String name, String value, String path) {
        return BFxWebBrowserImpl.getCookieManager().getCookieStore().get(uri).stream().anyMatch(cookie -> cookie.getName().equals(name) && cookie.getPath().equals(path) && cookie.getValue().equals(value));
    }

    @Override
    public Optional<String> getCookieValue(URI uri, String name, String path) {
        return BFxWebBrowserImpl.getCookieManager().getCookieStore().get(uri).stream().filter(cookie -> cookie.getName().equals(name) && cookie.getPath().equals(path)).map(HttpCookie::getValue).findFirst();
    }

    @Override
    public void removeCookie(URI uri, String name, String path) {
        CookieStore store = BFxWebBrowserImpl.getCookieManager().getCookieStore();
        store.get(uri).stream().filter(cookie -> cookie.getName().equals(name) && cookie.getPath().equals(path)).forEach(cookie -> store.remove(uri, (HttpCookie)cookie));
    }

    @Override
    public void addCookie(URI uri, String name, String value, String path) throws IOException {
        HttpCookie cookie = new HttpCookie(name, value);
        cookie.setPath(path);
        cookie.setDomain(uri.getHost());
        cookie.setSecure(false);
        cookie.setHttpOnly(true);
        BFxWebBrowserImpl.getCookieManager().getCookieStore().add(uri, cookie);
    }

    private static CookieManager getCookieManager() {
        CookieHandler handler = CookieHandler.getDefault();
        if (!(handler instanceof CookieManager)) {
            handler = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault(handler);
        }
        return (CookieManager)handler;
    }

    @Override
    public void register(String name, Runnable func) {
        this.getWindow().setMember(name, BFxWebBrowserImpl.asFunc(this.getBrowser(), "run", new RunnableReflectionWrapper(func), name));
    }

    @Override
    public <T> void registerConsumer(String name, Consumer<T> func) {
        this.getWindow().setMember(name, BFxWebBrowserImpl.asFunc(this.getBrowser(), "accept", new ConsumerReflectionWrapper(func), name));
    }

    @Override
    public <T, U> void registerBiConsumer(String name, BiConsumer<T, U> func) {
        this.getWindow().setMember(name, BFxWebBrowserImpl.asFunc(this.getBrowser(), "accept", new BiConsumerReflectionWrapper(func), name));
    }

    @Override
    public <T, R> void registerFunction(String name, Function<T, R> func) {
        this.getWindow().setMember(name, BFxWebBrowserImpl.asFunc(this.getBrowser(), "apply", new FunctionReflectionWrapper(func), name));
    }

    @Override
    public <T, U, R> void registerBiFunction(String name, BiFunction<T, U, R> func) {
        this.getWindow().setMember(name, BFxWebBrowserImpl.asFunc(this.getBrowser(), "apply", new BiFunctionReflectionWrapper(func), name));
    }

    @Override
    public <R> void registerSupplier(String name, Supplier<R> func) {
        this.getWindow().setMember(name, BFxWebBrowserImpl.asFunc(this.getBrowser(), "get", new SupplierReflectionWrapper(func), name));
    }

    @Override
    public void registerObject(Object o) {
        if (o instanceof String || o instanceof Number || o instanceof Boolean) {
            return;
        }
        this.registeredObjects.add(o);
    }

    private IJs getWindow() {
        return this.makeJs(this.webView.getEngine().executeScript("window"));
    }

    @Override
    public String toHostAddr(BHost host) {
        BWbShell shell = BrowserUtil.findWbShell((BComplex)this);
        String hostStr = null;
        if (shell instanceof BNiagaraWbWebShell) {
            hostStr = ((BNiagaraWbWebShell)shell).getShellContainer().getCodeBase().getHost();
        }
        if (hostStr == null) {
            hostStr = BIWebBrowserImpl.toDefaultHostAddr(host);
        }
        return hostStr;
    }

    private static Object asFunc(BWebBrowser browser, String methodName, Object javaObj, String fullName) {
        fullName = fullName.replace(".", "_");
        IJs obj = browser.executeScript("(function() {return {asFunc: function(n, " + fullName + ") {return function() {return " + fullName + "[n].apply(" + fullName + ", arguments);};}};}());");
        IJs js = obj.call("asFunc", methodName, javaObj);
        return js instanceof JsNetscape ? ((JsNetscape)js).getInner() : null;
    }

    public int doDragOver(TransferContext cx) {
        if (this.webEngInit && cx.isCopy() && cx.getEnvelope().supports(TransferFormat.mark) && this.dropHandler != null) {
            return this.dropHandler.doDragOver(cx);
        }
        return 0;
    }

    public CommandArtifact doDrop(TransferContext cx) throws Exception {
        if (this.webEngInit && cx.isCopy() && cx.getEnvelope().supports(TransferFormat.mark) && this.dropHandler != null) {
            return this.dropHandler.doDrop(cx);
        }
        return null;
    }

    @Override
    public void setDropHandler(BWebBrowser.IWebBrowserDropHandler dropHandler) {
        this.dropHandler = dropHandler;
    }

    private static URLConnection checkForWbModule(URL u) throws MalformedURLException {
        String path = u.getPath();
        if (u.getHost().equals("workbench")) {
            path = path.replaceFirst("/module/", "module://");
            return new ModuleURLConnection(new URL(path));
        }
        return null;
    }

    private static synchronized void registerCustomUrlHandlers() {
        if (!customUrlHandlersLoaded) {
            AccessController.doPrivileged(() -> {
                URL.setURLStreamHandlerFactory(protocol -> {
                    if ("module".equals(protocol)) {
                        return new URLStreamHandler(){

                            @Override
                            protected URLConnection openConnection(URL u) {
                                return new ModuleURLConnection(u);
                            }
                        };
                    }
                    if ("https".equals(protocol)) {
                        return new Handler(){

                            @Override
                            protected URLConnection openConnection(URL u) throws IOException {
                                URLConnection wbModule = BFxWebBrowserImpl.checkForWbModule(u);
                                if (wbModule != null) {
                                    return wbModule;
                                }
                                return super.openConnection(u);
                            }
                        };
                    }
                    return null;
                });
                return null;
            });
            customUrlHandlersLoaded = true;
        }
    }

    private BWebBrowser getBrowser() {
        return (BWebBrowser)this.getParent();
    }

    private void attachAndInjectInterop() {
        if (WEBBROWSER_CONSOLE) {
            Console.init(this);
        }
        BROADCAST_CHANNEL_INTEROP.attach(this);
        try {
            BROADCAST_CHANNEL_INTEROP.injectBroadcastJs(this);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Injecting Broadcast Interop", e);
        }
    }

    private IJs makeJs(Object obj) {
        return JsNetscape.make(obj, this.getBrowser());
    }

    private void detachInterop() {
        BROADCAST_CHANNEL_INTEROP.detach(this);
    }

    @Override
    public String getFragmentScrollReadyJs() {
        return "  if ((window.outerHeight < 0) || (window.outerWidth < 0))    return false;  if (window.outerHeight > 0 && window.outerWidth > 0) {    if (window.outerWidth !== window.innerWidth && window.outerHeight !== window.innerHeight)      return false;  }  return true;";
    }

    @Override
    public String getDebugUrl() {
        try {
            FxWebBrowserDebugServer debugServer = FxWebBrowserDebugServer.connect(this.webView);
            return debugServer == null ? null : debugServer.getDebugUrl();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not attach debugger to WebView", e);
            return null;
        }
    }

    @Override
    public void playSound(BOrd sound) {
        AudioPlayer.getInstance().play(sound);
    }

    @Override
    public void stopSound(BOrd sound) {
        AudioPlayer.getInstance().stop(sound);
    }

    static {
        LEX = Lexicon.make((String)"workbench");
        BROADCAST_CHANNEL_INTEROP = new FxBroadcastChannel();
        WEBBROWSER_CONSOLE = AccessController.doPrivileged(() -> Boolean.getBoolean("webBrowser.console"));
        DISABLE_CERT_DIALOG = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.browser.disableCertDialog"));
    }

    private static final class ModuleURLConnection
    extends URLConnection {
        private BIFile file;
        private static final Pattern moduleMismatchPattern = Pattern.compile("^[^/]+/module/(.*)$");

        protected ModuleURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() {
            URL url = this.getURL();
            String uri = url.getAuthority() + url.getPath();
            try {
                this.resolve(uri);
            }
            catch (Exception e) {
                Matcher matcher = moduleMismatchPattern.matcher(uri);
                if (matcher.matches()) {
                    this.resolve(matcher.group(1));
                }
                throw e;
            }
        }

        private void resolve(String uri) {
            this.file = (BIFile)BOrd.make((String)("module://" + uri)).get();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                if (this.file == null) {
                    this.connect();
                }
                return this.file.getInputStream();
            }
            catch (Throwable e) {
                BWebBrowser.log.log(Level.SEVERE, "Failed to get input stream: " + this.getURL(), e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                return null;
            }
        }

        @Override
        public String getContentType() {
            return this.file != null ? this.file.getMimeType() : null;
        }

        @Override
        public String getHeaderField(String name) {
            if ("Access-Control-Allow-Origin".equalsIgnoreCase(name)) {
                return this.getRequestProperty("Origin");
            }
            return super.getHeaderField(name);
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            String singleOrigin = this.getRequestProperty("Origin");
            List<String> origin = Collections.singletonList(singleOrigin);
            if (singleOrigin != null) {
                HashMap<String, List<String>> map = new HashMap<String, List<String>>();
                map.put("Access-Control-Allow-Origin", origin);
                return Collections.unmodifiableMap(map);
            }
            return super.getHeaderFields();
        }
    }

    public static final class SupplierReflectionWrapper<R>
    implements Supplier<R> {
        private final Supplier<R> s;

        private SupplierReflectionWrapper(Supplier<R> s) {
            this.s = s;
        }

        @Override
        public R get() {
            return this.s.get();
        }
    }

    public static final class BiFunctionReflectionWrapper<T, U, R>
    implements BiFunction<T, U, R> {
        private final BiFunction<T, U, R> f;

        private BiFunctionReflectionWrapper(BiFunction<T, U, R> f) {
            this.f = f;
        }

        @Override
        public R apply(T t, U u) {
            return this.f.apply(t, u);
        }
    }

    public static final class FunctionReflectionWrapper<T, R>
    implements Function<T, R> {
        private final Function<T, R> f;

        private FunctionReflectionWrapper(Function<T, R> f) {
            this.f = f;
        }

        @Override
        public R apply(T t) {
            return this.f.apply(t);
        }
    }

    public static final class BiConsumerReflectionWrapper<T, U>
    implements BiConsumer<T, U> {
        private final BiConsumer<T, U> c;

        private BiConsumerReflectionWrapper(BiConsumer<T, U> c) {
            this.c = c;
        }

        @Override
        public void accept(T t, U u) {
            this.c.accept(t, u);
        }
    }

    public static final class ConsumerReflectionWrapper<T>
    implements Consumer<T> {
        private final Consumer<T> c;

        private ConsumerReflectionWrapper(Consumer<T> c) {
            this.c = c;
        }

        @Override
        public void accept(T t) {
            this.c.accept(t);
        }
    }

    public static final class RunnableReflectionWrapper
    implements Runnable {
        private final Runnable r;

        private RunnableReflectionWrapper(Runnable r) {
            this.r = r;
        }

        @Override
        public void run() {
            this.r.run();
        }
    }
}

