/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser.audio;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BAbstractFile;
import javax.baja.naming.BOrd;
import javax.baja.util.ExecutorUtil;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public final class AudioPlayer {
    private final List<SoundFutureData> soundFutures;
    private final ExecutorService executor;
    private static final Logger LOG = Logger.getLogger("browserAudioPlayer");

    private AudioPlayer() {
        this.soundFutures = Collections.synchronizedList(new ArrayList());
        this.executor = ExecutorUtil.newSingleThreadBackgroundExecutor((String)"browserAudioPlayer", (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    public AudioPlayer(List<SoundFutureData> soundFutures, ExecutorService executor) {
        this.soundFutures = soundFutures;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(BOrd sound) {
        List<SoundFutureData> list = this.soundFutures;
        synchronized (list) {
            this.clearDoneSoundFutures();
            if (this.soundFutures.stream().noneMatch(soundFutureData -> ((SoundFutureData)soundFutureData).sound.equals((Object)sound))) {
                this.soundFutures.add(new SoundFutureData(sound, this.executor.submit(() -> this.playSound(sound))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BOrd sound) {
        ArrayList futuresToCancel = new ArrayList();
        List<SoundFutureData> list = this.soundFutures;
        synchronized (list) {
            this.soundFutures.removeIf(soundFutureData -> {
                boolean remove = ((SoundFutureData)soundFutureData).sound.equals((Object)sound);
                if (remove) {
                    futuresToCancel.add(((SoundFutureData)soundFutureData).future);
                }
                return remove;
            });
        }
        futuresToCancel.forEach(future -> future.cancel(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playSound(BOrd sound) {
        try {
            BAbstractFile file = (BAbstractFile)sound.get();
            try (InputStream in = file.getInputStream();
                 BufferedInputStream bufferedIn = new BufferedInputStream(in);
                 AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(bufferedIn);){
                AudioFormat audioFormat = audioInputStream.getFormat();
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                if (!AudioSystem.isLineSupported(info)) {
                    LOG.warning("Unsupported audio format: " + audioFormat);
                    return;
                }
                try (SourceDataLine dataLine = (SourceDataLine)AudioSystem.getLine(info);){
                    int bytesRead;
                    dataLine.open(audioFormat);
                    dataLine.start();
                    int bufferSize = (int)file.getSize();
                    if (bufferSize > 4096) {
                        bufferSize = 4096;
                    }
                    byte[] buffer = new byte[bufferSize];
                    while (!Thread.currentThread().isInterrupted() && (bytesRead = audioInputStream.read(buffer, 0, buffer.length)) >= 0) {
                        dataLine.write(buffer, 0, bytesRead);
                    }
                    dataLine.drain();
                }
            }
        }
        catch (Exception err) {
            LOG.log(Level.SEVERE, "Unable to play sound", err);
        }
        finally {
            this.clearDoneSoundFutures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDoneSoundFutures() {
        List<SoundFutureData> list = this.soundFutures;
        synchronized (list) {
            this.soundFutures.removeIf(soundFutureData -> ((SoundFutureData)soundFutureData).future.isDone());
        }
    }

    public static AudioPlayer getInstance() {
        return AudioPlayerHolder.INSTANCE;
    }

    public static final class SoundFutureData {
        private BOrd sound;
        private Future<?> future;

        private SoundFutureData(BOrd sound, Future<?> future) {
            this.sound = sound;
            this.future = future;
        }

        public BOrd getSound() {
            return this.sound;
        }

        public Future<?> getFuture() {
            return this.future;
        }
    }

    private static class AudioPlayerHolder {
        private static final AudioPlayer INSTANCE = new AudioPlayer();

        private AudioPlayerHolder() {
        }
    }
}

