/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BWebWidget;
import com.tridium.workbench.web.browser.IJs;
import com.tridium.workbench.web.browser.IWbJsCommand;
import com.tridium.workbench.web.browser.WbJsToggleCommand;
import java.io.IOException;
import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BCheckBoxMenuItem;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BRadioButtonMenuItem;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;

public final class WbJsCommand
extends Command
implements IWbJsCommand {
    private WbJsCommandSupport support;
    public static final int commandAll = 65535;
    public static final int commandToolBar = 2;
    public static final String commandChangeEvent = "bajaux:changecommand";
    public static final String commandInvokeEvent = "bajaux:invokecommand";
    public static final String commandFailEvent = "bajaux:failcommand";

    WbJsCommand(BWebWidget wbWidget, JSONObject cmd) {
        super((BWidget)wbWidget, "");
        this.support = new WbJsCommandSupport(this, wbWidget, cmd);
    }

    public CommandArtifact doInvoke() throws Exception {
        return this.support.doInvoke();
    }

    public String getLabel() {
        return this.support.getLabel();
    }

    public String getDescription() {
        return this.support.getDescription();
    }

    public BImage getIcon() {
        return this.support.getIcon();
    }

    @Override
    public int getId() {
        return this.support.getId();
    }

    @Override
    public void sync(JSONObject cmdData) {
        this.support.sync(cmdData);
    }

    static final class WbJsCommandSupport {
        private volatile BWebWidget wbWidget;
        private volatile int id;
        private volatile String description = "";
        private volatile String label = "";
        private volatile BImage iconImg = null;
        private volatile BAccelerator accelerator = BAccelerator.DEFAULT;
        private volatile Command cmd;

        WbJsCommandSupport(Command cmd, BWebWidget wbWidget, JSONObject jsCmd) {
            this.wbWidget = wbWidget;
            this.id = jsCmd.getInt("id");
            this.cmd = cmd;
            this.sync(jsCmd);
        }

        CommandArtifact doInvoke() throws Exception {
            BWebBrowser.post(this.wbWidget.getBrowser(), () -> this.findJsCmd().call("invoke", new Object[0]));
            return null;
        }

        String getLabel() {
            return this.label;
        }

        String getDescription() {
            return this.description;
        }

        BImage getIcon() {
            return this.iconImg;
        }

        int getId() {
            return this.id;
        }

        void sync(JSONObject jsCmd) {
            this.label = JSONUtil.getString((JSONObject)jsCmd, (String)"displayName");
            this.description = JSONUtil.getString((JSONObject)jsCmd, (String)"description");
            String iconStr = JSONUtil.getString((JSONObject)jsCmd, (String)"icon");
            this.iconImg = null;
            try {
                BIcon ic = (BIcon)BIcon.DEFAULT.decodeFromString(iconStr);
                if (ic != BIcon.DEFAULT) {
                    this.iconImg = BImage.make((BIcon)ic);
                }
            }
            catch (IOException ignore) {
                this.iconImg = null;
            }
            this.cmd.setEnabled(jsCmd.getBoolean("enabled"));
            if (this.cmd instanceof WbJsToggleCommand && jsCmd.getBoolean("toggle")) {
                WbJsToggleCommand toggleCmd = (WbJsToggleCommand)this.cmd;
                toggleCmd.setSelectedFromSync(jsCmd.getBoolean("selected"));
            }
            this.updateWidgets();
        }

        IJs findJsCmd() {
            return this.wbWidget.getJsWidget().call("getCommandGroup", new Object[0]).call("findCommand", this.id);
        }

        private void updateWidgets() {
            BWidget.invokeLater(() -> {
                for (BWidget widget : this.cmd.getRegistry()) {
                    widget.setEnabled(this.cmd.isEnabled());
                    if (widget instanceof BMenuItem) {
                        BMenuItem menuItem = (BMenuItem)widget;
                        menuItem.setText(this.label);
                        menuItem.setImage(this.iconImg == null ? BImage.NULL : this.iconImg);
                        menuItem.setAccelerator(this.accelerator);
                    } else if (widget instanceof BAbstractButton) {
                        BAbstractButton button = (BAbstractButton)widget;
                        button.setImage(this.iconImg == null ? BImage.NULL : this.iconImg);
                    }
                    if (this.cmd instanceof ToggleCommand) {
                        ToggleCommand toggleCmd = (ToggleCommand)this.cmd;
                        if (widget instanceof BToggleButton) {
                            ((BToggleButton)widget).setSelected(toggleCmd.isSelected());
                        } else if (widget instanceof BCheckBoxMenuItem) {
                            ((BCheckBoxMenuItem)widget).setSelected(toggleCmd.isSelected());
                        } else if (widget instanceof BRadioButtonMenuItem) {
                            ((BRadioButtonMenuItem)widget).setSelected(toggleCmd.isSelected());
                        }
                    }
                    widget.relayout();
                }
            });
        }
    }
}

