/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.box.BBoxService;
import com.tridium.box.BFoxBoxChannel;
import com.tridium.box.BoxOp;
import com.tridium.box.IBoxEventHandler;
import com.tridium.fox.sys.BFoxSession;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;

final class BoxClientUtil {
    private static final Object monitor = new Object();
    private static volatile boolean executorStarted = false;
    private static volatile ExecutorService executorSrv;
    private static final Logger log;

    private BoxClientUtil() {
    }

    static Optional<BoxHandler> makeHandler(BISession session) {
        if (Sys.getStation() != null) {
            return Optional.empty();
        }
        if (session instanceof BFoxSession) {
            return Optional.of(new FoxBoxHandler((BFoxSession)session));
        }
        return Optional.of(LocalBoxHandlerHolder.instance);
    }

    static ExecutorService getExecutorService() {
        BoxClientUtil.initExecutor();
        return executorSrv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initExecutor() {
        if (!executorStarted) {
            Object object = monitor;
            synchronized (object) {
                if (executorSrv == null) {
                    executorSrv = Executors.newFixedThreadPool(4, r -> new Thread(r, "boxUi"));
                    executorStarted = true;
                }
            }
        }
    }

    static {
        log = Logger.getLogger("box.wb");
    }

    private static final class LocalBoxHandlerHolder {
        private static final LocalBoxHandler instance = new LocalBoxHandler();

        private LocalBoxHandlerHolder() {
        }
    }

    private static final class LocalBoxHandler
    implements BoxHandler,
    IBoxEventHandler {
        private BBoxService service;
        private final Map<String, Consumer<String>> unsolicitedListeners = new HashMap<String, Consumer<String>>();

        private LocalBoxHandler() {
            try {
                this.service = new BBoxService();
                this.service.setEnableWebStorage(false);
                this.service.serviceStarted();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Cannot start local BoxService", e);
            }
        }

        @Override
        public String doSendBox(String data) throws Exception {
            BoxOp op = new BoxOp((Context)BFacets.make((String)"isWorkbench", (boolean)true), true, "127.0.0.1");
            op.put((Object)"boxEventHandler", (Object)this);
            StringWriter writer = new StringWriter();
            byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
            try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                this.service.handleRequest((InputStream)in, (Writer)writer, op);
            }
            return writer.toString();
        }

        @Override
        public void registerUnsolicitedListener(String id, Consumer<String> listener) {
            this.unsolicitedListeners.put(id, listener);
        }

        @Override
        public void unregisterUnsolicitedListener(String id) {
            this.unsolicitedListeners.remove(id);
        }

        public void writeBoxEvents(String id, byte[] data, Context cx) {
            Consumer<String> handler = this.unsolicitedListeners.get(id);
            if (handler != null) {
                handler.accept(new String(data, StandardCharsets.UTF_8));
            }
        }

        public boolean isClosed() {
            return false;
        }

        public boolean isMuxEnabled() {
            return false;
        }

        @Override
        public BOrd getHostOrd() {
            return BOrd.make((String)"local:");
        }

        @Override
        public BOrd getSessionOrdInHost() {
            return BOrd.make((String)"");
        }
    }

    private static final class FoxBoxHandler
    implements BoxHandler {
        private BFoxBoxChannel channel;
        private final BOrd hostOrd;
        private final BOrd sessionOrdInHost;

        private FoxBoxHandler(BFoxSession foxSession) {
            this.channel = (BFoxBoxChannel)foxSession.getConnection().getChannels().get("box");
            if (this.channel == null) {
                this.channel = new BFoxBoxChannel();
                foxSession.getConnection().getChannels().add("box", (BValue)this.channel);
            }
            this.hostOrd = foxSession.getHost().getAbsoluteOrd();
            this.sessionOrdInHost = foxSession.getOrdInHost();
        }

        @Override
        public String doSendBox(String data) throws Exception {
            return this.channel.sendBox(data);
        }

        @Override
        public void registerUnsolicitedListener(String id, Consumer<String> listener) {
            this.channel.registerUnsolicitedListener(id, listener);
        }

        @Override
        public void unregisterUnsolicitedListener(String id) {
            this.channel.unregisterUnsolicitedListener(id);
        }

        @Override
        public BOrd getHostOrd() {
            return this.hostOrd;
        }

        @Override
        public BOrd getSessionOrdInHost() {
            return this.sessionOrdInHost;
        }
    }

    static interface BoxHandler {
        default public CompletableFuture<String> sendBox(String data) {
            BoxClientUtil.initExecutor();
            CompletableFuture<String> future = new CompletableFuture<String>();
            executorSrv.submit(() -> {
                try {
                    future.complete(this.doSendBox(data));
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            });
            return future;
        }

        public String doSendBox(String var1) throws Exception;

        public void registerUnsolicitedListener(String var1, Consumer<String> var2);

        public void unregisterUnsolicitedListener(String var1);

        public BOrd getSessionOrdInHost();

        public BOrd getHostOrd();
    }
}

