/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.broker.BBrokerChannel;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.security.UrlWhitelist;
import com.tridium.ui.Binder;
import com.tridium.ui.PxIncludeManager;
import com.tridium.ui.theme.Theme;
import com.tridium.ux.WbWebWidgetServlet;
import com.tridium.web.BICollectionSupport;
import com.tridium.web.rpc.BLexiconRpc;
import com.tridium.web.servlets.ViewAllOrdServlet;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.util.WbUtil;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BWebBrowserOptions;
import com.tridium.workbench.web.browser.BoxClientUtil;
import com.tridium.workbench.web.browser.BrowserUtil;
import com.tridium.workbench.web.browser.IJs;
import com.tridium.workbench.web.browser.IWbJsCommand;
import com.tridium.workbench.web.browser.LoopbackNiagaraSession;
import com.tridium.workbench.web.browser.OfflineRequest;
import com.tridium.workbench.web.browser.OfflineResponse;
import com.tridium.workbench.web.browser.RemoteDebugCommand;
import com.tridium.workbench.web.browser.WbJsCommand;
import com.tridium.workbench.web.browser.WbJsToggleCommand;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.gx.BSize;
import javax.baja.gx.Point;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.space.BSpace;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.ui.BBinding;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.util.WebProperty;
import javax.baja.util.Version;
import javax.baja.web.BFormFactorEnum;
import javax.baja.web.BIFormFactorMax;
import javax.baja.web.BIOffline;
import javax.baja.web.BWebService;
import javax.baja.web.js.BIJavaScript;
import javax.baja.web.js.JsInfo;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.WbSys;
import javax.baja.workbench.view.BWbView;
import javax.baja.workbench.view.BWbViewBinding;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true", flags=0x40000000, override=true), @NiagaraProperty(name="js", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="preferredSize", type="BSize", defaultValue="BSize.make(BWebBrowser.DEFAULT_PREFERRED_WIDTH, BWebBrowser.DEFAULT_PREFERRED_HEIGHT)")})
@NiagaraActions(value={@NiagaraAction(name="browserInitialized"), @NiagaraAction(name="updateUrl", parameterType="BString", defaultValue="BString.DEFAULT"), @NiagaraAction(name="updateStatus", parameterType="BString", defaultValue="BString.DEFAULT"), @NiagaraAction(name="updateProgress", parameterType="BDouble", defaultValue="BDouble.DEFAULT"), @NiagaraAction(name="progressRunning", parameterType="BBoolean", defaultValue="BBoolean.DEFAULT"), @NiagaraAction(name="handleError", parameterType="BString", defaultValue="BString.DEFAULT"), @NiagaraAction(name="targetChanged")})
public final class BWebWidget
extends BWbView
implements BWebBrowser.IWebBrowserDropHandler,
AutoCloseable {
    public static final Property enabled = BWebWidget.newProperty((int)0x40000000, (boolean)true, null);
    public static final Property js = BWebWidget.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property preferredSize = BWebWidget.newProperty((int)0, (BValue)BSize.make((double)640.0, (double)480.0), null);
    public static final Action browserInitialized = BWebWidget.newAction((int)0, null);
    public static final Action updateUrl = BWebWidget.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action updateStatus = BWebWidget.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action updateProgress = BWebWidget.newAction((int)0, (BValue)BDouble.DEFAULT, null);
    public static final Action progressRunning = BWebWidget.newAction((int)0, (BValue)BBoolean.DEFAULT, null);
    public static final Action handleError = BWebWidget.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action targetChanged = BWebWidget.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BWebWidget.class);
    private volatile OrdTarget cachedOrdTarget;
    private volatile Optional<CompletableFuture<Void>> loadedFuture = Optional.empty();
    private volatile boolean reset;
    private volatile long startTicks;
    private volatile long initTicks;
    private volatile long loadTicks;
    private volatile long destroyTicks;
    private volatile String ordToLoad = "";
    private volatile String serverSessionId = "";
    private volatile boolean sameRemoteVersion = true;
    private volatile boolean legacyWebProperties;
    private BWebBrowser browser;
    private final WebWidgetUtil webWidgetUtil = new WebWidgetUtil(this);
    private final Map<IWbJsCommand, ?> commands = new WeakHashMap();
    private volatile BMenu menu;
    private volatile BToolBar toolBar;
    private final Object saveMonitor = new Object();
    private volatile boolean saved;
    private String saveErr;
    private final Object deactivateMonitor = new Object();
    private volatile boolean deactivated;
    private final Object dragOverMonitor = new Object();
    private volatile int dragOverRes;
    private static final long waitIncrement = 1000L;
    private static final long waitLimit = 50000L;
    private BoxClientUtil.BoxHandler boxHandler;
    private NavListener navListener;
    private static final String JSESSIONID = "JSESSIONID";
    private static final String LAST_SUPER_SESSION_ADD = "lastSuperSessionAdd";
    private static final Logger log = Logger.getLogger("webWidget");
    private BFormFactorEnum formFactor = BFormFactorEnum.max;
    private static final boolean USE_LOCAL_RC = "true".equals(AccessController.doPrivileged(() -> System.getProperty("niagara.useLocalWbRc", "true"))) && AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.module.dev.wb")) == false;
    public static final boolean DEBUG_DELAY = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.webwidget.debug.delay"));
    private volatile Runnable onLoaded;
    private volatile boolean closeOnStop = true;
    private volatile boolean extraLoadsComplete;
    private volatile boolean offline;
    public static final boolean IS_WEB_LAUNCHER = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.webLauncher"));
    private static final boolean NIAGARA_WEBBROWSER_UPDATABLE = AccessController.doPrivileged(() -> System.getProperty("niagara.webbrowser.updatable", "true")).equals("true");
    private static final boolean BOX_OVER_FOX = AccessController.doPrivileged(() -> System.getProperty("niagara.webwidget.boxfox", "true")).equals("true");

    public BOrd getJs() {
        return (BOrd)this.get(js);
    }

    public void setJs(BOrd v) {
        this.set(js, (BValue)v, null);
    }

    public BSize getPreferredSize() {
        return (BSize)this.get(preferredSize);
    }

    public void setPreferredSize(BSize v) {
        this.set(preferredSize, (BValue)v, null);
    }

    public void browserInitialized() {
        this.invoke(browserInitialized, null, null);
    }

    public void updateUrl(BString parameter) {
        this.invoke(updateUrl, (BValue)parameter, null);
    }

    public void updateStatus(BString parameter) {
        this.invoke(updateStatus, (BValue)parameter, null);
    }

    public void updateProgress(BDouble parameter) {
        this.invoke(updateProgress, (BValue)parameter, null);
    }

    public void progressRunning(BBoolean parameter) {
        this.invoke(progressRunning, (BValue)parameter, null);
    }

    public void handleError(BString parameter) {
        this.invoke(handleError, (BValue)parameter, null);
    }

    public void targetChanged() {
        this.invoke(targetChanged, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BWebWidget() {
    }

    public BWebWidget(AgentInfo agentInfo) {
        this.recordAgentId(agentInfo, null);
    }

    public BWebWidget(AgentInfo agentInfo, OrdTarget target) {
        this.recordAgentId(agentInfo, target);
    }

    public BWebWidget(AgentInfo agentInfo, OrdTarget target, BFormFactorEnum formFactor) {
        this.recordAgentId(agentInfo, target);
        this.formFactor = formFactor;
    }

    public void started() throws Exception {
        block25: {
            BOrd startedOrd = null;
            try {
                BOrd ord;
                this.reset = false;
                this.loadedFuture = Optional.of(new CompletableFuture());
                if (this.browser == null) {
                    Map<String, String> options = BBoolean.TRUE.equals((Object)this.get("exporting")) ? Collections.singletonMap("forceStationBrowserInit", Boolean.TRUE.toString()) : Collections.emptyMap();
                    this.browser = new BWebBrowser(options);
                    this.browser.setWhitelist(UrlWhitelist.ALLOW_ALL);
                    this.buildInitialToolbar();
                    if (BBoolean.TRUE.equals((Object)this.get("forceInitialize"))) {
                        this.browser.forceInitialize();
                    }
                    this.browser.setCloseOnStop(this.isCloseOnStop());
                    this.browser.setOnRegisterFunctions(this::onRegisterFunctions);
                    this.browser.setOnLoaded(this::onLoaded);
                    this.browser.setContextMenuEnabled(false);
                    this.browser.setShowProgressIndicator(true);
                    this.linkTo((BComponent)this.browser, (Slot)BWebBrowser.location, (Slot)updateUrl);
                    this.linkTo((BComponent)this.browser, (Slot)BWebBrowser.statusMsg, (Slot)updateStatus);
                    this.linkTo((BComponent)this.browser, (Slot)BWebBrowser.progressRunning, (Slot)progressRunning);
                    this.linkTo((BComponent)this.browser, (Slot)BWebBrowser.progress, (Slot)updateProgress);
                    this.linkTo((BComponent)this.browser, (Slot)BWebBrowser.error, (Slot)handleError);
                    this.linkTo((BComponent)this.browser, (Slot)BWebBrowser.initialized, (Slot)browserInitialized);
                    for (BBinding binding : this.getBindings()) {
                        this.linkTo((BComponent)binding, (Slot)BBinding.targetChanged, (Slot)targetChanged);
                    }
                    BEdgePane pane = new BEdgePane();
                    pane.setCenter((BWidget)this.browser);
                    this.setContent((BWidget)pane);
                    pane.setSize(this.getWidth(), this.getHeight());
                }
                if ((ord = this.getJs()).isNull() || this.browser.isStub()) {
                    this.loadedFuture.get().complete(null);
                    return;
                }
                BISession session = this.findSession();
                this.startTicks = Clock.ticks();
                OrdQuery[] queries = ord.parse();
                this.browser.setDropHandler(this);
                if (this.browser.isInitialized() && this.hasRequireDefined()) {
                    this.reinitialize();
                    break block25;
                }
                BFoxSession foxSession = session instanceof BFoxSession ? (BFoxSession)session : null;
                ArrayList<String[]> queryList = new ArrayList<String[]>();
                for (int i = 0; i < queries.length; ++i) {
                    if (!(queries[i] instanceof ViewQuery)) continue;
                    ViewQuery viewQuery = (ViewQuery)queries[i];
                    String id = viewQuery.getViewId();
                    if (id == null) {
                        id = "";
                    }
                    try {
                        TypeInfo typeInfo = Sys.getRegistry().getType(id);
                        if (!Sys.isStation() && foxSession == null && typeInfo.is(BIOffline.TYPE)) {
                            this.offline = true;
                        }
                    }
                    catch (TypeNotFoundException typeInfo) {
                        // empty catch block
                    }
                    queries[i] = new ViewQuery("view", id);
                    if (foxSession != null) {
                        this.sameRemoteVersion = WbSys.isRemoteVersionTheSame(foxSession.getConnection().session());
                        Version remoteVersion = foxSession.getConnection().getRemoteVersion();
                        this.legacyWebProperties = remoteVersion != null && remoteVersion.compareTo(FoxSession.VERSION_4_4) < 0;
                    } else {
                        this.legacyWebProperties = false;
                    }
                    String[] paramNames = viewQuery.getParameterNames();
                    if (paramNames.length <= 0) break;
                    for (String name : paramNames) {
                        queryList.add(new String[]{name, viewQuery.getParameter(name)});
                    }
                    break;
                }
                this.boxHandler = BoxClientUtil.makeHandler(session).orElse(null);
                String themeName = Theme.getInstalledThemeName();
                if (themeName != null) {
                    queryList.add(new String[]{"theme", themeName});
                }
                queryList.add(new String[]{"formFactor", this.formFactor.getTag()});
                queryList.add(new String[]{"useLocalWbRc", String.valueOf(this.offline || USE_LOCAL_RC && this.sameRemoteVersion && this.getBrowser().canUseLocalWbResources())});
                queryList.add(new String[]{"attachAfterInit", String.valueOf(!this.isInViewTab() && this.getWbViewBinding() == null)});
                String query = queryList.stream().map(entry -> entry[0] + "=" + entry[1]).collect(Collectors.joining("&"));
                URI uri = BWebWidget.makeUri(this, this.browser, session, "/bajaux/webwidget/" + BOrd.make((OrdQuery[])queries), query);
                if (this.offline) {
                    WbWebWidgetServlet servlet = new WbWebWidgetServlet();
                    OfflineRequest req = new OfflineRequest(uri, Collections.singletonMap("niagara.context", new BasicContext()), this.browser.isJavaFx() ? Collections.singletonMap("User-Agent", "JavaFX") : Collections.emptyMap());
                    final OfflineResponse resp = new OfflineResponse();
                    servlet.service((ServletRequest)req, (ServletResponse)resp);
                    if (resp.getStatus() != 200) {
                        throw new IOException("Could not write Web Widget HTML: " + resp.getErrorMsg());
                    }
                    this.browser.load(new BObject(){

                        public String toString(Context context) {
                            return resp.getContentAsString();
                        }
                    }, this.getCurrentContext());
                } else if (!this.browser.isStub()) {
                    FoxSession sess;
                    if (foxSession != null && (sess = foxSession.getConnection().session()) != null) {
                        this.navListener = new FoxSessionRemoveListener(foxSession, this.browser, uri);
                        BNavRoot.INSTANCE.addNavListener(this.navListener);
                    }
                    startedOrd = BOrd.make((String)uri.toASCIIString());
                    this.browser.load((BObject)startedOrd, this.getCurrentContext());
                } else {
                    this.loadedFuture.get().complete(null);
                }
                if (log.isLoggable(Level.INFO)) {
                    log.info("Loading: " + uri.toASCIIString());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                String msg = "";
                if (e instanceof LocalizableException) {
                    msg = ((LocalizableException)e).toString(null);
                }
                if (e instanceof LocalizableRuntimeException) {
                    msg = ((LocalizableRuntimeException)e).toString(null);
                }
                this.setContent(WbUtil.makeErrorPane(this, msg, startedOrd, e));
            }
        }
    }

    @Override
    public void computePreferredSize() {
        double w = this.getPreferredSize().width();
        double h = this.getPreferredSize().height();
        this.setPreferredSize(w, h);
    }

    public static URI makeUri(BWidget owner, BWebBrowser browser, BISession session, String ord, String query) throws Exception {
        boolean allowCookieSwap;
        BComponent details = BWebWidget.getHttpConnectionDetails(session);
        BFoxSession foxSession = session instanceof BFoxSession ? (BFoxSession)session : null;
        BLocalHost host = BLocalHost.INSTANCE;
        boolean isSecure = true;
        if (foxSession != null) {
            isSecure = foxSession.getUseFoxs() || ((BBoolean)details.get("httpsEnabled")).getBoolean();
            host = foxSession.getHost();
        } else if (Sys.isStation()) {
            isSecure = ((BBoolean)details.get("httpsEnabled")).getBoolean();
        }
        int port = BWebWidget.getPort(details, isSecure);
        URI uri = new URI(isSecure ? "https" : "http", null, browser.toHostAddr((BHost)host), port, ord, query, null);
        boolean bl = allowCookieSwap = !IS_WEB_LAUNCHER || !browser.isJavaFx();
        if (foxSession != null && allowCookieSwap) {
            try {
                AccessController.doPrivileged(() -> {
                    FoxSession sess = foxSession.getConnection().session();
                    if (sess != null) {
                        FoxSession foxSession2 = sess;
                        synchronized (foxSession2) {
                            Optional expectedSessionId = sess.getFromCache("jsession");
                            if (!expectedSessionId.isPresent() || !browser.isCookiePresent(uri, JSESSIONID, (String)expectedSessionId.get(), "/")) {
                                String superSessionId = sess.getRemoteSuperId();
                                Optional optional = sess.getFromCache(LAST_SUPER_SESSION_ADD);
                                String lastId = optional.orElse(null);
                                if (lastId == null || !lastId.equals(superSessionId)) {
                                    browser.addCookie(uri, "super_session_id", superSessionId, "/");
                                    browser.removeCookie(uri, JSESSIONID, "/");
                                    sess.getFromCache(LAST_SUPER_SESSION_ADD, v -> superSessionId);
                                }
                            }
                        }
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        } else if (Sys.isStation() && !browser.isStub() && BLocalHost.INSTANCE.equals((Object)host)) {
            AccessController.doPrivileged(() -> {
                String id = LoopbackNiagaraSession.getLoopbackHttpSessionId();
                if (id.isEmpty()) {
                    browser.removeCookie(uri, JSESSIONID, "/");
                    browser.addCookie(uri, "super_session_id", LoopbackNiagaraSession.getLoopbackSuperSessionId(), "/");
                } else {
                    String oldId = browser.getCookieValue(uri, JSESSIONID, "/").orElse("");
                    if (!id.equals(oldId)) {
                        browser.removeCookie(uri, JSESSIONID, "/");
                        browser.addCookie(uri, JSESSIONID, id, "/");
                    }
                }
                return null;
            });
        }
        return uri;
    }

    public static BComponent getHttpConnectionDetails(BISession session) {
        BFoxSession foxSession = session instanceof BFoxSession ? (BFoxSession)session : null;
        BComponent details = null;
        if (foxSession != null) {
            details = (BComponent)foxSession.getConnection().session().getFromCache("httpDetails", key -> {
                BBrokerChannel channel = (BBrokerChannel)foxSession.getConnection().getChannels().get("station");
                return channel.getHttpConnectionDetails();
            });
        } else if (Sys.isStation()) {
            BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
            details = webService.getHttpConnectionDetails(null);
        }
        if (details == null) {
            details = new BComponent();
            details.add("enabled", (BValue)BBoolean.TRUE);
            details.add("httpEnabled", (BValue)BBoolean.FALSE);
            details.add("httpsEnabled", (BValue)BBoolean.TRUE);
            details.add("httpPort", (BValue)BInteger.make((int)80));
            details.add("httpsPort", (BValue)BInteger.make((int)443));
        }
        return details;
    }

    public static int getPort(BComponent details, boolean isSecure) {
        int port = -1;
        BBoolean webServiceEnabledValue = (BBoolean)details.get("enabled");
        BBoolean httpEnabledValue = (BBoolean)details.get("httpEnabled");
        boolean httpsEnabled = ((BBoolean)details.get("httpsEnabled")).getBoolean();
        boolean httpEnabled = httpEnabledValue == null ? !httpsEnabled : httpEnabledValue.getBoolean();
        int httpsPort = ((BInteger)details.get("httpsPort")).getInt();
        int httpPort = ((BInteger)details.get("httpPort")).getInt();
        if (!httpsEnabled && !httpEnabled && httpEnabledValue != null || webServiceEnabledValue != null && !webServiceEnabledValue.getBoolean()) {
            throw new LocalizableRuntimeException("workbench", "httpFox.noWebService.details");
        }
        if (isSecure && !httpsEnabled) {
            throw new LocalizableRuntimeException("workbench", "httpFox.mismatch.details");
        }
        if (!isSecure && !httpEnabled) {
            if (httpEnabledValue == null && httpsEnabled) {
                isSecure = true;
            } else {
                throw new LocalizableRuntimeException("workbench", "httpFox.mismatch.details");
            }
        }
        if (isSecure) {
            if (httpsPort != 443) {
                port = httpsPort;
            }
        } else if (httpPort != 80) {
            port = httpPort;
        }
        return port;
    }

    public String getWidgetTypeSpec() {
        BOrd ord = this.getJs();
        if (ord.isNull()) {
            return "";
        }
        return Arrays.stream(ord.parse()).filter(q -> q instanceof ViewQuery).map(q -> Objects.toString(((ViewQuery)q).getViewId(), "")).findFirst().orElse("");
    }

    private void reinitialize() {
        OrdTarget target;
        this.extraLoadsComplete = false;
        Optional<TypeInfo> wTypeInfo = this.getTypeInfoFromJs();
        BIJavaScript webWidget = (BIJavaScript)wTypeInfo.get().getInstance();
        BWbShell shell = BrowserUtil.findWbShell((BComplex)this);
        if (shell != null) {
            target = shell.getActiveOrdTarget();
        } else {
            BWbViewBinding binding = this.getWbViewBinding();
            OrdTarget ordTarget = target = binding != null ? binding.getTarget() : null;
        }
        if (target == null) {
            return;
        }
        BWebBrowser.post(this.browser, () -> {
            String initCall;
            JsInfo jsInfo = webWidget.getJsInfo(this.getCurrentContext());
            boolean hasBuiltJs = jsInfo.hasBuiltJs();
            TypeInfo widgetTypeInfo = webWidget.getType().getTypeInfo();
            JSONObject params = null;
            try {
                params = WbWebWidgetServlet.getParameters((OrdTarget)target);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Could not decode parameters: " + target.getOrd(), e);
            }
            String script = initCall = "require(['" + jsInfo.getJsId() + "'], function (Widget) {\n  if (Widget.__esModule) { Widget = Widget.default || Widget; }\n  var widget = new Widget('" + widgetTypeInfo.getModuleName() + "', '" + widgetTypeInfo.getTypeName() + "');\n  window.wbContainer.initialize(widget, " + params + ")\n    .catch(function (err) {\n      console.error('wbContainer failed to initialize');\n      console.error(err);\n    });\n});";
            if (hasBuiltJs) {
                String builtIds = Arrays.stream(jsInfo.getBuiltJsIds()).map(jsid -> "'" + jsid + "'").collect(Collectors.joining(",\n"));
                script = "require([" + builtIds + "], function () {\n" + initCall + "\n});";
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "BWebWidget#reinitialize() script:\n" + script);
            }
            this.browser.executeScriptAsync(script);
        });
    }

    @Override
    protected void doLoadValue(BObject value, Context context) throws Exception {
        BOrd ord = this.findOrd(value);
        if (ord.isNull()) {
            throw new Exception("Unsupported value for WebWidget: " + value.getType());
        }
        String ordStr = ord.relativizeToSession().toString();
        BWebBrowser.post(this.browser, () -> {
            if (this.webWidgetUtil.state != WebWidgetState.uninitialized) {
                if (!this.extraLoads()) {
                    this.getJsContainer().call("load", ordStr);
                }
            } else {
                this.ordToLoad = ordStr;
                if (this.reset) {
                    this.reset = false;
                    this.reinitialize();
                }
            }
        });
    }

    private boolean extraLoads() {
        Optional<TypeInfo> wTypeInfo = this.getTypeInfoFromJs();
        if (wTypeInfo.isPresent() && !wTypeInfo.get().is(BICollectionSupport.TYPE)) {
            return false;
        }
        if (!this.extraLoadsComplete) {
            this.extraLoadsComplete = true;
            List<BWbViewBinding> bindings = this.getViewBindings();
            if (bindings.size() > 1) {
                for (BBinding bBinding : bindings) {
                    this.getJsContainer().call("load", this.getOrdFromBinding(bBinding).toString());
                }
                return true;
            }
        }
        return false;
    }

    private BOrd findOrd(BObject value) {
        BOrd ord = BOrd.NULL;
        if (this.isInViewTab()) {
            BOrd activeOrd;
            BWbShell shell = BWbShell.getWbShell(this);
            if (shell != null && (activeOrd = shell.getActiveOrd()) != null) {
                ord = activeOrd.relativizeToSession();
            }
        } else {
            BWbViewBinding binding = this.getWbViewBinding();
            if (binding != null) {
                ord = this.getOrdFromBinding(binding);
            }
        }
        if (ord.isNull() && value instanceof BINavNode) {
            ord = ((BINavNode)value).getNavOrd().relativizeToSession();
        }
        return ord;
    }

    private BOrd getOrdFromBinding(BBinding binding) {
        OrdTarget baseOrdTarget;
        BOrd base = this.cachedOrdTarget != null ? this.cachedOrdTarget.getOrd() : null;
        Binder binder = WbUtil.getBinder((BComplex)this);
        if (binder != null && (baseOrdTarget = binder.getBase()) != null) {
            base = baseOrdTarget.getOrd();
        }
        return BWebWidget.getOrdFromBinding(binding, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (this.loadedFuture.isPresent() && this.loadedFuture.get().isDone()) {
            BWebBrowser.post(this.browser, () -> {
                try {
                    IJs container = this.getJsContainer();
                    if (container != null && !container.isNull()) {
                        this.browser.executeScript("window.wbContainer.save();");
                    } else {
                        this.webWidgetUtil.saveOk();
                    }
                }
                catch (Throwable e) {
                    this.webWidgetUtil.saveFail(e.getMessage());
                }
            });
            Object object = this.saveMonitor;
            synchronized (object) {
                try {
                    long count = 0L;
                    while (!this.saved) {
                        if (count >= 50000L) {
                            break;
                        }
                        BISession sess = this.findSession();
                        if (!this.offline) {
                            if (sess == BLocalHost.INSTANCE) break;
                            if (!sess.isConnected()) {
                                break;
                            }
                        }
                        this.saveMonitor.wait(1000L);
                        count += 1000L;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.saved = false;
                }
            }
            if (this.saveErr != null) {
                throw new CannotSaveException(this.saveErr);
            }
        }
        return super.doSaveValue(value, cx);
    }

    public void stopped() throws Exception {
        if (!this.isInViewTab()) {
            this.cleanup();
        }
    }

    @Override
    public void close() {
        if (this.navListener != null) {
            BNavRoot.INSTANCE.removeNavListener(this.navListener);
        }
        if (this.boxHandler != null) {
            this.boxHandler.unregisterUnsolicitedListener(this.serverSessionId);
        }
        this.getBrowser().close();
        this.cachedOrdTarget = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivated() {
        if (this.browser.isStub()) {
            return;
        }
        if (this.loadedFuture.isPresent() && this.loadedFuture.get().isDone()) {
            BISession session = this.findSession();
            BWebBrowser.post(this.browser, () -> {
                try {
                    IJs container = this.getJsContainer();
                    if (container != null && !container.isNull()) {
                        this.browser.executeScript("window.wbContainer.deactivate();");
                    } else {
                        this.webWidgetUtil.deactivated();
                    }
                }
                catch (Throwable e) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Cannot deactivate", e);
                    }
                    this.webWidgetUtil.deactivated();
                }
            });
            Object object = this.deactivateMonitor;
            synchronized (object) {
                try {
                    long count = 0L;
                    while (!this.deactivated) {
                        if (count >= 50000L) {
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "Cannot deactivate within wait limit of 50000ms");
                            }
                            break;
                        }
                        BISession sess = this.findSession();
                        if (!this.offline) {
                            if (sess == BLocalHost.INSTANCE) break;
                            if (!sess.isConnected()) {
                                break;
                            }
                        }
                        this.deactivateMonitor.wait(1000L);
                        count += 1000L;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.deactivated = false;
                }
            }
        }
        if (this.loadedFuture.isPresent() && !this.loadedFuture.get().isDone()) {
            this.loadedFuture.get().complete(null);
        }
        this.webWidgetUtil.state = WebWidgetState.uninitialized;
        this.cleanup();
    }

    private void cleanup() {
        if (this.getBrowser().isCloseOnStop()) {
            this.close();
        }
    }

    public void changed(Property prop, Context context) {
        if (prop.equals(preferredSize)) {
            this.computePreferredSize();
        }
        if (this.webWidgetUtil.state == WebWidgetState.initialized && WebProperty.isWebProperty((BComplex)this, (Property)prop)) {
            BWebBrowser.post(this.browser, () -> {
                try {
                    JSONObject encodedProperty = WebProperty.encodeProperty((BWidget)this, (Property)prop);
                    Object propertyValue = encodedProperty.get("value");
                    this.getJsWidget().call("properties", new Object[0]).call("setValue", SlotPath.unescape((String)prop.getName()), propertyValue, "ext");
                    if (encodedProperty.has("metadata") && !this.legacyWebProperties) {
                        JSONObject propertyMetadata = encodedProperty.getJSONObject("metadata");
                        this.getJsWidget().call("properties", new Object[0]).call("setMetadata", SlotPath.unescape((String)prop.getName()), propertyMetadata, "ext");
                    }
                }
                catch (IOException ex) {
                    log.log(Level.SEVERE, "Could not set Web Property in JS: " + prop.getName(), ex);
                }
            });
        }
        super.changed(prop, context);
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 406) {
            return this.reset((OrdTarget)a, (AgentInfo)b);
        }
        return super.fw(x, a, b, c, d);
    }

    public void setOnLoaded(Runnable onLoaded) {
        this.onLoaded = onLoaded;
    }

    private boolean reset(OrdTarget target, AgentInfo agentInfo) {
        BISession session;
        if (!NIAGARA_WEBBROWSER_UPDATABLE) {
            return false;
        }
        BSpace space = target.getSpace();
        BISession bISession = session = space != null ? space.getSession() : null;
        if (this.offline && session instanceof BFoxSession) {
            return false;
        }
        BISession oldSession = this.getCurrentValueSession();
        if (session != null && oldSession != null && !session.equals(oldSession)) {
            return false;
        }
        if (this.isCloseOnStop()) {
            return false;
        }
        BObject obj = agentInfo.getInstance();
        if (obj instanceof BIFormFactorMax && obj instanceof BIJavaScript && this.browser != null && this.browser.isInitialized() && this.hasRequireDefined()) {
            Property[] webProps;
            this.webWidgetUtil.state = WebWidgetState.uninitialized;
            this.recordAgentId(agentInfo, target);
            for (Property prop : webProps = this.getPropertiesArray()) {
                if (!WebProperty.isWebProperty((BComplex)this, (Property)prop) || !prop.isDynamic()) continue;
                this.remove(prop);
            }
            this.reset = true;
            return true;
        }
        return false;
    }

    public BMenu[] getViewMenus() {
        BMenu[] bMenuArray;
        if (this.menu == null) {
            bMenuArray = null;
        } else {
            BMenu[] bMenuArray2 = new BMenu[1];
            bMenuArray = bMenuArray2;
            bMenuArray2[0] = this.menu;
        }
        return bMenuArray;
    }

    public BToolBar getViewToolBar() {
        return this.toolBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildMenu(Optional<JSONObject> groupData) {
        Map<IWbJsCommand, ?> map = this.commands;
        synchronized (map) {
            this.commands.clear();
        }
        BMenu m = null;
        boolean added = false;
        if (groupData.isPresent()) {
            m = new BMenu(JSONUtil.getString((JSONObject)groupData.get(), (String)"displayName"));
            added = this.buildMenu(m, groupData.get().getJSONArray("kids"));
        }
        if (BWebWidget.isWebDevMode()) {
            if (m == null) {
                m = new BMenu(this.getDisplayName(null));
            }
            m.add("remoteDebugCmd", (Command)new RemoteDebugCommand(this.browser));
            added = true;
        }
        this.menu = m != null && added ? m : null;
    }

    private boolean buildMenu(BMenu menu, JSONArray kids) {
        boolean added = false;
        for (int i = 0; i < kids.length(); ++i) {
            JSONObject obj = kids.getJSONObject(i);
            if (obj.getBoolean("command") && obj.getBoolean("menu")) {
                added = true;
                menu.add("jsCmd?", this.makeCmd(obj));
                continue;
            }
            BMenu newMenu = new BMenu(JSONUtil.getString((JSONObject)obj, (String)"displayName"));
            BSubMenuItem subMenu = new BSubMenuItem((BIMenu)newMenu);
            if (!obj.has("kids") || !this.buildMenu(newMenu, obj.getJSONArray("kids"))) continue;
            added = true;
            menu.add("jsCmdGroup?", (BValue)subMenu);
        }
        return added;
    }

    private void buildInitialToolbar() {
        BToolBar tb = null;
        boolean added = false;
        if (BWebWidget.isWebDevMode()) {
            if (tb == null) {
                tb = new BToolBar();
            }
            tb.add("remoteDebugCmd", (Command)new RemoteDebugCommand(this.browser));
            added = true;
        }
        this.toolBar = tb != null && added ? tb : null;
    }

    private void buildToolbar(Optional<JSONObject> groupData) {
        BToolBar tb = null;
        boolean added = false;
        if (groupData.isPresent()) {
            tb = new BToolBar();
            added = this.buildToolbar(tb, groupData.get().getJSONArray("kids"));
        }
        if (BWebWidget.isWebDevMode()) {
            if (tb == null) {
                tb = new BToolBar();
            }
            tb.add("remoteDebugCmd", (Command)new RemoteDebugCommand(this.browser));
            added = true;
        }
        this.toolBar = tb != null && added ? tb : null;
    }

    private boolean buildToolbar(BToolBar tb, JSONArray kids) {
        boolean added = false;
        for (int i = 0; i < kids.length(); ++i) {
            JSONObject obj = kids.getJSONObject(i);
            if (obj.getBoolean("command") && obj.getBoolean("toolbar")) {
                added = true;
                tb.add("jsCmd?", this.makeCmd(obj));
                continue;
            }
            if (!obj.has("kids") || !this.buildToolbar(tb, obj.getJSONArray("kids"))) continue;
            added = true;
        }
        return added;
    }

    private static boolean isWebDevMode() {
        return BWidget.getApplication() != null && BWebBrowserOptions.get().getWebDevelopmentTools();
    }

    public void doUpdateUrl(BString url) {
        this.doUpdateStatus(url);
    }

    public void doUpdateStatus(BString msg) {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            shell.showStatus(msg.getString());
        }
    }

    public void doUpdateProgress(BDouble progress) {
        this.doUpdateStatus(BString.make((String)((int)this.browser.getProgress() + "%: " + this.browser.getOrd())));
    }

    public void doProgressRunning(BBoolean running) {
        this.doUpdateStatus(BString.make((String)this.browser.getLocation()));
    }

    public void doHandleError(BString error) {
        BWebBrowser.log.severe(error.toString());
    }

    private void onRegisterFunctions() {
        WeakReference<BWebWidget> ownerRef = new WeakReference<BWebWidget>(this);
        this.browser.registerConsumer("niagara_env_hyperlink", ordStr -> BWebBrowser.post(this.browser, () -> {
            Optional<String> os;
            BOrd activeOrd;
            BWbShell shell;
            BWidget owner = (BWidget)ownerRef.get();
            if (owner != null && (shell = BWbShell.getWbShell(owner)) != null && (activeOrd = shell.getActiveOrd()) != null && (os = this.browser.fromJsToString(ordStr)).isPresent()) {
                BOrd ord = BOrd.make((BOrd)activeOrd, (String)os.get());
                BWidget.invokeLater(() -> shell.hyperlink(ord));
            }
        }));
        this.browser.register("niagara_env_reload", () -> BWidget.invokeLater(() -> {
            BWbShell shell;
            BWidget owner = (BWidget)ownerRef.get();
            if (owner != null && (shell = BWbShell.getWbShell(owner)) != null) {
                PxIncludeManager.trimAll();
                shell.getRefreshCommand().invoke();
            }
        }));
        this.browser.registerSupplier("niagara_env_getSessionOrd", () -> {
            BISession session = this.getCurrentValueSession();
            if (session != null) {
                return session.getNavOrd().toString();
            }
            return null;
        });
        this.browser.registerSupplier("niagara_env_getBaseOrd", () -> {
            BOrd ord;
            OrdTarget base;
            Binder binder = WbUtil.getBinder((BComplex)this);
            if (binder != null && (base = binder.getBase()) != null && (ord = base.getOrd()) != null) {
                return ord.toString();
            }
            return null;
        });
        this.browser.registerFunction("niagara_env_listViews", this.webWidgetUtil::listViews);
        this.browser.register("niagara_wb_util_initializing", this.webWidgetUtil::initializing);
        this.browser.register("niagara_wb_util_initialized", this.webWidgetUtil::initialized);
        this.browser.register("niagara_wb_util_loaded", this.webWidgetUtil::loaded);
        this.browser.registerConsumer("niagara_wb_util_error", this.webWidgetUtil::error);
        this.browser.registerConsumer("niagara_wb_util_hyperlink", this.webWidgetUtil::hyperlink);
        this.browser.registerConsumer("niagara_wb_util_buildCommands", this.webWidgetUtil::buildCommands);
        this.browser.registerConsumer("niagara_wb_util_updateCommand", this.webWidgetUtil::updateCommand);
        this.browser.register("niagara_wb_util_setModified", this.webWidgetUtil::setModified);
        this.browser.register("niagara_wb_util_clearModified", this.webWidgetUtil::clearModified);
        this.browser.register("niagara_wb_util_saveOk", this.webWidgetUtil::saveOk);
        this.browser.registerConsumer("niagara_wb_util_saveFail", this.webWidgetUtil::saveFail);
        this.browser.register("niagara_wb_util_save", this.webWidgetUtil::save);
        this.browser.register("niagara_wb_util_deactivated", this.webWidgetUtil::deactivated);
        this.browser.register("niagara_wb_util_destroying", this.webWidgetUtil::destroying);
        this.browser.register("niagara_wb_util_destroyed", this.webWidgetUtil::destroyed);
        this.browser.registerFunction("niagara_wb_util_syncProperties", this.webWidgetUtil::syncProperties);
        this.browser.registerSupplier("niagara_wb_util_getProperties", this.webWidgetUtil::getProperties);
        this.browser.registerBiConsumer("niagara_wb_util_propertyChanged", this.webWidgetUtil::propertyChanged);
        this.browser.registerBiConsumer("niagara_wb_util_metadataChanged", this.webWidgetUtil::metadataChanged);
        this.browser.registerConsumer("niagara_wb_util_startDrag", this.webWidgetUtil::startDrag);
        this.browser.registerConsumer("niagara_wb_util_dragCallback", this.webWidgetUtil::dragCallback);
        this.browser.registerSupplier("niagara_wb_util_isCommandBarVisible", this.webWidgetUtil::isCommandBarVisible);
        this.browser.registerBiFunction("niagara_wb_util_getLexicon", this.webWidgetUtil::getLexicon);
        this.browser.registerConsumer("niagara_wb_util_setServerSessionId", this.webWidgetUtil::setServerSessionId);
        this.browser.registerConsumer("niagara_wb_util_playSound", this.webWidgetUtil::playSound);
        this.browser.registerConsumer("niagara_wb_util_stopSound", this.webWidgetUtil::stopSound);
        if (BOX_OVER_FOX && !Sys.isStation()) {
            this.browser.registerConsumer("niagara_wb_util_sendBox", this.webWidgetUtil::sendBox);
            this.browser.registerSupplier("niagara_wb_util_getHostOrd", this.webWidgetUtil::getHostOrd);
            this.browser.registerSupplier("niagara_wb_util_getSessionOrdInHost", this.webWidgetUtil::getSessionOrdInHost);
        }
    }

    private void onLoaded() {
        BISession session = this.findSession();
        if (session instanceof BFoxSession) {
            URI uri;
            FoxSession sess = ((BFoxSession)session).getConnection().session();
            try {
                uri = new URI(this.browser.executeScript("window.location.href").toString());
            }
            catch (URISyntaxException e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            AccessController.doPrivileged(() -> {
                this.browser.getCookieValue(uri, JSESSIONID, "/").ifPresent(val -> {
                    String cfr_ignored_0 = (String)sess.getFromCache("jsession", v -> val);
                });
                return null;
            });
        }
        if (this.onLoaded != null) {
            this.onLoaded.run();
        }
        String wbLoaded = "window.wbLoaded();";
        if (DEBUG_DELAY) {
            wbLoaded = "setTimeout(wbLoaded, 5000);";
        }
        this.browser.executeScriptAsync("(function () {window.wbHasLoaded = true;if (typeof window.wbLoaded === 'function') {" + wbLoaded + "}}());");
    }

    public void doTargetChanged() {
        if (this.webWidgetUtil.state == WebWidgetState.initialized) {
            BWebBrowser.post(this.browser, () -> {
                BWebWidget widget = this;
                Property[] nprops = widget.getPropertiesArray();
                if (nprops.length == 0) {
                    return;
                }
                HashMap<String, Object> map = null;
                for (Property p : nprops) {
                    if (!WebProperty.isWebProperty((BComplex)widget, (Property)p)) continue;
                    if (map == null) {
                        map = new HashMap<String, Object>();
                    }
                    try {
                        if (this.legacyWebProperties) {
                            map.put(SlotPath.unescape((String)p.getName()), WebProperty.encodeValue((BValue)widget.get(p)));
                            continue;
                        }
                        map.put(SlotPath.unescape((String)p.getName()), WebProperty.encodeProperty((BWidget)widget, (Property)p));
                    }
                    catch (IOException ex) {
                        log.log(Level.SEVERE, "Could not set Web Property in JS: " + p.getName(), ex);
                    }
                }
                if (map != null) {
                    widget.getJsContainer().call("updateProperties", this.webWidgetUtil.toJsonStr(map));
                }
            });
        }
    }

    public void doBrowserInitialized() {
        String dataUri = String.format("data:,body{ font-size: %spx; }", Theme.label().getTextFont().getSize());
        AccessController.doPrivileged(() -> {
            BWebBrowser.post(this.browser, () -> this.browser.setUserAgentStyleSheetLocation(dataUri));
            return null;
        });
    }

    private BISession findSession() {
        BWbViewBinding binding;
        BISession session = this.getCurrentValueSession();
        if (!BWebWidget.isUsableRemoteSession(session) && (binding = this.getWbViewBinding()) != null && binding.getTarget() != null && binding.getTarget().getComponent() != null) {
            session = binding.getTarget().getComponent().getSession();
        }
        if (!BWebWidget.isUsableRemoteSession(session)) {
            session = WbUtil.findSession(this);
        }
        if (!BWebWidget.isUsableRemoteSession(session)) {
            BISession cachedSession;
            BISession bISession = cachedSession = this.cachedOrdTarget != null && this.cachedOrdTarget.getSpace() != null ? this.cachedOrdTarget.getSpace().getSession() : null;
            if (BWebWidget.isUsableRemoteSession(cachedSession)) {
                return cachedSession;
            }
        }
        return session;
    }

    private static boolean isUsableRemoteSession(BISession session) {
        return session != null && !(session instanceof BLocalHost);
    }

    public void setCachedOrdTarget(OrdTarget ordTarget) {
        this.cachedOrdTarget = ordTarget;
    }

    public BWbViewBinding getWbViewBinding() {
        for (BBinding binding : this.getBindings()) {
            if (!(binding instanceof BWbViewBinding) || !binding.isBound()) continue;
            return (BWbViewBinding)binding;
        }
        return null;
    }

    public List<BWbViewBinding> getViewBindings() {
        return Arrays.stream(this.getBindings()).filter(b -> b instanceof BWbViewBinding && b.isBound()).map(b -> (BWbViewBinding)((Object)b)).collect(Collectors.toList());
    }

    IJs getJsWidget() {
        return this.browser.executeScript("window.wbWidget");
    }

    IJs getJsContainer() {
        return this.browser.executeScript("window.wbContainer");
    }

    public BWebBrowser getBrowser() {
        return this.browser;
    }

    public boolean isCloseOnStop() {
        return this.closeOnStop;
    }

    public void setCloseOnStop(boolean closeOnStop) {
        this.closeOnStop = closeOnStop;
        if (this.browser != null) {
            this.browser.setCloseOnStop(closeOnStop);
        }
    }

    public void executeScript(String script) {
        BWebBrowser.post(this.browser, () -> this.browser.executeScriptAsync(script));
    }

    private boolean hasRequireDefined() {
        try {
            return this.browser != null && this.browser.executeScriptAndWait("typeof window.require === 'function'").toBool();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Unable to check for require", e);
            }
            return false;
        }
    }

    public Optional<CompletableFuture<Void>> getLoadedFuture() {
        return this.loadedFuture;
    }

    private void onBoxResponseMessage(String boxFrame) {
        BWebBrowser.post(this.browser, () -> {
            IJs wbSocket = this.browser.executeScript("window.wbSocket");
            if (wbSocket.isObject()) {
                wbSocket.call("onMessageStr", boxFrame);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Command makeCmd(JSONObject jsCmd) {
        IWbJsCommand cmd = jsCmd.getBoolean("toggle") ? new WbJsToggleCommand(this, jsCmd) : new WbJsCommand(this, jsCmd);
        Map<IWbJsCommand, ?> map = this.commands;
        synchronized (map) {
            this.commands.put(cmd, null);
        }
        return (Command)cmd;
    }

    boolean isInViewTab() {
        BWidget w = this.getParentWidget();
        return w instanceof BViewTab;
    }

    public static BOrd createJsOrd(AgentInfo agentInfo, OrdTarget target) {
        ViewQuery query;
        String[] paramNames;
        StringBuilder out = new StringBuilder();
        out.append("view:").append(agentInfo.getAgentId());
        if (target != null && target.getViewQuery() != null && (paramNames = (query = target.getViewQuery()).getParameterNames()).length > 0) {
            out.append("?");
            for (int i = 0; i < paramNames.length; ++i) {
                if (i > 0) {
                    out.append(";");
                }
                out.append(paramNames[i]).append("=").append(query.getParameter(paramNames[i]));
            }
        }
        return BOrd.make((String)out.toString());
    }

    private void recordAgentId(AgentInfo agentInfo, OrdTarget target) {
        this.setJs(BWebWidget.createJsOrd(agentInfo, target));
    }

    public Optional<TypeInfo> getTypeInfoFromJs() {
        String id = this.getWidgetTypeSpec();
        if (id.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Sys.getRegistry().getType(id));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static BOrd getOrdFromBinding(BBinding binding, BOrd base) {
        BObject obj = binding.get();
        BOrd ord = binding.getOrd();
        if (obj instanceof BINavNode) {
            ord = ((BINavNode)obj).getNavOrd();
        } else if (base != null) {
            ord = BOrd.make((BOrd)base, (BOrd)ord);
        }
        ViewQuery query = binding.getTarget().getViewQuery();
        if (query != null) {
            ord = BOrd.make((BOrd)ord, (OrdQuery)query);
        }
        return ord.normalize().relativizeToSession();
    }

    private boolean isOfflineMode() {
        return this.offline;
    }

    private void fireEvent(String eventName, TransferContext cx) {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        BObject[] values = mark.getValues();
        double x = cx.getX();
        double y = cx.getY();
        BWebBrowser.post(this.browser, () -> {
            try {
                StringWriter strWtr = new StringWriter();
                JSONWriter out = QuickJSONWriter.make((Appendable)strWtr);
                boolean empty = true;
                out.array();
                for (BObject value : values) {
                    if (!(value instanceof BINavNode)) continue;
                    empty = false;
                    try {
                        BINavNode node = (BINavNode)value;
                        out.object();
                        out.key("ord").value((Object)node.getNavOrd().relativizeToSession());
                        out.key("name").value((Object)node.getNavName());
                        out.key("displayName").value((Object)node.getNavDisplayName(null));
                        out.key("icon").value((Object)node.getNavIcon().encodeToString());
                        out.key("description").value((Object)node.getNavDescription(null));
                        out.key("typeSpec").value((Object)node.getType());
                        out.endObject();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                out.endArray();
                if (!empty) {
                    this.getJsContainer().call(eventName, x, y, strWtr.toString());
                }
            }
            catch (Exception e) {
                this.dragOverRes = 0;
                Object object = this.dragOverMonitor;
                synchronized (object) {
                    this.dragOverMonitor.notifyAll();
                }
                log.log(Level.SEVERE, e.getMessage() == null ? "Could not invoke drag and drop event" : e.getMessage(), e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doDragOver(TransferContext cx) {
        Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
        BObject[] values = mark.getValues();
        if (values.length == 0) {
            return 0;
        }
        for (BObject value : values) {
            if (value instanceof BINavNode) continue;
            return 0;
        }
        try {
            Object object = this.dragOverMonitor;
            synchronized (object) {
                this.fireEvent("dragover", cx);
                this.dragOverMonitor.wait(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            this.dragOverRes = 0;
        }
        return this.dragOverRes;
    }

    @Override
    public CommandArtifact doDrop(TransferContext cx) {
        this.fireEvent("drop", cx);
        return null;
    }

    public static final class WebWidgetUtil {
        private volatile WebWidgetState state = WebWidgetState.uninitialized;
        private final WeakReference<BWebWidget> wwRef;

        private WebWidgetUtil(BWebWidget ww) {
            this.wwRef = new WeakReference<BWebWidget>(ww);
        }

        public void initializing() {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return;
            }
            if (BWebBrowser.profileLog.isLoggable(Level.FINE)) {
                BWebBrowser.profileLog.fine("#Start  : " + ww.getJs() + " -> " + BRelTime.make((long)(Clock.ticks() - ww.startTicks)));
            }
            ww.initTicks = Clock.ticks();
            this.state = WebWidgetState.initializing;
            String ordToLoad = ww.ordToLoad;
            if (!ordToLoad.isEmpty()) {
                ww.ordToLoad = "";
                BWebBrowser.post(ww.browser, () -> {
                    if (!ww.extraLoads()) {
                        ww.getJsContainer().call("load", ordToLoad);
                    }
                });
            }
        }

        public void initialized() {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return;
            }
            this.state = WebWidgetState.initialized;
            if (BWebBrowser.profileLog.isLoggable(Level.FINE)) {
                BWebBrowser.profileLog.fine("#Init   : " + ww.getJs() + " -> " + BRelTime.make((long)(Clock.ticks() - ww.initTicks)));
            }
            ww.loadTicks = Clock.ticks();
            Optional future = ww.loadedFuture;
            if (future.isPresent() && (ww.getCurrentValue() == null || ww.getWbViewBinding() == null && !ww.isInViewTab())) {
                ((CompletableFuture)future.get()).complete(null);
            }
        }

        public void loaded() {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return;
            }
            ww.loadedFuture.ifPresent(future -> future.complete(null));
            if (BWebBrowser.profileLog.isLoggable(Level.FINE)) {
                BWebBrowser.profileLog.fine("#Loaded : " + ww.getJs() + " -> " + BRelTime.make((long)(Clock.ticks() - ww.loadTicks)) + " (" + ww.findOrd(ww.getCurrentValue()) + ")");
            }
        }

        public void error(Object err) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return;
            }
            BWebBrowser.log.severe(err.toString());
            ww.loadedFuture.ifPresent(future -> future.completeExceptionally(new Exception("Failed to load WebWidget: " + err)));
        }

        public void hyperlink(String ord) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return;
            }
            BWbShell shell = BWbShell.getWbShell(ww);
            if (shell != null) {
                shell.hyperlink(BOrd.make((String)ord));
            }
        }

        public void buildCommands(Object data) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return;
            }
            if (!ww.isInViewTab()) {
                return;
            }
            Optional<String> groupData = ww.browser.fromJsToString(data);
            Optional obj = !groupData.isPresent() ? Optional.empty() : Optional.of(new JSONObject(groupData.get()));
            BWidget.invokeLater(() -> {
                ww.buildMenu(obj);
                ww.buildToolbar(obj);
                if (ww.isInViewTab()) {
                    BViewTab vt = (BViewTab)ww.getParent();
                    vt.updateShell();
                }
            });
        }

        public void updateCommand(Object jsCmd) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return;
            }
            Optional<String> c = ww.browser.fromJsToString(jsCmd);
            if (!c.isPresent()) {
                return;
            }
            JSONObject jsCmdObj = new JSONObject(c.get());
            BWidget.invokeLater(() -> {
                int id = jsCmdObj.getInt("id");
                Map map = ww.commands;
                synchronized (map) {
                    ww.commands.keySet().forEach(cmd -> {
                        if (cmd != null && cmd.getId() == id) {
                            cmd.sync(jsCmdObj);
                        }
                    });
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setModified() {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww != null) {
                Object object = ww.saveMonitor;
                synchronized (object) {
                    ww.saveErr = null;
                    ww.saved = false;
                }
                BWidget.invokeLater(ww::setModified);
            }
        }

        public void clearModified() {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww != null) {
                BWidget.invokeLater(ww::clearModified);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveOk() {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return;
            }
            Object object = ww.saveMonitor;
            synchronized (object) {
                ww.saved = true;
                ww.saveErr = null;
                ww.saveMonitor.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveFail(String err) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return;
            }
            Object object = ww.saveMonitor;
            synchronized (object) {
                ww.saveErr = err;
                ww.saved = true;
                ww.saveMonitor.notifyAll();
            }
        }

        public void save() {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww != null) {
                BWidget.invokeLater(() -> {
                    BWbShell shell = BrowserUtil.findWbShell((BComplex)ww);
                    if (shell != null) {
                        shell.getSaveCommand().invoke();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deactivated() {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return;
            }
            Object object = ww.deactivateMonitor;
            synchronized (object) {
                ww.deactivated = true;
                ww.deactivateMonitor.notifyAll();
            }
        }

        public void destroying() {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww != null) {
                ww.destroyTicks = Clock.ticks();
            }
        }

        public void destroyed() {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return;
            }
            if (BWebBrowser.profileLog.isLoggable(Level.FINE)) {
                BWebBrowser.profileLog.fine("#Destroy: " + ww.getJs() + " -> " + BRelTime.make((long)(Clock.ticks() - ww.destroyTicks)));
            }
        }

        public String syncProperties(Object jsProps) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return "";
            }
            Optional<String> propsStr = ww.browser.fromJsToString(jsProps);
            if (!propsStr.isPresent()) {
                return "";
            }
            JSONArray props = new JSONArray(propsStr.get());
            ArrayList<WebProperty> webProps = new ArrayList<WebProperty>();
            for (int i = 0; i < props.length(); ++i) {
                JSONObject p = props.getJSONObject(i);
                String typeSpec = p.has("typeSpec") ? JSONUtil.getString((JSONObject)p, (String)"typeSpec") : "";
                WebProperty buxp = new WebProperty(JSONUtil.getString((JSONObject)p, (String)"name"), p.has("hidden") && p.getBoolean("hidden"), p.has("readonly") && p.getBoolean("readonly"), p.has("transient") ? p.getBoolean("transient") : p.has("trans") && p.getBoolean("trans"), typeSpec.equals("undefined") ? "" : typeSpec, JSONUtil.getString((JSONObject)p, (String)"value"), p.has("metadata") ? p.getJSONObject("metadata") : null);
                webProps.add(buxp);
            }
            Map map = WebProperty.sync((BWidget)ww, webProps, (boolean)ww.legacyWebProperties);
            return map.isEmpty() ? "" : this.toJsonStr(map);
        }

        private String toJsonStr(Map<String, Object> map) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return "";
            }
            JSONObject obj = new JSONObject();
            map.keySet().iterator().forEachRemaining(name -> obj.put(name, map.get(name)));
            return obj.toString();
        }

        public String listViews(Object jsOrd) {
            StringWriter writer = new StringWriter();
            try {
                BWebWidget ww = (BWebWidget)this.wwRef.get();
                if (ww == null) {
                    return "";
                }
                Optional<String> ordOptional = ww.browser.fromJsToString(jsOrd);
                if (!ordOptional.isPresent()) {
                    return "";
                }
                BOrd ord = BOrd.make((String)ordOptional.get()).relativizeToSession();
                OrdTarget target = ord.resolve(ww.getCurrentValue(), ww.getCurrentContext());
                BObject base = target.get();
                AgentList list = WbSys.getFilteredViewList(ww, base, agent -> true);
                ViewAllOrdServlet.writeViewList((AgentList)list, (BOrd)ord, (Writer)writer, (String)"", (OrdTarget)target, (Context)ww.getCurrentContext());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not provide view list", e);
            }
            return writer.toString();
        }

        public String getProperties() {
            Map map = Collections.emptyMap();
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww != null) {
                try {
                    map = WebProperty.getPropertyChanges((BWidget)ww, (boolean)ww.legacyWebProperties);
                }
                catch (IOException ex) {
                    log.log(Level.SEVERE, "Could not encode Web Property in JS", ex);
                }
            }
            return !map.isEmpty() ? this.toJsonStr(map) : "";
        }

        public void propertyChanged(String name, Object value) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww != null) {
                String valueStr = value.toString();
                BWidget.invokeLater(() -> WebProperty.setProperty((BWidget)ww, (String)name, (String)valueStr));
            }
        }

        public void metadataChanged(String name, Object metaData) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww != null) {
                BWidget.invokeLater(() -> WebProperty.setFacets((BWidget)ww, (String)name, (Object)metaData));
            }
        }

        public void sendBox(String data) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null || ww.boxHandler == null) {
                return;
            }
            ww.boxHandler.sendBox(data).handleAsync((resp, err) -> {
                if (resp != null) {
                    ww.onBoxResponseMessage(resp);
                } else if (err != null) {
                    ww.loadedFuture.ifPresent(future -> {
                        if (!future.isDone()) {
                            future.complete(null);
                        }
                    });
                    System.out.println("Error sending Fox BOX message...");
                    err.printStackTrace();
                }
                return resp;
            }, (Executor)BoxClientUtil.getExecutorService());
        }

        public String getHostOrd() {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null || ww.boxHandler == null) {
                return "";
            }
            return ww.boxHandler.getHostOrd().encodeToString();
        }

        public String getSessionOrdInHost() {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null || ww.boxHandler == null) {
                return "";
            }
            return ww.boxHandler.getSessionOrdInHost().encodeToString();
        }

        public void setServerSessionId(String id) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null || ww.boxHandler == null) {
                return;
            }
            ww.boxHandler.unregisterUnsolicitedListener(ww.serverSessionId);
            ww.serverSessionId = id;
            ww.boxHandler.registerUnsolicitedListener(ww.serverSessionId, x$0 -> ww.onBoxResponseMessage(x$0));
        }

        public void startDrag(String json) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return;
            }
            BWidget.invokeLater(() -> {
                BObject base = (BObject)ww.findSession();
                JSONObject obj = new JSONObject(json);
                double x = obj.getDouble("x");
                double y = obj.getDouble("y");
                int modifiers = obj.getInt("modifiers");
                JSONObject dragData = new JSONObject(JSONUtil.getString((JSONObject)obj, (String)"drag"));
                String mimeType = JSONUtil.getString((JSONObject)dragData, (String)"mime");
                ArrayList<BComponent> compList = new ArrayList<BComponent>();
                if ("niagara/navnodes".equals(mimeType)) {
                    JSONArray array = dragData.getJSONArray("data");
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject navNode = (JSONObject)array.get(i);
                        if (!navNode.has("ord")) continue;
                        BComponent c = (BComponent)BOrd.make((String)JSONUtil.getString((JSONObject)navNode, (String)"ord")).get(base);
                        compList.add(c);
                    }
                }
                if (!compList.isEmpty()) {
                    BComponent[] comps = compList.toArray(new BComponent[compList.size()]);
                    TransferEnvelope envelope = TransferEnvelope.make((Mark)new Mark((BObject[])comps));
                    SimpleDragRenderer dragRenderer = new SimpleDragRenderer(comps);
                    dragRenderer.font = Theme.tree().getFont((BWidget)ww);
                    dragRenderer.xCursorOffset = Theme.tree().getExpanderWidth() + 4.0;
                    dragRenderer.yCursorOffset = Theme.tree().getExpanderWidth() + 4.0;
                    BTransferWidget transferWidget = ww.browser.getTransferWidget();
                    TransferContext cx = transferWidget.makeTransferContext(envelope);
                    BWidgetShell shell = ww.getShell();
                    if (shell != null) {
                        Point pt = new Point(x, y);
                        pt = shell.translateFromChild((BWidget)transferWidget, pt);
                        BMouseEvent event = new BMouseEvent(511, (BWidget)transferWidget, modifiers, pt.x, pt.y, 0, false);
                        transferWidget.startDrag(event, cx, (DragRenderer)dragRenderer);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dragCallback(boolean resp) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww != null) {
                ww.dragOverRes = resp ? 0 : 16;
                Object object = ww.dragOverMonitor;
                synchronized (object) {
                    ww.dragOverMonitor.notifyAll();
                }
            }
        }

        public boolean isCommandBarVisible() {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww == null) {
                return false;
            }
            BWbShell shell = BrowserUtil.findWbShell((BComplex)ww);
            return shell != null && shell.getProfile().makeToolBar() == null || !ww.isInViewTab();
        }

        public String getLexicon(String moduleName, String lang) {
            try {
                return BLexiconRpc.getLexicon((String)moduleName, (String)lang, (Context)BFacets.DEFAULT).toString();
            }
            catch (Exception e) {
                return "";
            }
        }

        public void playSound(String sound) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww != null && ww.browser != null && ww.getParent() != null) {
                ww.browser.playSound(BOrd.make((BOrd)WebWidgetUtil.getBaseOrd(ww), (String)sound).normalize());
            }
        }

        public void stopSound(String sound) {
            BWebWidget ww = (BWebWidget)this.wwRef.get();
            if (ww != null && ww.browser != null && ww.getParent() != null) {
                ww.browser.stopSound(BOrd.make((BOrd)WebWidgetUtil.getBaseOrd(ww), (String)sound).normalize());
            }
        }

        private static BOrd getBaseOrd(BWebWidget ww) {
            BOrd base = BOrd.NULL;
            BWbShell shell = BrowserUtil.findWbShell((BComplex)ww);
            if (shell != null) {
                base = shell.getActiveOrd();
            }
            return base;
        }
    }

    private static enum WebWidgetState {
        uninitialized,
        initializing,
        initialized;

    }

    public static final class FoxSessionRemoveListener
    implements NavListener {
        private final WeakReference<BFoxSession> sessRef;
        private final WeakReference<BWebBrowser> browserRef;
        private final URI uri;

        public FoxSessionRemoveListener(BFoxSession sess, BWebBrowser browser, URI uri) {
            this.sessRef = new WeakReference<BFoxSession>(sess);
            this.browserRef = new WeakReference<BWebBrowser>(browser);
            this.uri = uri;
        }

        public void navEvent(NavEvent event) {
            BFoxSession sess = (BFoxSession)this.sessRef.get();
            BWebBrowser browser = (BWebBrowser)((Object)this.browserRef.get());
            if (sess != null && browser != null && event.getId() == 2 && event.getParent() == sess) {
                AccessController.doPrivileged(() -> {
                    try {
                        browser.removeCookie(this.uri, BWebWidget.JSESSIONID, "/");
                        browser.removeCookie(this.uri, "super_session_id", "/");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                });
            }
        }
    }
}

