/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.ui.Binder;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BWebWidget;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentInfo;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.style.IStylable;
import javax.baja.util.Lexicon;
import javax.baja.web.BFormFactorEnum;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.sidebar.BWbSideBar;
import javax.baja.workbench.view.BWbView;

public abstract class BWebWbSideBar
extends BWbSideBar {
    public static final Type TYPE = Sys.loadType(BWebWbSideBar.class);
    private static final Lexicon lex = Lexicon.make((String)"workbench");

    @Override
    public Type getType() {
        return TYPE;
    }

    protected abstract AgentInfo getWebWidgetAgentInfo();

    protected abstract OrdTarget getWebWidgetOrdTarget();

    protected void initializeWebWidget(BWebWidget webWidget) {
    }

    protected void webWidgetStarted(BWebWidget webWidget) {
    }

    protected Context getWebWidgetContext(OrdTarget target) {
        BWbShell shell = this.getWbShell();
        if (shell != null && shell.getActiveView() != null) {
            return shell.getActiveView().getCurrentContext();
        }
        return null;
    }

    protected Optional<BWebBrowser> getBrowser() {
        BWidget existingContent = this.getContent();
        if (existingContent instanceof BWebWidget) {
            return Optional.of(((BWebWidget)existingContent).getBrowser());
        }
        return Optional.empty();
    }

    protected BWidget getUnavailableContent() {
        BLabel label = new BLabel(this.getUnavailableContentText());
        label.setWordWrapEnabled(true);
        label.setHalign(BHalign.left);
        label.setValign(BValign.top);
        StyleUtils.addStyleClass((IStylable)label, (String)"themeTextForeground");
        return new BBorderPane((BWidget)label, 10.0, 10.0, 10.0, 10.0);
    }

    protected String getUnavailableContentText() {
        return lex.getText("unavailable");
    }

    protected BWidget getErrorContent(Throwable error) {
        BLabel label = new BLabel(error.getLocalizedMessage());
        label.setWordWrapEnabled(true);
        label.setHalign(BHalign.left);
        label.setValign(BValign.top);
        StyleUtils.addStyleClass((IStylable)label, (String)"themeTextForeground");
        return new BBorderPane((BWidget)label, 10.0, 10.0, 10.0, 10.0);
    }

    protected void updateWebWidgetContent() {
        AgentInfo agent = this.getWebWidgetAgentInfo();
        OrdTarget ordTarget = this.getWebWidgetOrdTarget();
        BWidget existingContent = this.getContent();
        if (ordTarget != null && ordTarget.get() != null) {
            BWebWidget webWidget;
            Context cx = this.getWebWidgetContext(ordTarget);
            if (existingContent != null && existingContent.getType().is(BWebWidget.TYPE)) {
                webWidget = (BWebWidget)existingContent;
                if (webWidget.getCurrentValue() == ordTarget.get()) {
                    return;
                }
                try {
                    webWidget.fw(402);
                    webWidget.deactivated();
                }
                catch (Exception e) {
                    Logger.getLogger("webWidget").log(Level.WARNING, "Could not deactivate web side bar: " + webWidget.getType(), e);
                }
            }
            webWidget = new BWebWidget(agent, ordTarget, BFormFactorEnum.compact);
            this.initializeWebWidget(webWidget);
            this.setContent(webWidget);
            webWidget.fw(401);
            webWidget.activated();
            webWidget.fw(403);
            webWidget.loadValue(ordTarget.get(), cx);
            if (webWidget.getLoadError() == null) {
                webWidget.prime();
                webWidget.relayout();
                BWbShell shell = this.getWbShell();
                if (shell != null && shell.getProfile() != null) {
                    webWidget = (BWebWidget)shell.getProfile().customizeView(webWidget);
                }
                Binder binder = (Binder)webWidget.fw(302);
                binder.start(ordTarget, cx);
                this.webWidgetStarted(webWidget);
                return;
            }
            this.setContent(this.getErrorContent(webWidget.getLoadError()));
            return;
        }
        BWidget unavailableContent = this.getUnavailableContent();
        if (existingContent != null && !existingContent.equivalent((Object)unavailableContent)) {
            if (existingContent.getType().is(BWbView.TYPE)) {
                try {
                    BWbView view = (BWbView)existingContent;
                    view.fw(402);
                    view.deactivated();
                }
                catch (Exception e) {
                    Logger.getLogger("webWidget").log(Level.WARNING, "Could not deactivate web side bar: " + existingContent.getType(), e);
                }
            }
            this.setContent(unavailableContent);
        }
    }

    public void started() {
        this.updateWebWidgetContent();
    }

    @Override
    public void activeViewChanged() {
        this.updateWebWidgetContent();
    }
}

