/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.web.browser;

import com.tridium.net.BHttpObject;
import com.tridium.security.UrlWhitelist;
import com.tridium.util.Href2Ord;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.WbMain;
import com.tridium.workbench.util.IProgressReporter;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BWebBrowserOptions;
import com.tridium.workbench.web.browser.BrowserUtil;
import com.tridium.workbench.web.browser.IJs;
import com.tridium.workbench.web.browser.OpenInDesktopBrowserCommand;
import com.tridium.workbench.web.browser.RemoteDebugCommand;
import com.tridium.workbench.web.browser.WebBrowserSnoopWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.file.types.text.BIHtmlFile;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.text.FindPattern;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class BWebBrowserView
extends BWbView
implements IProgressReporter {
    public static final Action updateUrl = BWebBrowserView.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action updateTitle = BWebBrowserView.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action updateStatus = BWebBrowserView.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action updateProgress = BWebBrowserView.newAction((int)0, (BValue)BDouble.DEFAULT, null);
    public static final Action progressRunning = BWebBrowserView.newAction((int)0, (BValue)BBoolean.DEFAULT, null);
    public static final Action onForward = BWebBrowserView.newAction((int)0, null);
    public static final Action onBack = BWebBrowserView.newAction((int)0, null);
    public static final Action onAppendHistory = BWebBrowserView.newAction((int)0, (BValue)BOrd.NULL, null);
    public static final Action handleError = BWebBrowserView.newAction((int)0, (BValue)BString.DEFAULT, null);
    public static final Action updateTabOrd = BWebBrowserView.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BWebBrowserView.class);
    private final BWebBrowser browser;
    private OpenInDesktopBrowserCommand openInBrowserCmd;
    private BOrd activeOrd;
    private String pathFragment;
    public static final Logger log = Logger.getLogger("webBrowser.view");
    private static final BRelTime ORD_UPDATE_DELAY = BRelTime.make((long)500L);
    private FindPattern findPattern;
    private IJs findTextJs;
    private static final Lexicon lex = Lexicon.make(BWebBrowserView.class);

    public void updateUrl(BString url) {
        this.invoke(updateUrl, (BValue)url, null);
    }

    public void updateTitle(BString title) {
        this.invoke(updateTitle, (BValue)title, null);
    }

    public void updateStatus(BString msg) {
        this.invoke(updateStatus, (BValue)msg, null);
    }

    public void updateProgress(BDouble progress) {
        this.invoke(updateProgress, (BValue)progress, null);
    }

    public void progressRunning(BBoolean running) {
        this.invoke(progressRunning, (BValue)running, null);
    }

    public void onForward() {
        this.invoke(onForward, null, null);
    }

    public void onBack() {
        this.invoke(onBack, null, null);
    }

    public void onAppendHistory(BOrd ord) {
        this.invoke(onAppendHistory, (BValue)ord, null);
    }

    public void handleError(BString error) {
        this.invoke(handleError, (BValue)error, null);
    }

    public void updateTabOrd() {
        this.invoke(updateTabOrd, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BWebBrowserView() {
        this(new BWebBrowser());
    }

    public BWebBrowserView(BWebBrowser browser) {
        this.browser = browser;
        browser.setWhitelist(UrlWhitelist.getDefaultInstance((String[])new String[0]));
        browser.setContextMenuEnabled(false);
        this.openInBrowserCmd = new OpenInDesktopBrowserCommand(browser);
        this.openInBrowserCmd.setEnabled(false);
        this.linkTo((BComponent)browser, (Slot)BWebBrowser.location, (Slot)updateUrl);
        this.linkTo((BComponent)browser, (Slot)BWebBrowser.title, (Slot)updateTitle);
        this.linkTo((BComponent)browser, (Slot)BWebBrowser.statusMsg, (Slot)updateStatus);
        this.linkTo((BComponent)browser, (Slot)BWebBrowser.progressRunning, (Slot)progressRunning);
        this.linkTo((BComponent)browser, (Slot)BWebBrowser.progress, (Slot)updateProgress);
        this.linkTo((BComponent)browser, (Slot)BWebBrowser.error, (Slot)handleError);
        this.linkTo((BComponent)browser, (Slot)BWebBrowser.appendHistory, (Slot)onAppendHistory);
        browser.setOnRegisterFunctions(this::onRegisterFunctions);
        browser.setOnLoaded(this::onLoaded);
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)new BBorderPane((BWidget)browser, BBorder.none, BInsets.DEFAULT));
        this.setContent((BWidget)pane);
    }

    @Override
    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.setCommandEnabled(6, false);
        this.setCommandEnabled(7, false);
        this.setCommandEnabled(8, false);
        OrdTarget target = this.getWbShell().getActiveOrdTarget();
        this.activeOrd = target.getOrd();
        this.pathFragment = target.getFilePathFragment();
        this.loadBrowser(value, context);
    }

    protected final void loadBrowser(BObject value, Context cx) {
        if (value instanceof BIFile) {
            try {
                for (OrdQuery q : this.activeOrd.parse()) {
                    String scheme = q.getScheme();
                    if (("module".equals(scheme) || "workbench".equals(scheme)) && value instanceof BIHtmlFile) {
                        try (InputStream inputStream = ((BIFile)value).getInputStream();
                             StringWriter out = new StringWriter();){
                            WebBrowserSnoopWriter.pipe(this.activeOrd, inputStream, out);
                            value = BString.make((String)out.toString());
                            break;
                        }
                    }
                    if (!"file".equals(scheme)) continue;
                    FilePath path = (FilePath)q;
                    BHttpObject url = BrowserUtil.getOrdFilePathAsHttpObject(path);
                    if (url != null) {
                        value = url;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Failed to process the BIFile before loading.", e);
            }
        }
        this.browser.load(value, this.updateContext(cx));
    }

    protected final Context updateContext(Context context) {
        BFacets facets = BFacets.make((String)"activeOrd", (String)this.activeOrd.toString(context));
        if (this.pathFragment != null) {
            facets = BFacets.make((BFacets)facets, (String)"pathFragment", (BIDataValue)BString.make((String)this.pathFragment));
        }
        return new BasicContext(context, facets);
    }

    private void onRegisterFunctions() {
        if (this.browser.isUri()) {
            return;
        }
        BWbShell shell = this.getWbShell();
        if (shell == null) {
            return;
        }
        ViewUtil util = new ViewUtil(shell, this.activeOrd);
        this.browser.registerBiConsumer("niagaraWbHyperlink", util::hyperlink);
    }

    protected void onLoaded() {
        BWidget.invokeLater(this::startUpdateTabOrd);
        this.setCommandEnabled(6, true);
        this.setCommandEnabled(7, true);
        this.setCommandEnabled(8, true);
        this.findTextJs = null;
        if (this.browser.isUri()) {
            return;
        }
        BWbShell shell = this.getWbShell();
        if (shell == null) {
            return;
        }
        try {
            BIFile jQueryFile = (BIFile)BOrd.make((String)"module://js/rc/jquery/jquery-3.4.1.min.js").get();
            this.browser.executeScript(BajaFileUtil.readString((BIFile)jQueryFile));
            BIFile ordProcess = (BIFile)BOrd.make((String)"module://js/rc/ordProcess/ordProcess.js").get();
            this.browser.executeScriptAsync(BajaFileUtil.readString((BIFile)ordProcess));
            this.checkForPathFragment();
            BWidget.invokeLater(() -> this.browser.setVisible(true));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error loading JS files for Web Browser View...", e);
        }
    }

    private void startUpdateTabOrd() {
        if (this.isRunning()) {
            Clock.schedule((BComponent)this, (BRelTime)ORD_UPDATE_DELAY, (Action)updateTabOrd, null);
        }
    }

    public void doUpdateTabOrd() {
        BWidget.invokeLater(() -> {
            if (this.getParent() instanceof BViewTab) {
                BOrd ord;
                BViewTab tab = (BViewTab)this.getParent();
                String location = this.browser.getLocation();
                if (!(location.isEmpty() || location.startsWith("about:") || (ord = BWebBrowserView.isBrowserLocationFileUrl(location) ? BWebBrowserView.fileUrlToOrd(location) : BOrd.make((String)location)).isNull())) {
                    tab.updateOrd(ord);
                }
            }
        });
    }

    private void checkForPathFragment() {
        if (this.pathFragment != null) {
            this.browser.executeScriptAsync("$(function() {var delay = 10, totalDelay = 0, maxDelay = 500;var e = $(\"[id='" + this.pathFragment + "']\");if (!e.length) { e = $(\"[name='" + this.pathFragment + "']\"); }function allImagesLoaded() {  var loadingImgs = $.grep($('img'), function (img) { return !img.complete; });  return !loadingImgs.length;" + '}' + "function fragmentScrollReady() {" + this.browser.getFragmentScrollReadyJs() + "}function doScroll() {  if ((allImagesLoaded() && fragmentScrollReady()) || (totalDelay > maxDelay)) {    e[0].scrollIntoView();  }  else {    totalDelay += delay;    setTimeout(doScroll, delay);  }" + '}' + "if (e.length) { doScroll(); }});");
        }
    }

    public void doUpdateUrl(BString url) {
        this.doUpdateStatus(url);
        this.startUpdateTabOrd();
        this.openInBrowserCmd.setEnabled(OpenInDesktopBrowserCommand.canBeBrowsedTo(url.getString()));
    }

    public void doUpdateTitle(BString title) {
        if (this.getParent() instanceof BViewTab) {
            BViewTab tab = (BViewTab)this.getParent();
            if (!this.browser.getTitle().isEmpty()) {
                tab.getLabel().setText(this.browser.getTitle());
            }
        }
    }

    public void doUpdateStatus(BString msg) {
        BWidgetShell shell = this.getShell();
        if (shell != null) {
            shell.showStatus(msg.getString());
        }
    }

    public void doUpdateProgress(BDouble progress) {
        if (this.browser.isUri()) {
            this.doUpdateStatus(BString.make((String)(String.valueOf((int)this.browser.getProgress()) + "%: " + this.browser.getLocation())));
        }
        BViewTab tab = (BViewTab)this.getParent();
        tab.updateShell();
    }

    public void doProgressRunning(BBoolean running) {
        this.doUpdateStatus(BString.make((String)this.browser.getLocation()));
    }

    public void doHandleError(BString error) {
        this.browser.load(this.makeErrorPage(error), null);
    }

    private BObject makeErrorPage(BString error) {
        return BrowserUtil.makeErrorPage(error, this.activeOrd.toString());
    }

    public void doOnForward() {
        if (this.getParent() instanceof BViewTab) {
            BViewTab tab = (BViewTab)this.getParent();
            tab.onForward();
        }
    }

    public void doOnBack() {
        if (this.getParent() instanceof BViewTab) {
            BViewTab tab = (BViewTab)this.getParent();
            tab.onBack();
        }
    }

    public void doOnAppendHistory(BOrd ord) {
        String location;
        if (!ord.isNull() && BWebBrowserView.isBrowserLocationFileUrl(location = ord.encodeToString())) {
            ord = BWebBrowserView.fileUrlToOrd(location);
        }
        if (this.getParent() instanceof BViewTab) {
            BViewTab tab = (BViewTab)this.getParent();
            tab.onAppendToHistory(ord);
            tab.updateShell();
        }
    }

    @Override
    public double getProgress() {
        if (this.browser != null) {
            return this.browser.getProgress();
        }
        return 0.0;
    }

    public BToolBar getViewToolBar() {
        BToolBar bar = new BToolBar();
        BNiagaraWbShell shell = (BNiagaraWbShell)this.getWbShell();
        bar.add("find", shell.commands.find);
        bar.add("findPrev", shell.commands.findPrev);
        bar.add("findNext", shell.commands.findNext);
        bar.add("openInBrowser", (Command)this.openInBrowserCmd);
        if (this.isWebDevMode()) {
            bar.add("remoteDebugCmd", (Command)new RemoteDebugCommand(this.browser));
        }
        return bar;
    }

    public void clearCache() {
        if (this.browser != null) {
            this.browser.clearCache();
        }
    }

    private boolean isWebDevMode() {
        return BWidget.getApplication() != null && BWebBrowserOptions.get().getWebDevelopmentTools();
    }

    @Override
    public CommandArtifact invokeCommand(int id) throws Exception {
        switch (id) {
            case 6: {
                return this.doFind();
            }
            case 8: {
                return this.doFindNext();
            }
            case 7: {
                return this.doFindPrev();
            }
        }
        return super.invokeCommand(id);
    }

    @Override
    public final void deactivated() {
        super.deactivated();
        this.browser.close();
        this.findTextJs = null;
    }

    private CommandArtifact doFind() {
        this.findPattern = FindPattern.query((BWidget)this);
        if (this.findPattern == null) {
            return null;
        }
        if (this.findPattern.string.isEmpty()) {
            return null;
        }
        BWebBrowser.post(this.browser, () -> {
            try {
                if (this.findTextJs == null) {
                    BOrd ord = BOrd.make((String)"module://workbench/rc/find/findCommands.built.min.js");
                    BIFile findCommands = (BIFile)ord.get();
                    this.findTextJs = this.browser.executeScript(BajaFileUtil.readString((BIFile)findCommands));
                }
                IJs o = this.findTextJs.call("find", this.findPattern.string, this.findPattern.matchCase, this.findPattern.matchWord, this.findPattern.fromTop);
                boolean res = BWebBrowserView.getFindResult(o);
                BWebBrowserView.invokeLater(() -> {
                    if (!res) {
                        String msg = UiLexicon.bajaui().getText("find.notFound", new Object[]{this.findPattern.string});
                        BDialog.message((BWidget)this, (Object)msg);
                    }
                    this.updateFindStatus(res);
                });
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Failed to invoke the find command.", e);
            }
        });
        return null;
    }

    private CommandArtifact doFindNext() {
        BWebBrowser.post(this.browser, () -> {
            if (this.findTextJs != null) {
                boolean res = BWebBrowserView.getFindResult(this.findTextJs.call("findNext", new Object[0]));
                BWebBrowserView.invokeLater(() -> this.updateFindStatus(res));
            }
        });
        return null;
    }

    private CommandArtifact doFindPrev() {
        BWebBrowser.post(this.browser, () -> {
            if (this.findTextJs != null) {
                boolean res = BWebBrowserView.getFindResult(this.findTextJs.call("findPrev", new Object[0]));
                BWebBrowserView.invokeLater(() -> this.updateFindStatus(res));
            }
        });
        return null;
    }

    private static boolean getFindResult(IJs res) {
        return res.isBoolean() && res.toBool();
    }

    private void updateFindStatus(boolean result) {
        if (result) {
            this.getShell().showStatus("");
        } else if (this.findPattern != null) {
            this.getShell().showStatus(UiLexicon.bajaui().getText("noMore") + ": " + this.findPattern.string);
        }
    }

    private static boolean isBrowserLocationFileUrl(String location) {
        return location.startsWith("file://");
    }

    private static BOrd fileUrlToOrd(String location) {
        try {
            File file = new File(new URI(location));
            return BFileSystem.INSTANCE.localFileToOrd(file);
        }
        catch (URISyntaxException e) {
            log.log(Level.WARNING, "Failed to parse file location " + location + '.', e);
            return BOrd.NULL;
        }
    }

    protected final void executeScriptAsync(String script) {
        this.browser.executeScriptAsync(script);
    }

    public static final class ViewUtil {
        private WeakReference<BWbShell> shellRef;
        private BOrd ord;

        private ViewUtil(BWbShell shell, BOrd ord) {
            this.shellRef = new WeakReference<BWbShell>(shell);
            this.ord = ord;
        }

        public void hyperlink(String href, String target) {
            BWidget.invokeLater(() -> {
                BWbShell shell = (BWbShell)((Object)((Object)this.shellRef.get()));
                if (shell != null) {
                    BOrd linkOrd = href.startsWith("#") ? BrowserUtil.mergeFilePathFragment(this.ord, href) : new Href2Ord(this.ord).hrefToOrd(href);
                    WbMain.open(shell, linkOrd, target);
                }
            });
        }
    }
}

