/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.sys.Nre;
import java.security.AccessController;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.util.Queue;
import javax.baja.util.Worker;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.view.BWbComponentView;

public class WbViewEventWorker {
    private Worker worker;
    private Queue queue;
    private static final boolean processEventsAsync = AccessController.doPrivileged(() -> System.getProperty("niagara.wbView.processEventsAsync", "true")).equals("true");

    private WbViewEventWorker() {
        if (processEventsAsync) {
            this.queue = new Queue();
            this.worker = new Worker((Worker.ITodo)this.queue);
            this.worker.start("WbViewEventWorker");
            Nre.spySysManagers.add("WbViewEventWorker", (Spy)new WorkerPage());
        }
    }

    public static WbViewEventWorker getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void invokeLater(Runnable r) {
        if (processEventsAsync) {
            this.queue.enqueue((Object)r);
        } else {
            r.run();
        }
    }

    public final void registerForComponentEventsLater(final BWbComponentView view, final BComponent comp, final int depth) {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                view.registerForComponentEvents(comp, depth);
            }
        });
    }

    public final void reloadLater(final BComponentTable componentTable) {
        this.invokeLater(new Runnable(){

            @Override
            public void run() {
                componentTable.reload();
            }
        });
    }

    public class WorkerPage
    extends SpyDir {
        public void write(SpyWriter out) throws Exception {
            if (WbViewEventWorker.this.worker != null) {
                WbViewEventWorker.this.worker.spy(out);
            }
        }
    }

    private static class SingletonHolder {
        public static final WbViewEventWorker INSTANCE = new WbViewEventWorker();

        private SingletonHolder() {
        }
    }
}

