/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.table.BTable;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.view.BIExportableTableView;
import javax.baja.workbench.view.BWbComponentView;

public class BServiceManager
extends BWbComponentView
implements BIExportableTableView {
    public static final Type TYPE = Sys.loadType(BServiceManager.class);
    static final Lexicon lex = Lexicon.make((BModule)TYPE.getModule(), (Context)null);
    static final String lexStatus = lex.getText("serviceManager.status");
    static final String lexServiceType = lex.getText("serviceManager.serviceType");
    BComponentTable table;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BServiceManager() {
        this.autoRegisterForComponentEvents = false;
        this.table = new BComponentTable(new ComponentTableModel.Column[]{new ComponentTableModel.DisplayNameColumn(), new StatusColumn(), new ServiceTypeColumn()});
        this.attach(this.table);
        this.setContent((BWidget)BTitlePane.makePane((String)TYPE.getDisplayName(null), (BTable)this.table));
    }

    @Override
    public BTable getExportTable() {
        return this.table;
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.table.load((BComponent)value, BIService.class, cx);
    }

    static class ServiceTypeColumn
    implements ComponentTableModel.Column {
        ServiceTypeColumn() {
        }

        @Override
        public String getName() {
            return lexServiceType;
        }

        @Override
        public Object getValue(BComponent c) {
            Type[] types = ((BIService)c).getServiceTypes();
            if (types.length == 1) {
                return types[0].toString();
            }
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    s.append("; ");
                }
                s.append(types[i].toString());
            }
            return s.toString();
        }
    }

    static class StatusColumn
    implements ComponentTableModel.Column {
        StatusColumn() {
        }

        @Override
        public String getName() {
            return lexStatus;
        }

        @Override
        public Object getValue(BComponent c) {
            if (c instanceof BIStatus) {
                return ((BIStatus)c).getStatus();
            }
            return BStatus.ok;
        }
    }
}

