/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.sys.engine.NRelationKnob;
import com.tridium.ui.theme.Theme;
import com.tridium.util.LinkUtil;
import com.tridium.workbench.util.BRelateTagsPad;
import com.tridium.workbench.util.WbUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

public class BRelationSheet
extends BWbComponentView
implements BWbComponentView.Attachable {
    public static final Type TYPE = Sys.loadType(BRelationSheet.class);
    private static Lexicon lex = Lexicon.make((String)"workbench");
    static final String[] cols = new String[]{lex.getText("relationSheet.relationId"), lex.getText("linkSheet.mySlot"), lex.getText("relationSheet.direction"), lex.getText("relationSheet.type"), lex.getText("relationSheet.endpoint"), lex.getText("linkSheet.otherSlot"), lex.getText("linkSheet.enabled"), lex.getText("relationSheet.tags")};
    private static int COL_ID = 0;
    private static int COL_TARGET_SLOT = 1;
    private static int COL_DIR = 2;
    private static int COL_TYPE = 3;
    private static int COL_ENDPOINT = 4;
    private static int COL_SOURCE_SLOT = 5;
    private static int COL_ENABLED = 6;
    private static int COL_TAGS = 7;
    private static BImage iconIn = BImage.make((String)"module://icons/x16/arrowLeft.png");
    private static BImage iconOut = BImage.make((String)"module://icons/x16/arrowRight.png");
    private static BImage goTo = BImage.make((String)"module://icons/x16/arrowRight.png");
    private BComponent c;
    private BTable table;
    private Model model;
    private DeleteRelations deleteRelations;
    private EditRelation editRelation = new EditRelation(this);
    private EditTags editTags;
    private Hyperlink hyperlink;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BRelationSheet() {
        this.editRelation.setEnabled(false);
        this.editTags = new EditTags(this);
        this.editTags.setEnabled(false);
        this.deleteRelations = new DeleteRelations(this);
        this.deleteRelations.setEnabled(false);
        this.hyperlink = new Hyperlink(this);
        this.hyperlink.setEnabled(false);
        this.model = new Model();
        this.table = new BTable();
        this.table.setModel((TableModel)new DynamicTableModel((TableModel)this.model, new int[]{0, 1, 2, 3, 4, 5}));
        this.table.setSelection((TableSelection)new Selection());
        this.table.setController((TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.setContent((BWidget)new BTitlePane("Relation Sheet", (BWidget)this.table));
    }

    public BMenu[] getViewMenus() {
        return new BMenu[]{this.buildMenu()};
    }

    public BToolBar getViewToolBar() {
        BToolBar toolbar = new BToolBar();
        toolbar.add(null, (Command)this.deleteRelations);
        return toolbar;
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.c = (BComponent)value;
        this.refreshModel();
    }

    private void refreshModel() {
        BComponent x;
        int i;
        this.model.rows.clear();
        BRelation[] relations = this.c.getComponentRelations();
        for (int i2 = 0; i2 < relations.length; ++i2) {
            BRelation relation = relations[i2];
            BComponent x2 = null;
            try {
                x2 = (BComponent)relation.getEndpointOrd().resolve((BObject)this.c.getComponentSpace()).get();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            Row row = new Row();
            row.relation = relation;
            row.direction = relation.isOutbound() ? 1 : 0;
            row.otherPath = x2 == null ? "Unresolved: " + relation.getEndpointOrd() : "" + x2.getSlotPath();
            row.type = relation.getType().toString();
            row.id = relation.getRelationId();
            row.tags = relation.getRelationTags().toString();
            row.parent = this.c;
            row.prop = relation.getPropertyInParent();
            if (relation instanceof BLink) {
                String string;
                BLink link = (BLink)relation;
                row.isComposite = LinkUtil.isCompositeLink((BLink)link);
                row.mySlot = SlotPath.unescape((String)link.getTargetSlotName());
                row.otherSlot = SlotPath.unescape((String)link.getSourceSlotName());
                row.enabled = String.valueOf(link.isEnabled());
                if (row.isComposite) {
                    string = row.type + "(C)";
                    row.type = row.type;
                } else {
                    string = row.type;
                }
                row.type = string;
            }
            this.model.rows.add(row);
        }
        RelationKnob[] rKnobs = this.c.getRelationKnobs();
        Knob[] lKnobs = this.c.getKnobs();
        Array rKnobComps = new Array(BComponent.class);
        Array lKnobComps = new Array(BComponent.class);
        for (i = 0; i < lKnobs.length; ++i) {
            try {
                lKnobComps.add((Object)((BComponent)lKnobs[i].getTargetOrd().resolve((BObject)this.c.getComponentSpace()).get()));
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (lKnobComps.size() > 0) {
            BComponent.lease((BComponent[])((BComponent[])lKnobComps.trim()), (int)0);
        }
        for (i = 0; i < rKnobs.length; ++i) {
            try {
                BComponent parent;
                if (rKnobs[i] == null) continue;
                BRelation relation = null;
                boolean isProxy = ((NRelationKnob)rKnobs[i]).isProxy();
                if (isProxy) {
                    BComponent relationParent = (BComponent)rKnobs[i].getRelationOrd().resolve((BObject)this.c.getComponentSpace()).get();
                    for (BRelation bRelation : relationParent.getComponentRelations()) {
                        if (!bRelation.getId().getQName().equals(rKnobs[i].getRelationId())) continue;
                        relation = bRelation;
                        break;
                    }
                    if (relation == null) {
                        continue;
                    }
                } else {
                    relation = rKnobs[i].getRelation();
                }
                if ((parent = relation.getParentComponent()) == null) continue;
                parent.getOrdInSpace();
                rKnobComps.add((Object)((BComponent)rKnobs[i].getRelationOrd().resolve((BObject)this.c.getComponentSpace()).get()));
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (rKnobComps.size() > 0) {
            BComponent.lease((BComponent[])((BComponent[])rKnobComps.trim()), (int)0);
        }
        for (i = 0; i < rKnobComps.size(); ++i) {
            try {
                x = (BComponent)rKnobComps.get(i);
                Row row = new Row();
                row.otherPath = x.getSlotPath().toString();
                row.id = rKnobs[i].getRelationId();
                row.parent = x;
                BRelation[] rel = x.getComponentRelations();
                for (int j = 0; j < rel.length; ++j) {
                    BRelation relation;
                    BOrd endpointOrd = rel[j].getEndpointOrd();
                    BComponent relatedComp = null;
                    try {
                        relatedComp = endpointOrd.get((BObject)this.c).asComponent();
                    }
                    catch (Exception e) {
                        System.out.println("Warning could not resolve: " + endpointOrd);
                    }
                    if (relatedComp == null || relatedComp != this.c || !rel[j].getRelationId().equals(row.id)) continue;
                    row.relation = relation = rel[j];
                    row.type = relation.getType().toString();
                    row.prop = relation.getPropertyInParent();
                    row.tags = relation.getRelationTags().toString();
                    row.direction = relation.isOutbound() ? 0 : 1;
                    this.model.rows.add(row);
                }
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < lKnobComps.size(); ++i) {
            try {
                x = (BComponent)lKnobComps.get(i);
                Row row = new Row();
                row.direction = 1;
                row.mySlot = lKnobs[i].getSourceSlotName();
                row.otherPath = x.getSlotPath().toString();
                row.otherSlot = lKnobs[i].getTargetSlotName();
                row.parent = x;
                BLink[] lnk = x.getLinks();
                for (int j = 0; j < lnk.length; ++j) {
                    if (lnk[j].getSourceOrd().get((BObject)this.c) != this.c || !lnk[j].getSourceSlotName().equals(row.mySlot) || !lnk[j].getTargetSlotName().equals(row.otherSlot)) continue;
                    BLink link = lnk[j];
                    String typeStr = link.getType().toString();
                    row.relation = link;
                    row.isComposite = LinkUtil.isCompositeLink((BLink)link);
                    row.id = row.relation.getRelationId();
                    row.enabled = String.valueOf(link.isEnabled());
                    row.type = row.isComposite ? typeStr + "(C)" : typeStr;
                    row.prop = link.getPropertyInParent();
                    row.mySlot = SlotPath.unescape((String)row.mySlot);
                    row.otherSlot = SlotPath.unescape((String)row.otherSlot);
                    row.direction = link.isOutbound() ? 0 : 1;
                    break;
                }
                this.model.rows.add(row);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.table.sizeColumnsToFit();
        this.table.relayout();
    }

    private BMenu buildMenu() {
        BMenu menu = new BMenu(lex.get("relationSheet"));
        menu.add(null, (Command)this.editRelation);
        menu.add(null, (Command)this.editTags);
        menu.add(null, (Command)this.deleteRelations);
        menu.add(null, (Command)this.hyperlink);
        return menu;
    }

    @Override
    public void attached(BWbComponentView view) {
    }

    @Override
    public void detached(BWbComponentView view) {
    }

    @Override
    public void handleComponentEvent(BComponentEvent event) {
        switch (event.getId()) {
            case 1: 
            case 2: 
            case 8: 
            case 9: 
            case 17: 
            case 18: {
                this.refreshModel();
            }
        }
    }

    class Hyperlink
    extends Command {
        public Hyperlink(BWidget owner) {
            super(owner, lex.getText("linkSheet.goTo"));
        }

        public CommandArtifact doInvoke() {
            int[] rows = BRelationSheet.this.table.getSelection().getRows();
            Row row = ((BRelationSheet)BRelationSheet.this).model.rows.get(rows[0]);
            BRelationSheet.this.getWbShell().hyperlink(BOrd.make((String)("station:|" + row.otherPath)));
            return null;
        }

        public BImage getIcon() {
            return goTo;
        }
    }

    class DeleteRelations
    extends Command {
        public DeleteRelations(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "commands.deleteRelations");
        }

        public CommandArtifact doInvoke() throws Exception {
            int i;
            Context tx = Transaction.start((BComponent)BRelationSheet.this.c, null);
            int[] sel = BRelationSheet.this.table.getSelection().getRows();
            Row[] rows = new Row[sel.length];
            int compositeWarningResult = -1;
            for (i = 0; i < rows.length; ++i) {
                rows[i] = ((BRelationSheet)BRelationSheet.this).model.rows.get(sel[i]);
                if (compositeWarningResult == -1) {
                    compositeWarningResult = WbUtil.compositeDeletionWarning((BWidget)BRelationSheet.this, (BIPropertyContainer)rows[i].parent, (Slot)rows[i].prop);
                }
                if (compositeWarningResult != 2) continue;
                return null;
            }
            BRelationSheet.this.table.getSelection().deselectAll();
            for (i = 0; i < rows.length; ++i) {
                rows[i].parent.remove(rows[i].prop, tx);
            }
            Transaction.end((BComponent)BRelationSheet.this.c, (Context)tx);
            return null;
        }
    }

    class EditTags
    extends Command {
        public EditTags(BWidget owner) {
            super(owner, Lexicon.make((String)"workbench"), "editTags");
        }

        public CommandArtifact doInvoke() throws Exception {
            int index = BRelationSheet.this.table.getSelection().getRow();
            Row row = ((BRelationSheet)BRelationSheet.this).model.rows.get(index);
            BRelation relation = row.relation;
            relation.getParent().asComponent().lease();
            BRelateTagsPad editDialog = new BRelateTagsPad(this.getOwner(), relation);
            BObject result = editDialog.openInDialog(this.getOwner());
            if (result != null) {
                BRelationSheet.this.refreshModel();
            }
            return null;
        }
    }

    class EditRelation
    extends Command {
        public EditRelation(BWidget owner) {
            super(owner, Lexicon.make((String)"workbench"), "edit");
        }

        public CommandArtifact doInvoke() throws Exception {
            int index = BRelationSheet.this.table.getSelection().getRow();
            Row row = ((BRelationSheet)BRelationSheet.this).model.rows.get(index);
            BRelation relation = row.relation;
            relation.getParent().asComponent().lease();
            BObject result = BWbFieldEditor.dialog(this.getOwner(), this.getLabel(), (BObject)relation);
            if (result != null) {
                BRelationSheet.this.refreshModel();
            }
            return null;
        }
    }

    class Renderer
    extends TableCellRenderer {
        Renderer() {
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            BImage icon;
            TableModel model = this.getTable().getModel();
            this.paintCellBackground(g, cell);
            double x = 2.0;
            double y = (cell.height - 16.0) / 2.0;
            if (cols[2].equals(model.getColumnName(cell.column)) && (icon = model.getRowIcon(cell.row)) != null) {
                g.drawImage(icon, x, y);
                x += 18.0;
            }
            String s = this.getCellText(cell);
            BFont font = Theme.table().getCellFont();
            switch (model.getColumnAlignment(cell.column).getOrdinal()) {
                case 2: {
                    x = cell.width - 2.0 - font.width(s);
                    break;
                }
                case 1: {
                    x = (cell.width - font.width(s)) / 2.0;
                }
            }
            g.setFont(font);
            g.drawString(s, x, font.getAscent() + 2.0);
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            Row r = ((BRelationSheet)BRelationSheet.this).model.rows.get(row);
            if (BRelationSheet.this.editRelation.isEnabled()) {
                BRelationSheet.this.editRelation.invoke();
            }
        }

        protected BMenu makePopup(TableSubject subject) {
            return BRelationSheet.this.buildMenu();
        }

        public int getTextSearchColumn() {
            return 0;
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            int n = this.getRows().length;
            boolean compositeSelected = false;
            for (int i : this.getRows()) {
                if (!((Row)((BRelationSheet)BRelationSheet.this).model.getSubject((int)i)).isComposite) continue;
                compositeSelected = true;
                break;
            }
            if (compositeSelected) {
                BRelationSheet.this.editRelation.setEnabled(false);
                BRelationSheet.this.editTags.setEnabled(false);
                BRelationSheet.this.deleteRelations.setEnabled(false);
            } else {
                BRelationSheet.this.editRelation.setEnabled(n == 1);
                BRelationSheet.this.editTags.setEnabled(n == 1);
                BRelationSheet.this.deleteRelations.setEnabled(n > 0);
            }
            BRelationSheet.this.hyperlink.setEnabled(n == 1);
        }
    }

    class RowSorter
    implements Comparator<Row> {
        private int col = 0;
        private boolean ascending = true;

        public RowSorter(int col, boolean ascending) {
            this.col = col;
            this.ascending = ascending;
        }

        @Override
        public int compare(Row o1, Row o2) {
            Row b;
            Row a;
            if (this.ascending) {
                a = o1;
                b = o2;
            } else {
                a = o2;
                b = o1;
            }
            switch (this.col) {
                case 0: {
                    return a.id.compareTo(b.id);
                }
                case 1: {
                    return a.mySlot.compareTo(b.mySlot);
                }
                case 2: {
                    if (a.direction < b.direction) {
                        return -1;
                    }
                    if (a.direction == b.direction) {
                        return 0;
                    }
                    return 1;
                }
                case 3: {
                    return a.type.compareTo(b.type);
                }
                case 4: {
                    return a.otherPath.compareTo(b.otherPath);
                }
                case 5: {
                    return a.otherSlot.compareTo(b.otherSlot);
                }
                case 6: {
                    return a.enabled.compareTo(b.enabled);
                }
                case 7: {
                    return a.tags.compareTo(b.tags);
                }
            }
            return 0;
        }
    }

    class Row {
        public BRelation relation;
        public int direction = 0;
        public String id = "";
        public String mySlot = "-";
        public String otherPath = "";
        public String otherSlot = "-";
        public String enabled = "true";
        public String tags = "";
        public String type = "";
        public boolean isComposite = false;
        public Property prop = null;
        public BComponent parent = null;
        public static final int IN = 0;
        public static final int OUT = 1;

        Row() {
        }
    }

    class Model
    extends TableModel {
        ArrayList<Row> rows = new ArrayList();

        Model() {
        }

        public int getColumnCount() {
            return cols.length;
        }

        public String getColumnName(int col) {
            return cols[col];
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Object getSubject(int r) {
            return this.rows.get(r);
        }

        public Object getValueAt(int r, int col) {
            Row row = this.rows.get(r);
            switch (col) {
                case 0: {
                    return row.id;
                }
                case 1: {
                    return row.mySlot;
                }
                case 3: {
                    return row.type;
                }
                case 4: {
                    return row.otherPath;
                }
                case 5: {
                    return row.otherSlot;
                }
                case 6: {
                    return row.enabled;
                }
                case 7: {
                    return row.tags;
                }
            }
            return "";
        }

        public BImage getRowIcon(int r) {
            Row row = this.rows.get(r);
            return row.direction == 0 ? iconIn : iconOut;
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            Row[] temp = this.rows.toArray(new Row[this.rows.size()]);
            Arrays.sort(temp, new RowSorter(col, ascending));
            this.rows.clear();
            for (int i = 0; i < temp.length; ++i) {
                this.rows.add(temp[i]);
            }
        }
    }
}

