/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.workbench.shell.BPasswordField;
import javax.baja.gx.BImage;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;

public class BPasswordPromptDialog
extends BDialog {
    public static final Action okButtonPressed = BPasswordPromptDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action cancelButtonPressed = BPasswordPromptDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BPasswordPromptDialog.class);
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static final BImage logo = BImage.make((String)lex.get("cert.x32.icon", "module://icons/x32/lock.png"));
    protected BButton okButton;
    protected BButton cancelButton;
    private BPasswordField passwordField = null;
    private BPassword response = null;
    private String msg = null;

    public void okButtonPressed(BWidgetEvent event) {
        this.invoke(okButtonPressed, (BValue)event, null);
    }

    public void cancelButtonPressed(BWidgetEvent event) {
        this.invoke(cancelButtonPressed, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BPassword open(BWidget owner, String title, String msg) {
        BPasswordPromptDialog dialog = new BPasswordPromptDialog(owner, title, msg);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getPassword();
    }

    private BPasswordPromptDialog(BWidget owner, String title, String msg) {
        super(owner, title, true);
        this.msg = msg;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
        this.okButton.setEnabled(true);
    }

    private BWidget buildDialog() {
        BEdgePane dialogPane = new BEdgePane();
        dialogPane.setTop(this.buildHeader());
        dialogPane.setCenter(this.buildContent());
        return dialogPane;
    }

    private BWidget buildHeader() {
        return new BWizardHeader(logo, this.getTitle(), this.msg);
    }

    private BWidget buildContent() {
        BGridPane contentPane = new BGridPane(1);
        contentPane.setHalign(BHalign.center);
        contentPane.setColumnAlign(BHalign.center);
        contentPane.add(null, (BValue)this.buildBody());
        contentPane.add(null, (BValue)this.buildButtons());
        return new BBorderPane((BWidget)contentPane, 17.0, 7.0, 7.0, 7.0);
    }

    private BWidget buildBody() {
        BEdgePane pane = new BEdgePane();
        pane.setLeft((BWidget)new BLabel(lex.get("password.field.password")));
        this.passwordField = new BPasswordField();
        pane.setCenter((BWidget)new BBorderPane((BWidget)this.passwordField, 4.0, 4.0, 4.0, 4.0));
        return pane;
    }

    private BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.okButton.setPreferredSize(50.0, this.okButton.getPreferredHeight());
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(false);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.cancelButton.setPreferredSize(50.0, this.cancelButton.getPreferredHeight());
        this.linkTo("linkC", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    public BPassword getPassword() {
        return this.response;
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        this.response = this.passwordField.getPassword();
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) throws Exception {
        this.response = null;
        this.close();
    }
}

