/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import com.tridium.sys.registry.NModuleInfo;
import com.tridium.ui.BOptionDialog;
import com.tridium.ui.theme.Theme;
import java.util.Comparator;
import java.util.TreeMap;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;

public final class BPalettePane
extends BPane {
    public static final Property content = BPalettePane.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Action updateTable = BPalettePane.newAction((int)0, null);
    public static final Action searchKeyEvent = BPalettePane.newAction((int)0, (BValue)new BKeyEvent(), null);
    public static final Type TYPE = Sys.loadType(BPalettePane.class);
    private static final Lexicon lex = Lexicon.make(BPalettePane.class);
    private static BFileChooser chooser;
    private BTextField searchField = new BTextField("", 40);
    private Array<Item> items = new Array(Item.class);
    private Array<Item> currentItems;
    private Model tableModel = new Model();
    private BTable table = new BTable((TableModel)this.tableModel);
    private BOrd fileOrd;

    public BWidget getContent() {
        return (BWidget)this.get(content);
    }

    public void setContent(BWidget v) {
        this.set(content, (BValue)v, null);
    }

    public void updateTable() {
        this.invoke(updateTable, null, null);
    }

    public void searchKeyEvent(BKeyEvent event) {
        this.invoke(searchKeyEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPalettePane() {
        throw new IllegalStateException();
    }

    public BPalettePane(BWidget owner) {
        this.table.setController((TableController)new Controller());
        BEdgePane selPane = new BEdgePane();
        selPane.setLeft((BWidget)new BLabel(lex.getText("PaletteSideBar.selectPalettes")));
        selPane.setRight((BWidget)new BButton((Command)new Browse(owner)));
        this.searchField.setRenderer(new TextRenderer(){

            public void paintLine(Graphics g, TextRenderer.LineInfo info) {
                if (info.line.segments.length == 0) {
                    TextRenderer.LineInfo info2 = new TextRenderer.LineInfo();
                    info2.lineIndex = 0;
                    info2.selectionStartColumn = 0;
                    info2.selectionEndColumn = 0;
                    String filterText = "filter";
                    info2.line = new Line(filterText.toCharArray(), new Segment[]{new Segment(-1, 0, filterText.length())});
                    super.paintLine(g, info2);
                } else {
                    super.paintLine(g, info);
                }
            }

            public BBrush getForeground(Segment seg) {
                if (seg.type == -1) {
                    return Theme.textEditor().getDisabledTextBrush();
                }
                return super.getForeground(seg);
            }
        });
        this.linkTo((BComponent)this.searchField, (Slot)BTextField.textModified, (Slot)updateTable);
        this.linkTo((BComponent)this.searchField, (Slot)BWidget.keyEvent, (Slot)searchKeyEvent);
        BGridPane searchFieldGrid = new BGridPane(2);
        searchFieldGrid.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.std((String)"filter.png"))));
        searchFieldGrid.add(null, (BValue)this.searchField);
        BEdgePane top = new BEdgePane();
        top.setTop((BWidget)selPane);
        top.setLeft((BWidget)new BBorderPane((BWidget)searchFieldGrid, 5.0, 0.0, 0.0, 0.0));
        BConstrainedPane cons = new BConstrainedPane((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        cons.setMinWidth(400.0);
        cons.setMaxHeight(300.0);
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BBorderPane((BWidget)top, 0.0, 0.0, 10.0, 0.0));
        edge.setCenter((BWidget)cons);
        BBorderPane pane = new BBorderPane((BWidget)edge, 10.0, 10.0, 10.0, 10.0);
        TreeMap<String, String> moduleDescByName = new TreeMap<String, String>();
        ModuleInfo[] m = Sys.getRegistry().getModules();
        for (int i = 0; i < m.length; ++i) {
            if (!((NModuleInfo)m[i]).hasPalette()) continue;
            moduleDescByName.put(m[i].getModuleName(), m[i].getDescription());
        }
        moduleDescByName.forEach((name, desc) -> this.items.add((Object)new Item((String)name, (String)desc)));
        this.currentItems = this.items.copy();
        this.setContent((BWidget)pane);
    }

    public void started() throws Exception {
        this.searchField.requestFocus();
    }

    public void computePreferredSize() {
        BWidget cn = this.getContent();
        cn.computePreferredSize();
        this.setPreferredSize(cn.getPreferredWidth(), cn.getPreferredHeight());
    }

    public void doLayout(BWidget[] children) {
        this.getContent().setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    public void doUpdateTable() {
        TableSelection sel = this.table.getSelection();
        Item[] currentSelItems = null;
        if (sel != null) {
            int[] rows = sel.getRows();
            currentSelItems = new Item[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                currentSelItems[i] = (Item)this.currentItems.get(rows[i]);
            }
        }
        if (this.searchField.getText().length() > 0) {
            this.currentItems.clear();
            String searchStr = this.searchField.getText().toLowerCase();
            if (searchStr.indexOf(42) == -1 && searchStr.indexOf(37) == -1) {
                searchStr = searchStr + "*";
            }
            PatternFilter filter = new PatternFilter(searchStr);
            for (Item item : this.items) {
                if (!filter.accept(item.searchTitle)) continue;
                this.currentItems.add((Object)item);
            }
        } else {
            this.currentItems = this.items.copy();
        }
        if (this.table.getSortColumn() > -1) {
            this.tableModel.sortByColumn(this.table.getSortColumn(), this.table.isSortAscending());
        }
        sel.deselectAll();
        if (currentSelItems != null) {
            for (int i = 0; i < this.currentItems.size(); ++i) {
                for (int j = 0; j < currentSelItems.length; ++j) {
                    if (this.currentItems.get(i) != currentSelItems[j]) continue;
                    sel.select(i);
                }
            }
        }
        if (sel.isEmpty() && this.searchField.getText().length() > 0) {
            if (this.currentItems.size() == 1) {
                sel.select(0);
            } else {
                for (int i = 0; i < this.currentItems.size(); ++i) {
                    Item item = (Item)this.currentItems.get(i);
                    if (!item.title.equalsIgnoreCase(this.searchField.getText())) continue;
                    sel.select(i);
                }
            }
        }
        this.tableModel.updateTable();
    }

    public void doSearchKeyEvent(BKeyEvent event) {
        if (event.getKeyCode() == 10 || event.getKeyCode() == 27 || event.getKeyCode() == 40 || event.getKeyCode() == 38 || event.getKeyCode() == 36 || event.getKeyCode() == 35 || event.getKeyCode() == 33 || event.getKeyCode() == 34) {
            this.table.fireKeyEvent(event);
        }
    }

    public boolean isFileSelected() {
        return this.fileOrd != null;
    }

    public BOrd getFileSelection() {
        return this.fileOrd;
    }

    public String[] getTableSelection() {
        int[] rows = this.table.getSelection().getRows();
        String[] sel = new String[rows.length];
        for (int i = 0; i < sel.length; ++i) {
            sel[i] = (String)this.tableModel.getValueAt(rows[i], 0);
        }
        return sel;
    }

    private BOptionDialog getDialog() {
        return this.findDialog((BWidget)this);
    }

    private BOptionDialog findDialog(BWidget w) {
        if (w == null) {
            return null;
        }
        if (w instanceof BDialog) {
            return (BOptionDialog)w;
        }
        return this.findDialog((BWidget)w.getParent());
    }

    class Browse
    extends Command {
        public Browse(BWidget owner) {
            super(owner, lex.getText("PaletteSideBar.browse"));
        }

        public CommandArtifact doInvoke() {
            if (chooser == null) {
                chooser = BFileChooser.makeOpen((BWidget)this.getOwner());
            }
            BPalettePane.this.fileOrd = chooser.show();
            if (BPalettePane.this.fileOrd != null) {
                BPalettePane.this.getDialog().getOkButton().invokeAction();
            }
            return null;
        }
    }

    static class Item {
        String title;
        String searchTitle;
        String description;

        Item(String title, String description) {
            this.title = title;
            this.searchTitle = title.toLowerCase();
            this.description = description;
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return lex.getText("PaletteSideBar.module");
            }
            return lex.getText("PaletteSideBar.description");
        }

        public int getRowCount() {
            return BPalettePane.this.currentItems.size();
        }

        public Object getValueAt(int row, int col) {
            Item it = (Item)BPalettePane.this.currentItems.get(row);
            if (col == 0) {
                return it.title;
            }
            return it.description;
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(final int col, final boolean ascending) {
            Comparator<Item> c = new Comparator<Item>(){

                @Override
                public int compare(Item o1, Item o2) {
                    Item it2;
                    Item it1;
                    if (!ascending) {
                        it1 = o1;
                        it2 = o2;
                    } else {
                        it2 = o1;
                        it1 = o2;
                    }
                    if (col == 0) {
                        return it1.title.compareTo(it2.title);
                    }
                    return it1.description.compareTo(it2.description);
                }
            };
            Array newCurrentItems = BPalettePane.this.currentItems.sort((Comparator)c);
            TableSelection sel = BPalettePane.this.table.getSelection();
            TableSelection newSel = new TableSelection();
            if (sel != null) {
                int[] rows = sel.getRows();
                block0: for (int i = 0; i < rows.length; ++i) {
                    Item item = (Item)BPalettePane.this.currentItems.get(rows[i]);
                    for (int j = 0; j < newCurrentItems.size(); ++j) {
                        if (newCurrentItems.get(j) != item) continue;
                        newSel.select(j);
                        continue block0;
                    }
                }
            }
            BPalettePane.this.table.setSelection(newSel);
            BPalettePane.this.currentItems = newCurrentItems;
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BPalettePane.this.getDialog().getOkButton().invokeAction();
        }

        public int getTextSearchColumn() {
            return 0;
        }
    }
}

