/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import javax.baja.gx.BSize;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BPageSizeFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BPageSizeFE.class);
    static Lexicon pdf = Lexicon.make((String)"pdf");
    BListDropDown sizes = null;
    BListDropDown orient = null;

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.sizes.setEnabled(!readonly);
        this.orient.setEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        this.sizes = new BListDropDown();
        this.orient = new BListDropDown();
        String list = pdf.getText("pageSize.list");
        String[] keys = TextUtil.split((String)list, (char)';');
        BSize size = (BSize)value;
        int sel = 0;
        boolean landscape = false;
        for (int i = 0; i < keys.length; ++i) {
            String key = "pageSize." + keys[i];
            PageSize item = new PageSize();
            item.displayName = pdf.getText(key + ".displayName");
            item.width = Double.parseDouble(pdf.getText(key + ".width"));
            item.height = Double.parseDouble(pdf.getText(key + ".height"));
            this.sizes.getList().addItem((Object)item);
            if (Math.abs(size.height - item.height) < 0.1 && Math.abs(size.width - item.width) < 0.1) {
                sel = i;
                continue;
            }
            if (!(Math.abs(size.height - item.width) < 0.1) || !(Math.abs(size.width - item.height) < 0.1)) continue;
            sel = i;
            landscape = true;
        }
        this.sizes.getList().setSelectedIndex(sel);
        this.orient.getList().addItem((Object)pdf.getText("pageSize.orient.portrait"));
        this.orient.getList().addItem((Object)pdf.getText("pageSize.orient.landscape"));
        this.orient.getList().setSelectedIndex(landscape ? 1 : 0);
        BGridPane grid = new BGridPane(2);
        grid.add(null, (BValue)this.sizes);
        grid.add(null, (BValue)this.orient);
        this.setContent((BWidget)grid);
        this.linkTo((BComponent)this.sizes, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo((BComponent)this.orient, (Slot)BListDropDown.valueModified, (Slot)setModified);
    }

    @Override
    protected BObject doSaveValue(BObject facetsValue, Context cx) throws Exception {
        PageSize item = (PageSize)this.sizes.getList().getSelectedItem();
        if (this.orient.getSelectedIndex() == 0) {
            return BSize.make((double)item.width, (double)item.height);
        }
        return BSize.make((double)item.height, (double)item.width);
    }

    class PageSize {
        String displayName;
        double width;
        double height;

        PageSize() {
        }

        public String toString() {
            return this.displayName;
        }
    }
}

