/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.util;

import javax.baja.sys.BComponent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.WidgetSubscriber;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;

public class BFlagConfig
extends BBorderPane {
    public static final Type TYPE = Sys.loadType(BFlagConfig.class);
    static final Lexicon lex = Lexicon.make((String)"baja", (String)Sys.getLanguage());
    BIPropertyContainer component;
    Slot[] slots;
    boolean powerUser;
    int orig;
    int toSet;
    int toClear;
    BCheckBox readonly = new BCheckBox(lex.getText("flag.readonly"));
    BCheckBox transientx = new BCheckBox(lex.getText("flag.transient"));
    BCheckBox hidden = new BCheckBox(lex.getText("flag.hidden"));
    BCheckBox summary = new BCheckBox(lex.getText("flag.summary"));
    BCheckBox async = new BCheckBox(lex.getText("flag.async"));
    BCheckBox noRun = new BCheckBox(lex.getText("flag.noRun"));
    BCheckBox fanIn = new BCheckBox(lex.getText("flag.fanIn"));
    BCheckBox defaultOnClone = new BCheckBox(lex.getText("flag.defaultOnClone"));
    BCheckBox confirmRequired = new BCheckBox(lex.getText("flag.confirmRequired"));
    BCheckBox operator = new BCheckBox(lex.getText("flag.operator"));
    BCheckBox executeOnChange = new BCheckBox(lex.getText("flag.executeOnChange"));
    BCheckBox noAudit = new BCheckBox(lex.getText("flag.noAudit"));
    BCheckBox composite = new BCheckBox(lex.getText("flag.composite"));
    BCheckBox removeOnClone = new BCheckBox(lex.getText("flag.removeOnClone"));
    BCheckBox metadata = new BCheckBox(lex.getText("flag.metadata"));
    BCheckBox linkTarget = new BCheckBox(lex.getText("flag.linkTarget"));
    BCheckBox nonCritical = new BCheckBox(lex.getText("flag.nonCritical"));
    BCheckBox userDefined1 = new BCheckBox(lex.getText("flag.userDefined1"));
    BCheckBox userDefined2 = new BCheckBox(lex.getText("flag.userDefined2"));
    BCheckBox userDefined3 = new BCheckBox(lex.getText("flag.userDefined3"));
    BCheckBox userDefined4 = new BCheckBox(lex.getText("flag.userDefined4"));
    BCheckBox[] checks = new BCheckBox[]{this.readonly, this.transientx, this.hidden, this.summary, this.async, this.noRun, this.fanIn, this.defaultOnClone, this.confirmRequired, this.operator, this.executeOnChange, this.noAudit, this.composite, this.removeOnClone, this.metadata, this.linkTarget, this.nonCritical, this.userDefined1, this.userDefined2, this.userDefined3, this.userDefined4};

    public Type getType() {
        return TYPE;
    }

    public BFlagConfig() {
        throw new IllegalStateException();
    }

    public BFlagConfig(BIPropertyContainer component, Slot[] slots) {
        this.component = component;
        this.slots = slots;
        BGridPane c0 = new BGridPane(1);
        c0.setColorRows(true);
        c0.add(null, (BValue)this.operator);
        c0.add(null, (BValue)this.readonly);
        c0.add(null, (BValue)this.confirmRequired);
        c0.add(null, (BValue)this.executeOnChange);
        c0.add(null, (BValue)this.transientx);
        c0.add(null, (BValue)this.summary);
        c0.add(null, (BValue)this.noRun);
        c0.add(null, (BValue)this.fanIn);
        c0.add(null, (BValue)this.hidden);
        c0.add(null, (BValue)this.defaultOnClone);
        c0.add(null, (BValue)this.async);
        BGridPane c1 = new BGridPane(1);
        c1.setColorRows(true);
        c1.add(null, (BValue)this.noAudit);
        c1.add(null, (BValue)this.composite);
        c1.add(null, (BValue)this.removeOnClone);
        c1.add(null, (BValue)this.metadata);
        c1.add(null, (BValue)this.linkTarget);
        c1.add(null, (BValue)this.nonCritical);
        c1.add(null, (BValue)this.userDefined1);
        c1.add(null, (BValue)this.userDefined2);
        c1.add(null, (BValue)this.userDefined3);
        c1.add(null, (BValue)this.userDefined4);
        BGridPane pane = new BGridPane(3);
        pane.setRowAlign(BValign.top);
        pane.add(null, (BValue)c0);
        pane.add(null, (BValue)c1);
        this.setContent((BWidget)pane);
        KeyListener listener = new KeyListener();
        for (int i = 0; i < this.checks.length; ++i) {
            listener.subscribe((BComponent)this.checks[i]);
        }
        if (slots != null) {
            int flags = -1;
            for (int i = 0; i < slots.length; ++i) {
                flags &= component.getFlags(slots[i]);
            }
            this.load(flags);
        }
        this.enable();
    }

    public void enable() {
        int i;
        boolean allDynamic = true;
        boolean allFrozen = this.slots != null;
        boolean allActions = this.slots != null;
        for (i = 0; this.slots != null && i < this.slots.length; ++i) {
            Slot slot = this.slots[i];
            allDynamic &= slot.isDynamic();
            allFrozen &= slot.isFrozen();
            allActions &= slot.isAction();
        }
        this.readonly.setEnabled(allDynamic);
        this.transientx.setEnabled(false);
        this.hidden.setEnabled(true);
        this.summary.setEnabled(true);
        this.async.setEnabled(false);
        this.noRun.setEnabled(false);
        this.fanIn.setEnabled(true);
        this.defaultOnClone.setEnabled(allFrozen);
        this.confirmRequired.setEnabled(allActions);
        this.operator.setEnabled(true);
        this.noAudit.setEnabled(true);
        this.executeOnChange.setEnabled(allDynamic);
        this.composite.setEnabled(false);
        this.removeOnClone.setEnabled(allDynamic);
        this.metadata.setEnabled(this.component != null);
        this.nonCritical.setEnabled(true);
        this.linkTarget.setEnabled(false);
        this.userDefined1.setEnabled(allDynamic);
        this.userDefined2.setEnabled(allDynamic);
        this.userDefined3.setEnabled(allDynamic);
        this.userDefined4.setEnabled(allDynamic);
        if (this.powerUser) {
            for (i = 0; i < this.checks.length; ++i) {
                this.checks[i].setEnabled(true);
            }
        }
    }

    public boolean isEnabled(Flags.Flag flag) {
        switch (flag.getMask()) {
            case 1: {
                return this.readonly.isEnabled();
            }
            case 2: {
                return this.transientx.isEnabled();
            }
            case 4: {
                return this.hidden.isEnabled();
            }
            case 8: {
                return this.summary.isEnabled();
            }
            case 16: {
                return this.async.isEnabled();
            }
            case 32: {
                return this.noRun.isEnabled();
            }
            case 64: {
                return this.defaultOnClone.isEnabled();
            }
            case 128: {
                return this.confirmRequired.isEnabled();
            }
            case 256: {
                return this.operator.isEnabled();
            }
            case 512: {
                return this.executeOnChange.isEnabled();
            }
            case 1024: {
                return this.fanIn.isEnabled();
            }
            case 2048: {
                return this.noAudit.isEnabled();
            }
            case 4096: {
                return this.composite.isEnabled();
            }
            case 8192: {
                return this.removeOnClone.isEnabled();
            }
            case 16384: {
                return this.metadata.isEnabled();
            }
            case 32768: {
                return this.linkTarget.isEnabled();
            }
            case 65536: {
                return this.nonCritical.isEnabled();
            }
            case 0x10000000: {
                return this.userDefined1.isEnabled();
            }
            case 0x20000000: {
                return this.userDefined2.isEnabled();
            }
            case 0x40000000: {
                return this.userDefined3.isEnabled();
            }
            case -2147483648: {
                return this.userDefined4.isEnabled();
            }
        }
        return false;
    }

    public void load(int flags) {
        this.orig = flags;
        this.readonly.setSelected((flags & 1) != 0);
        this.transientx.setSelected((flags & 2) != 0);
        this.hidden.setSelected((flags & 4) != 0);
        this.summary.setSelected((flags & 8) != 0);
        this.async.setSelected((flags & 0x10) != 0);
        this.noRun.setSelected((flags & 0x20) != 0);
        this.fanIn.setSelected((flags & 0x400) != 0);
        this.defaultOnClone.setSelected((flags & 0x40) != 0);
        this.confirmRequired.setSelected((flags & 0x80) != 0);
        this.operator.setSelected((flags & 0x100) != 0);
        this.executeOnChange.setSelected((flags & 0x200) != 0);
        this.noAudit.setSelected((flags & 0x800) != 0);
        this.composite.setSelected((flags & 0x1000) != 0);
        this.removeOnClone.setSelected((flags & 0x2000) != 0);
        this.metadata.setSelected((flags & 0x4000) != 0);
        this.linkTarget.setSelected((flags & 0x8000) != 0);
        this.nonCritical.setSelected((flags & 0x10000) != 0);
        this.userDefined1.setSelected((flags & 0x10000000) != 0);
        this.userDefined2.setSelected((flags & 0x20000000) != 0);
        this.userDefined3.setSelected((flags & 0x40000000) != 0);
        this.userDefined4.setSelected((flags & Integer.MIN_VALUE) != 0);
    }

    public int save() {
        int flags = 0;
        if (this.readonly.isSelected()) {
            flags |= 1;
        }
        if (this.transientx.isSelected()) {
            flags |= 2;
        }
        if (this.hidden.isSelected()) {
            flags |= 4;
        }
        if (this.summary.isSelected()) {
            flags |= 8;
        }
        if (this.async.isSelected()) {
            flags |= 0x10;
        }
        if (this.noRun.isSelected()) {
            flags |= 0x20;
        }
        if (this.fanIn.isSelected()) {
            flags |= 0x400;
        }
        if (this.defaultOnClone.isSelected()) {
            flags |= 0x40;
        }
        if (this.confirmRequired.isSelected()) {
            flags |= 0x80;
        }
        if (this.operator.isSelected()) {
            flags |= 0x100;
        }
        if (this.executeOnChange.isSelected()) {
            flags |= 0x200;
        }
        if (this.noAudit.isSelected()) {
            flags |= 0x800;
        }
        if (this.composite.isSelected()) {
            flags |= 0x1000;
        }
        if (this.removeOnClone.isSelected()) {
            flags |= 0x2000;
        }
        if (this.metadata.isSelected()) {
            flags |= 0x4000;
        }
        if (this.linkTarget.isSelected()) {
            flags |= 0x8000;
        }
        if (this.nonCritical.isSelected()) {
            flags |= 0x10000;
        }
        if (this.userDefined1.isSelected()) {
            flags |= 0x10000000;
        }
        if (this.userDefined2.isSelected()) {
            flags |= 0x20000000;
        }
        if (this.userDefined3.isSelected()) {
            flags |= 0x40000000;
        }
        if (this.userDefined4.isSelected()) {
            flags |= Integer.MIN_VALUE;
        }
        this.toSet = 0;
        this.toClear = 0;
        int mask = 1;
        for (int i = 0; i < 32; ++i) {
            boolean now;
            boolean old = (this.orig & mask) != 0;
            boolean bl = now = (flags & mask) != 0;
            if (old != now) {
                if (old) {
                    this.toClear |= mask;
                }
                if (now) {
                    this.toSet |= mask;
                }
            }
            mask <<= 1;
        }
        return flags;
    }

    class KeyListener
    extends WidgetSubscriber {
        KeyListener() {
        }

        public void keyPressed(BKeyEvent event) {
            if (event.getKeyCode() == 80 && event.isControlDown()) {
                event.consume();
                BFlagConfig.this.powerUser = !BFlagConfig.this.powerUser;
                System.out.println("FlagConfig.PowerUser " + BFlagConfig.this.powerUser);
                BFlagConfig.this.enable();
            }
        }
    }
}

