/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.sidebars;

import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.workbench.preview.BComponentPreviewWidget;
import com.tridium.workbench.util.BPalettePane;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BModule;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSelection;
import javax.baja.util.Lexicon;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;
import javax.baja.workbench.sidebar.BWbSideBar;

public class BPaletteSideBar
extends BWbSideBar {
    public static final Action updateTree = BPaletteSideBar.newAction((int)0, null);
    public static final Action treeSelectionModified = BPaletteSideBar.newAction((int)0, null);
    public static final Topic previewToggled = BPaletteSideBar.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BPaletteSideBar.class);
    private static BImage openIcon = BImage.make((String)"module://icons/x16/open.png");
    private static BImage closeIcon = BImage.make((String)"module://icons/x16/close.png");
    private static BImage moduleIcon = BImage.make((String)"module://icons/x16/module.png");
    private static BImage bogIcon = BImage.make((String)"module://icons/x16/objectFile.png");
    private static BImage prvIcon = BImage.make((String)"module://icons/x16/printPreview.png");
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private BListDropDown openPals;
    private Close close;
    private ComponentPreview compPrev;
    private BNavTree tree;
    private BTreePane treePane;
    private BSplitPane splitPane;
    private BEdgePane content;
    private BComponentPreviewWidget prevWid;
    private HashMap<String, NavTreeModel> hash = new HashMap();

    public void updateTree() {
        this.invoke(updateTree, null, null);
    }

    public void treeSelectionModified() {
        this.invoke(treeSelectionModified, null, null);
    }

    public void firePreviewToggled(BBoolean event) {
        this.fire(previewToggled, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BPaletteSideBar() {
        this(false);
    }

    public BPaletteSideBar(boolean defaultPreviewSelected) {
        this.openPals = new BListDropDown();
        this.linkTo(null, (BComponent)this.openPals, (Slot)BListDropDown.listActionPerformed, (Slot)updateTree);
        this.tree = new BNavTree(new EmptyModel());
        this.tree.setMultipleSelection(true);
        BButton b1 = new BButton((Command)new Open(this), false, true);
        this.close = new Close(this);
        BButton b2 = new BButton((Command)this.close, false, true);
        this.compPrev = new ComponentPreview(this);
        BToggleButton b3 = new BToggleButton((ToggleCommand)this.compPrev, false, true);
        b1.setButtonStyle(BButtonStyle.toolBar);
        b1.setFocusTraversable(false);
        b2.setButtonStyle(BButtonStyle.toolBar);
        b2.setFocusTraversable(false);
        b3.setButtonStyle(BButtonStyle.toolBar);
        b3.setFocusTraversable(false);
        BGridPane grid = new BGridPane(3);
        grid.setColumnAlign(BHalign.fill);
        grid.setRowAlign(BValign.fill);
        grid.add(null, (BValue)b1);
        grid.add(null, (BValue)b2);
        grid.add(null, (BValue)b3);
        BEdgePane top = new BEdgePane();
        top.setLeft((BWidget)grid);
        top.setCenter((BWidget)new BBorderPane((BWidget)this.openPals, 0.0, 0.0, 0.0, 5.0));
        BBorderPane topPane = new BBorderPane((BWidget)top, 5.0, 5.0, 5.0, 5.0);
        this.content = new BEdgePane();
        this.content.setTop((BWidget)topPane);
        this.treePane = new BTreePane((BTree)this.tree);
        StyleUtils.addStyleClass((IStylable)this.treePane, (String)"sidebar-scroll-pane");
        this.content.setCenter((BWidget)this.treePane);
        this.splitPane = new BSplitPane(BOrientation.vertical, 65.0);
        this.prevWid = new BComponentPreviewWidget();
        this.splitPane.setWidget2((BWidget)new BBorderPane((BWidget)this.prevWid, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        this.close.setEnabled(false);
        this.openPals.setEnabled(false);
        this.setContent((BWidget)this.content);
        this.linkTo((BComponent)this.tree, (Slot)BTree.selectionModified, (Slot)treeSelectionModified);
        this.loadPalettes();
        if (this.openPals.getList().getItemCount() > 0) {
            int index;
            BInteger[] temp = (BInteger[])this.getOptions().getChildren(BInteger.class);
            int n = index = temp.length > 0 ? temp[0].getInt() : 0;
            if (index >= this.openPals.getList().getItemCount()) {
                index = 0;
            }
            this.openPals.getList().setSelectedIndex(index);
            this.doUpdateTree();
        }
        this.compPrev.setSelected(defaultPreviewSelected);
    }

    public void doUpdateTree() {
        int index = this.openPals.getList().getSelectedIndex();
        this.close.setEnabled(index != -1);
        this.openPals.setEnabled(index != -1);
        if (index == -1) {
            this.tree.setModel(new EmptyModel());
            return;
        }
        String name = ((Item)this.openPals.getList().getSelectedItem()).name;
        if (name == null) {
            this.tree.setModel(new EmptyModel());
        } else {
            NavTreeModel model = this.hash.get(name);
            if (model == null) {
                try {
                    if (name.startsWith("file:")) {
                        BINavNode node = (BINavNode)BOrd.make((String)name).resolve().get();
                        model = new DefaultNavTreeModel(node);
                        this.hash.put(name, model);
                    } else {
                        BModule module = Sys.loadModule((String)name);
                        BINavNode node = module.getNavChild("module.palette");
                        model = new DefaultNavTreeModel(node);
                        this.hash.put(name, model);
                    }
                }
                catch (Exception e) {
                    Logger.getLogger("workbench").log(Level.WARNING, "[" + name + "]  Error loading palette!", e);
                    BDialog.error((BWidget)this.getShell(), (String)lex.getText("PaletteSideBar.paletteError.title"), (Object)lex.getText("PaletteSideBar.paletteError.message", new Object[]{name}), (Throwable)e);
                    this.close.doInvoke();
                    return;
                }
            }
            this.tree.setModel(model);
            BOptions options = this.getOptions();
            Property prop = options.getProperty("currentPalette");
            if (prop == null) {
                options.add("currentPalette", (BValue)BInteger.make((int)index));
            } else {
                options.set(prop, (BValue)BInteger.make((int)index));
            }
        }
        TreeSelection sel = this.tree.getSelection();
        if (sel != null) {
            sel.deselectAll();
        }
        this.tree.relayout();
        this.doTreeSelectionModified();
    }

    public void doTreeSelectionModified() {
        if (!this.compPrev.isSelected()) {
            return;
        }
        NavTreeNode node = (NavTreeNode)this.tree.getSelection().getNode();
        if (node != null && node.getNavNode() instanceof BComponent) {
            this.prevWid.setCurrentComponent((BComponent)node.getNavNode());
        } else {
            this.prevWid.setCurrentComponent(null);
        }
        this.repaint();
    }

    public BOptions getOptions() {
        return BOptions.load((String)"paletteSideBar", (Type)BOptions.TYPE);
    }

    private void loadPalettes() {
        this.openPals.getList().removeAllItems();
        this.sort();
        BOptions options = this.getOptions();
        BString[] pals = (BString[])options.getChildren(BString.class);
        for (int i = 0; i < pals.length; ++i) {
            String s = pals[i].toString();
            if (s.startsWith("file:")) {
                this.openPals.getList().addItem(bogIcon, (Object)new Item(this.toDisplay(s), s));
                continue;
            }
            this.openPals.getList().addItem(moduleIcon, (Object)new Item(s, s));
        }
    }

    private String toDisplay(String s) {
        int b;
        String ext = ".bog";
        int e = s.indexOf(ext);
        if (e == -1) {
            ext = ".palette";
            e = s.indexOf(".palette");
        }
        if (e == -1) {
            return s;
        }
        for (b = e - 1; b > 0 && s.charAt(b) != '/' && s.charAt(b) != '^' && s.charAt(b) != '!'; --b) {
        }
        return s.substring(b + 1, e + ext.length());
    }

    private void sort() {
        BOptions options = this.getOptions();
        Property[] props = options.getPropertiesArray();
        if (props.length == 0) {
            return;
        }
        Arrays.sort(props, new Sorter());
        options.reorder(props, null);
    }

    public BNavTree getNavTree() {
        return this.tree;
    }

    class Item {
        public String displayName;
        public String name;

        public Item(String dn, String n) {
            this.displayName = dn;
            this.name = n;
        }

        public String toString() {
            return this.displayName;
        }

        public boolean equals(Object obj) {
            return this.name.equals(((Item)obj).name);
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }
    }

    private class Sorter
    implements Comparator<Property> {
        private Sorter() {
        }

        @Override
        public int compare(Property o1, Property o2) {
            BValue a = BPaletteSideBar.this.getOptions().get(o1);
            BValue b = BPaletteSideBar.this.getOptions().get(o2);
            if (a instanceof BString && b instanceof BString) {
                BString x = (BString)a;
                BString y = (BString)b;
                return x.getString().compareTo(y.getString());
            }
            return a.getType().toString().compareTo(b.getType().toString());
        }
    }

    class EmptyModel
    extends NavTreeModel {
        EmptyModel() {
        }

        public int getRootCount() {
            return 0;
        }

        public TreeNode getRoot(int index) {
            return null;
        }
    }

    class ComponentPreview
    extends ToggleCommand {
        public ComponentPreview(BWidget owner) {
            super(owner, lex.getText("PaletteSideBar.preview"));
        }

        public BImage getIcon() {
            return prvIcon;
        }

        public CommandArtifact doInvoke() {
            if (this.isSelected()) {
                BPaletteSideBar.this.content.setCenter((BWidget)new BNullWidget());
                BPaletteSideBar.this.splitPane.setWidget1((BWidget)BPaletteSideBar.this.treePane);
                BPaletteSideBar.this.content.setCenter((BWidget)BPaletteSideBar.this.splitPane);
                BPaletteSideBar.this.doTreeSelectionModified();
            } else {
                BPaletteSideBar.this.splitPane.setWidget1((BWidget)new BNullWidget());
                BPaletteSideBar.this.content.setCenter((BWidget)BPaletteSideBar.this.treePane);
            }
            BPaletteSideBar.this.relayout();
            BPaletteSideBar.this.firePreviewToggled(this.isSelected() ? BBoolean.TRUE : BBoolean.FALSE);
            return null;
        }
    }

    class Close
    extends Command {
        public Close(BWidget owner) {
            super(owner, lex.getText("PaletteSideBar.closePalette"));
        }

        public BImage getIcon() {
            return closeIcon;
        }

        public CommandArtifact doInvoke() {
            Item item = (Item)BPaletteSideBar.this.openPals.getList().getSelectedItem();
            if (item != null) {
                BOptions options = BPaletteSideBar.this.getOptions();
                Property[] props = options.loadSlots().getPropertiesArray();
                for (int i = 0; i < props.length; ++i) {
                    BValue obj = options.get(props[i]);
                    if (!(obj instanceof BString) || !((BString)obj).getString().equals(item.name)) continue;
                    options.remove(props[i]);
                    break;
                }
                BPaletteSideBar.this.openPals.getList().removeItem((Object)item);
                BPaletteSideBar.this.hash.remove(item.name);
                int count = BPaletteSideBar.this.openPals.getList().getItemCount();
                int index = BPaletteSideBar.this.openPals.getList().getSelectedIndex();
                if (count == 0) {
                    BPaletteSideBar.this.openPals.getList().getSelection().deselectAll();
                } else if (index >= count) {
                    BPaletteSideBar.this.openPals.getList().setSelectedIndex(count - 1);
                }
                BPaletteSideBar.this.doUpdateTree();
            }
            return null;
        }
    }

    class Open
    extends Command {
        public Open(BWidget owner) {
            super(owner, lex.getText("PaletteSideBar.openPalette"));
        }

        public BImage getIcon() {
            return openIcon;
        }

        public CommandArtifact doInvoke() {
            BPalettePane pane = new BPalettePane(this.getOwner());
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("PaletteSideBar.openPalette"), (Object)((Object)pane), (int)3)) {
                if (pane.isFileSelected()) {
                    String str = pane.getFileSelection().relativizeToSession().toString();
                    ListModel model = BPaletteSideBar.this.openPals.getList().getModel();
                    Item item = new Item(BPaletteSideBar.this.toDisplay(str), str);
                    model.addItem(bogIcon, (Object)item);
                    BPaletteSideBar.this.getOptions().add(null, (BValue)BString.make((String)str));
                    BPaletteSideBar.this.openPals.getList().setSelectedIndex(model.indexOfItem((Object)item));
                } else {
                    String[] sel = pane.getTableSelection();
                    if (sel.length == 0) {
                        return null;
                    }
                    BOptions options = BPaletteSideBar.this.getOptions();
                    ListModel model = BPaletteSideBar.this.openPals.getList().getModel();
                    for (int i = 0; i < sel.length; ++i) {
                        Item item = new Item(sel[i], sel[i]);
                        if (model.indexOfItem((Object)item) == -1) {
                            options.add(null, (BValue)BString.make((String)item.name));
                            BPaletteSideBar.this.loadPalettes();
                        }
                        if (i != 0) continue;
                        BPaletteSideBar.this.openPals.getList().setSelectedIndex(model.indexOfItem((Object)item));
                    }
                }
                BPaletteSideBar.this.doUpdateTree();
            }
            return null;
        }
    }
}

