/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.BWbPane;
import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BTabbedPane;

public class BViewTabbedPane
extends BTabbedPane {
    public static final Type TYPE = Sys.loadType(BViewTabbedPane.class);
    BViewTab dragged = null;
    long lastSwapTimestamp = -1L;
    BViewTab lastSwap = null;
    private static final int MAX_NAME = 25;
    static final BImage faultIcon = BImage.make((String)"module://icons/x32/warning.png");
    private BNiagaraWbShell shell;
    private BWbPane pane;

    public Type getType() {
        return TYPE;
    }

    public BViewTabbedPane() {
        throw new IllegalStateException();
    }

    public BViewTabbedPane(BNiagaraWbShell shell, BWbPane pane) {
        this.shell = shell;
        this.pane = pane;
        this.setShowSingleTab(false);
        this.setPaintFullBorder(false);
        this.setTabSupport(new Support());
        this.addTab();
        BButton closeTabButton = new BButton(shell.commands.closeTab, false, true);
        closeTabButton.setButtonStyle(BButtonStyle.toolBar);
        this.setTabControl((BWidget)closeTabButton);
    }

    public BViewTab tab() {
        return (BViewTab)this.getSelectedLabelPane();
    }

    public BViewTab[] getTabs() {
        ArrayList<BViewTab> list = new ArrayList<BViewTab>();
        SlotCursor c = this.getProperties();
        while (c.nextComponent()) {
            if (!(c.get() instanceof BViewTab)) continue;
            BViewTab tab = (BViewTab)c.get();
            list.add((BViewTab)c.get());
        }
        return list.toArray(new BViewTab[list.size()]);
    }

    public BViewTab[] getModifiedTabs() {
        ArrayList<BViewTab> list = new ArrayList<BViewTab>();
        SlotCursor c = this.getProperties();
        while (c.nextComponent()) {
            if (!(c.get() instanceof BViewTab)) continue;
            BViewTab tab = (BViewTab)c.get();
            if (tab.view == null || !tab.view.isModified()) continue;
            list.add((BViewTab)c.get());
        }
        return list.toArray(new BViewTab[list.size()]);
    }

    public static int indexOf(BViewTab[] tabs, BViewTab tab) {
        for (int i = 0; i < tabs.length; ++i) {
            if (tabs[i] != tab) continue;
            return i;
        }
        return -1;
    }

    public void selectionModified(BLabelPane sel) {
        super.selectionModified(sel);
        this.tab().updateShell();
        if (this.tab().view != null) {
            this.tab().view.prime();
        }
    }

    public void added(Property prop, Context context) {
        super.added(prop, context);
        this.numberOfTabsUpdated();
    }

    public void removed(Property prop, BValue value, Context context) {
        super.removed(prop, value, context);
        this.numberOfTabsUpdated();
    }

    void numberOfTabsUpdated() {
        boolean multipleTabs = this.getTabs().length > 1;
        this.shell.commands.closeTab.setEnabled(multipleTabs);
        this.shell.commands.closeOtherTabs.setEnabled(multipleTabs);
        this.shell.commands.nextTab.setEnabled(multipleTabs);
        this.shell.commands.prevTab.setEnabled(multipleTabs);
        this.shell.commands.refreshTabs.setEnabled(multipleTabs);
    }

    public void paint(Graphics g) {
        super.paint(g);
        BViewTab tab = this.tab();
        if (tab == null || tab.fault == null) {
            return;
        }
        String fault = tab.fault;
        double w = this.getWidth();
        double h = this.getHeight();
        BLabel msg = new BLabel(fault, BHalign.left);
        msg.setImage(faultIcon);
        msg.computePreferredSize();
        double mw = msg.getPreferredWidth();
        double mh = msg.getPreferredHeight();
        double mx = Math.max(10.0, w - mw - 20.0);
        double my = Math.max(10.0, h - mh - 20.0);
        msg.setBounds(0.0, 0.0, mw, mh);
        msg.doLayout(null);
        g.setBrush(BColor.make((int)255, (int)255, (int)0, (int)180));
        g.fillRect(mx - 10.0, my - 10.0, mw + 20.0, mh + 20.0);
        g.setBrush(BColor.black);
        g.strokeRect(mx - 10.0, my - 10.0, mw + 20.0, mh + 20.0);
        g.translate(mx, my);
        msg.paint(g);
    }

    public void mouseDragged(BMouseEvent event) {
        BViewTab over;
        if (this.dragged != null && (over = (BViewTab)this.tabAt(event.getX(), event.getY())) instanceof BViewTab && (over != this.lastSwap || Clock.millis() - this.lastSwapTimestamp > 1000L)) {
            this.lastSwap = null;
            Property[] properties = this.getDynamicPropertiesArray();
            int j = -1;
            int k = -1;
            for (int i = 0; i < properties.length; ++i) {
                if (properties[i] == over.getPropertyInParent()) {
                    j = i;
                    continue;
                }
                if (properties[i] != this.dragged.getPropertyInParent()) continue;
                k = i;
            }
            if (j != -1 && k != -1) {
                Property swap = properties[j];
                properties[j] = properties[k];
                properties[k] = swap;
                this.lastSwap = over;
                this.lastSwapTimestamp = Clock.millis();
            }
            this.reorder(properties);
        }
        super.mouseDragged(event);
    }

    public void mouseDragStarted(BMouseEvent event) {
        BLabelPane over = this.tabAt(event.getX(), event.getY());
        if (over instanceof BViewTab) {
            this.dragged = (BViewTab)over;
            this.lastSwap = null;
        }
        super.mouseDragStarted(event);
    }

    public void mouseReleased(BMouseEvent event) {
        this.dragged = null;
        super.mouseReleased(event);
    }

    public void mousePressed(BMouseEvent event) {
        if (event.isButton2Down()) {
            BLabelPane tab = this.tabAt(event.getX(), event.getY());
            if (tab != null) {
                ((BViewTab)tab).closeTab();
            }
        } else {
            super.mousePressed(event);
        }
    }

    public void selectNextTab() {
        BViewTab[] tabs = this.getTabs();
        int oldIndex = BViewTabbedPane.indexOf(tabs, this.tab());
        int newIndex = (oldIndex + 1) % tabs.length;
        this.selectLabelPane(tabs[newIndex]);
    }

    public void selectPrevTab() {
        BViewTab[] tabs = this.getTabs();
        int oldIndex = BViewTabbedPane.indexOf(tabs, this.tab());
        int newIndex = oldIndex - 1;
        if (newIndex < 0) {
            newIndex = tabs.length - 1;
        }
        this.selectLabelPane(tabs[newIndex]);
    }

    public BViewTab addTab() {
        BViewTab tab = new BViewTab(this.shell);
        this.add(null, (BValue)tab);
        this.selectLabelPane(tab);
        return tab;
    }

    public void removeTab(BViewTab tab) {
        if (tab.getParent() != this) {
            throw new IllegalStateException();
        }
        if (tab == this.tab()) {
            this.selectPrevTab();
        }
        this.remove(tab.getPropertyInParent());
    }

    public static String toTabName(BOrd ord, OrdTarget ordTarget) {
        String name = null;
        try {
            BObject target;
            if (ordTarget != null && ordTarget.get() != null && (target = ordTarget.get()) instanceof BINavNode) {
                BFacets tabFacets = BFacets.make((String[])new String[]{"tabName", "ord"}, (BIDataValue[])new BIDataValue[]{BBoolean.TRUE, ord});
                name = ((BINavNode)target).getNavDisplayName((Context)tabFacets);
            }
            if (name == null) {
                name = BViewTabbedPane.toTabNameFromOrd(ord);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            name = "" + ord;
        }
        if (name.length() > 25) {
            name = "..." + name.substring(name.length() - 25, name.length());
        }
        return name;
    }

    private static String toTabNameFromOrd(BOrd ord) {
        int slash;
        String name;
        if (ord.isNull()) {
            return "null";
        }
        OrdQuery[] q = ord.parse();
        int len = q.length;
        int lastIndex = len - 1;
        OrdQuery last = q[lastIndex];
        String view = null;
        if (last instanceof ViewQuery && len >= 2) {
            int colon;
            String viewId = ((ViewQuery)last).getViewId();
            if (viewId != null && (colon = viewId.indexOf(58)) > 0) {
                view = viewId.substring(colon + 1);
            }
            last = q[--lastIndex];
        }
        if ((name = last.toString()).length() > 25 && (slash = name.indexOf(47)) > 0) {
            name = name.substring(slash + 1);
        }
        return name;
    }

    class Support
    extends BTabbedPane.TabSupport {
        Support() {
        }

        public void tabPopup(BLabelPane labelPane, BMouseEvent event) {
            BViewTab tab = (BViewTab)labelPane;
            BMenu menu = new BMenu();
            menu.add(null, ((BViewTabbedPane)BViewTabbedPane.this).shell.commands.newTab);
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (Command)((BViewTabbedPane)BViewTabbedPane.this).shell.commands.makeCloseTab(tab));
            menu.add(null, (Command)((BViewTabbedPane)BViewTabbedPane.this).shell.commands.makeCloseOtherTabs(tab));
            menu.open((BWidget)BViewTabbedPane.this, event.getX(), event.getY());
        }
    }
}

