/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.workbench.pathbar.BPathBarAgent;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BViewTabbedPane;
import com.tridium.workbench.shell.NHyperlinkInfo;
import com.tridium.workbench.shell.WbHistory;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.fox.BFoxProxySession;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.UndoManager;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class BViewTab
extends BLabelPane
implements BFoxProxySession.NotifyListener {
    public static final Type TYPE = Sys.loadType(BViewTab.class);
    private static int masterId = 0;
    public static Lexicon lex = Lexicon.make((String)"workbench");
    public final BNiagaraWbShell shell;
    final WbHistory history;
    final int id = masterId++;
    BOrd ord;
    boolean hasParent;
    OrdTarget target;
    BWbView view;
    AgentInfo agent;
    AgentList agents;
    BPathBarAgent[] pathBarAgents;
    UndoManager undoManager = new UndoManager((BWidget)this);
    String fault = null;

    public Type getType() {
        return TYPE;
    }

    public BViewTab() {
        throw new IllegalStateException();
    }

    public BViewTab(BNiagaraWbShell shell) {
        this.shell = shell;
        this.history = new WbHistory(shell);
    }

    public BOrd getOrd() {
        return this.ord;
    }

    public OrdTarget getTarget() {
        return this.target;
    }

    public AgentInfo getViewAgent() {
        return this.agent;
    }

    public AgentList getViewAgents() {
        return this.agents;
    }

    public BWbView getView() {
        return this.view;
    }

    public BPathBarAgent[] getPathBarAgents() {
        return this.pathBarAgents;
    }

    public String getDisplayName() {
        return this.getLabel().getText();
    }

    public void updateOrd(BOrd ord) {
        this.ord = ord;
        if (this.pathBarAgents != null && this.pathBarAgents.length > 0) {
            OrdQuery[] queries = ord.parse();
            this.pathBarAgents[this.pathBarAgents.length - 1].setAgentOrd(ord, queries[queries.length - 1]);
        }
        this.updateShell();
    }

    public void onAppendToHistory(BOrd ord) {
        WbHistory.Entry entry = this.history.getCurrent();
        if (entry == null || entry.ord == null || !entry.ord.equals((Object)ord)) {
            this.history.append(ord);
            BNiagaraWbShell.history.append(ord);
        }
    }

    public void onForward() {
        this.history.forward();
    }

    public void onBack() {
        this.history.back();
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
    }

    public void updateShell() {
        BComplex parent = this.getParent();
        if (parent != null && parent instanceof BViewTabbedPane && ((BViewTabbedPane)parent).getSelectedLabelPane() == this) {
            this.shell.commands.updateTab(this);
            this.shell.pane.update(this);
            this.updateUndoCommands();
        }
    }

    private void updateUndoCommands() {
        try {
            this.shell.setInstalledUndoManager(this.undoManager);
            Command undo = this.undoManager.getUndoCommand();
            Command redo = this.undoManager.getRedoCommand();
            if (this.shell.commands.undoButton != null) {
                this.shell.commands.undoButton.setCommand(undo, false, true);
            }
            if (this.shell.commands.redoButton != null) {
                this.shell.commands.redoButton.setCommand(redo, false, true);
            }
            if (this.shell.commands.undoMenu != null) {
                this.shell.commands.undoMenu.setCommand(undo, true, true, true);
            }
            if (this.shell.commands.redoMenu != null) {
                this.shell.commands.redoMenu.setCommand(redo, true, true, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void fireActivated() {
        try {
            if (this.view != null) {
                this.view.fw(401);
                this.view.activated();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void fireDeactivated() {
        try {
            if (this.view != null) {
                this.view.fw(402);
                this.view.deactivated();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void closeTab() {
        BISession session;
        if (!this.shell.confirmHyperlink(this)) {
            return;
        }
        if (this.view != null) {
            NHyperlinkInfo.clearCache(this.view);
        }
        BObject object = this.target == null ? null : this.target.get();
        BISession bISession = session = object == null ? null : BOrd.toSession((BObject)object);
        if (session instanceof BFoxSession) {
            ((BFoxSession)session).getActivityMonitor().removeNotifyListener((BFoxProxySession.NotifyListener)this);
        }
        this.fireDeactivated();
        this.shell.pane.views.removeTab(this);
    }

    void stopView(boolean clearOrd) {
        BISession session;
        BObject object = this.target == null ? null : this.target.get();
        BISession bISession = session = object == null ? null : BOrd.toSession((BObject)object);
        if (session instanceof BFoxSession) {
            ((BFoxSession)session).getActivityMonitor().removeNotifyListener((BFoxProxySession.NotifyListener)this);
        }
        this.fireDeactivated();
        if (clearOrd) {
            this.ord = null;
        }
        this.target = null;
        this.view = null;
        this.agent = null;
        this.agents = null;
        this.hasParent = false;
        this.undoManager.discardAllArtifacts();
    }

    public String toString(Context cx) {
        return "Tab " + this.id;
    }

    public boolean onNotify(BFoxProxySession session) {
        return BWbShell.getWbShell((BWidget)this).notifyTimeout((BWidget)this, (BISession)session);
    }
}

