/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.security;

import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.NiagaraPolicy;
import com.tridium.security.BPermissionGroupInfo;
import com.tridium.security.BasePermissionGroup;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.fieldeditors.BStringFE;
import java.util.List;
import java.util.StringJoiner;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraSlots(actions={@NiagaraAction(name="updateParameters")})
public class BPermissionGroupFE
extends BWbFieldEditor {
    public static final Action updateParameters = BPermissionGroupFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BPermissionGroupFE.class);
    private BListDropDown groupType = new BListDropDown();
    private BListDropDown policyType = new BListDropDown();
    private BStringFE purpose = new BStringFE();
    private BStringFE parameters = new BStringFE();
    private BBooleanFE required = new BBooleanFE();
    private String previousGroupType = null;
    private static Lexicon bajaLex = Lexicon.make((String)"baja");

    public void updateParameters() {
        this.invoke(updateParameters, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BPermissionGroupFE() {
        BLabel groupTypeLabel = new BLabel(bajaLex.getText("permissions.type"), BHalign.left);
        BLabel policyTypeLabel = new BLabel(bajaLex.get("permissions.policyType"), BHalign.left);
        BLabel purposeLabel = new BLabel(bajaLex.getText("permissions.purpose"), BHalign.left);
        BLabel parametersLabel = new BLabel(bajaLex.get("permissions.params"), BHalign.left);
        BLabel requiredLabel = new BLabel(bajaLex.get("permissions.required"), BHalign.left);
        for (String permissionGroupType : NiagaraPermissionGroup.getPermissionGroupTypes()) {
            this.groupType.getList().addItem((Object)permissionGroupType);
        }
        for (NiagaraPolicy.PolicyType type : NiagaraPolicy.PolicyType.values()) {
            this.policyType.getList().addItem((Object)type.toString());
        }
        BGridPane grid = new BGridPane(2);
        grid.setHalign(BHalign.left);
        grid.setColumnAlign(BHalign.left);
        grid.setRowAlign(BValign.center);
        grid.setStretchColumn(1);
        grid.add(null, (BValue)groupTypeLabel);
        grid.add(null, (BValue)this.groupType);
        grid.add(null, (BValue)policyTypeLabel);
        grid.add(null, (BValue)this.policyType);
        grid.add(null, (BValue)purposeLabel);
        grid.add(null, (BValue)this.purpose);
        grid.add(null, (BValue)parametersLabel);
        grid.add(null, (BValue)this.parameters);
        grid.add(null, (BValue)requiredLabel);
        grid.add(null, (BValue)this.required);
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BBorderPane((BWidget)grid));
        this.setContent((BWidget)edge);
        this.linkTo("lk0", (BComponent)this.groupType, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.groupType, (Slot)BListDropDown.listActionPerformed, (Slot)updateParameters);
        this.linkTo("lk2", (BComponent)this.purpose, (Slot)BStringFE.setModified, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.parameters, (Slot)BStringFE.setModified, (Slot)setModified);
        this.linkTo("lk4", (BComponent)this.required, (Slot)BBooleanFE.setModified, (Slot)setModified);
        this.linkTo("lk5", (BComponent)this.policyType, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
    }

    @Override
    protected void doLoadValue(BObject value, Context context) {
        if (value instanceof BPermissionGroupInfo) {
            BPermissionGroupInfo info = (BPermissionGroupInfo)value;
            this.groupType.setSelectedItem((Object)info.getGroupType());
            this.purpose.loadValue((BObject)BString.make((String)info.getPurpose()));
            this.parameters.loadValue((BObject)BString.make((String)info.getParameters()));
            this.required.loadValue((BObject)BBoolean.make((boolean)info.getRequired()));
            this.policyType.setSelectedItem((Object)info.getPolicyType());
        }
    }

    public void doUpdateParameters() {
        List parameterInfos;
        String type = (String)this.groupType.getSelectedItem();
        if (type.equals(this.previousGroupType)) {
            return;
        }
        this.previousGroupType = type;
        NiagaraPermissionGroup permissionGroup = NiagaraPermissionGroup.getPermissionGroupForType((String)type);
        String initialParameterString = "N/A";
        boolean readonly = true;
        if (permissionGroup instanceof BasePermissionGroup && (parameterInfos = ((BasePermissionGroup)permissionGroup).getParameterInfo()) != null) {
            StringJoiner joiner = new StringJoiner("|");
            for (BasePermissionGroup.ParameterInfo parameterInfo : parameterInfos) {
                joiner.add(parameterInfo.xmlAttribute + "=");
            }
            initialParameterString = joiner.toString();
            readonly = false;
        }
        this.parameters.loadValue((BObject)BString.make((String)initialParameterString));
        this.parameters.setReadonly(readonly);
    }

    public BPermissionGroupInfo getPermissionGroupInfo() {
        try {
            return new BPermissionGroupInfo((String)this.groupType.getSelectedItem(), ((BString)this.purpose.saveValue()).getString(), ((BString)this.parameters.saveValue()).getString(), ((BBoolean)this.required.saveValue()).getBoolean(), (String)this.policyType.getSelectedItem());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

