/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.px;

import com.tridium.ui.util.ValidationUtil;
import com.tridium.workbench.px.BOnMediaMigrationError;
import com.tridium.workbench.px.PxFileMediaMigrator;
import com.tridium.workbench.px.PxFileMigrator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BPxView;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.ui.px.BPxMedia;
import javax.baja.util.BTypeSpec;
import javax.baja.util.CannotValidateException;
import javax.baja.util.LexiconModule;

public class PxViewMediaMigrator {
    private BTypeSpec media;
    private boolean dryRun = true;
    private BOnMediaMigrationError onValidationError = BOnMediaMigrationError.abort;
    protected static final Logger LOG = Logger.getLogger(PxFileMigrator.class.getName());
    private static final LexiconModule LEX = LexiconModule.make((String)"workbench");

    public static CompletableFuture<Void> migrateToMedia(PxViewMediaMigrator migrator, BOrd rootComponentOrd, boolean skipFrozenViews, Context cx) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        Runnable r = () -> {
            BOrd pxViewsQuery = BOrd.make((BOrd)rootComponentOrd, (String)"bql:select * from baja:AbstractPxView");
            BITable views = (BITable)pxViewsQuery.get();
            TableCursor cursor = views.cursor();
            while (cursor.next()) {
                BAbstractPxView view = (BAbstractPxView)cursor.get();
                BOrd navOrd = PxViewMediaMigrator.getNavOrd(view);
                boolean isMedia = migrator.media.equals((Object)view.getMedia());
                if (isMedia) {
                    LOG.log(Level.FINE, LEX.getText("pxViewMediaMigration.alreadyTargetMedia", cx, new Object[]{view.getName(), navOrd}));
                    continue;
                }
                try {
                    migrator.migratePxView(view, skipFrozenViews, cx);
                }
                catch (Exception e) {
                    switch (migrator.onValidationError.getOrdinal()) {
                        case 2: {
                            promise.completeExceptionally(e);
                            return;
                        }
                        case 0: 
                        case 1: {
                            migrator.logViewError(view.getName(), navOrd, e.getMessage(), cx);
                        }
                    }
                }
            }
            promise.complete(null);
        };
        new Thread(r, "PxViewMediaMigrator.migrateToMedia").start();
        return promise;
    }

    public void migratePxView(BAbstractPxView view, boolean skipFrozenViews, Context cx) throws Exception {
        if (!PxViewMediaMigrator.isMigratable(view, skipFrozenViews)) {
            return;
        }
        if (view instanceof BPxView) {
            OrdTarget target = ((BPxView)view).getPxFile().resolve((BObject)BLocalHost.INSTANCE, cx);
            this.processTarget(target, view, cx);
        } else {
            BComponent parent = view.getParentComponent();
            if (parent == null) {
                return;
            }
            this.processTarget(OrdTarget.unmounted((BObject)parent, (Context)cx), view, cx);
        }
    }

    private static boolean isMigratable(BAbstractPxView view, boolean skipFrozenViews) {
        if (view == null) {
            return false;
        }
        try {
            if (view.getType().is(Sys.getType((String)"niagaraDriver:AbstractSubstitutePxView"))) {
                return false;
            }
            Property p = view.getPropertyInParent();
            if (skipFrozenViews && p != null && p.isFrozen()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !Flags.isReadonly((BComplex)view, (Slot)view.getSlot(BAbstractPxView.media.getName()));
    }

    public PxViewMediaMigrator inDryRunMode(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public PxViewMediaMigrator onValidationError(String onValidationError) {
        return this.onValidationError(BOnMediaMigrationError.make(onValidationError));
    }

    public PxViewMediaMigrator onValidationError(BOnMediaMigrationError onValidationError) {
        this.onValidationError = onValidationError;
        return this;
    }

    public PxViewMediaMigrator toMedia(BTypeSpec media) {
        this.media = media;
        return this;
    }

    private static BOrd getNavOrd(BAbstractPxView pxView) {
        BComponent parent = pxView.getParentComponent();
        return parent == null ? null : parent.getNavOrd();
    }

    private void processTarget(OrdTarget target, BAbstractPxView view, Context cx) throws Exception {
        BOrd pxViewOrd = PxViewMediaMigrator.getNavOrd(view);
        Map warnings = ValidationUtil.getValidationWarnings((BPxMedia)((BPxMedia)this.media.getInstance()), (OrdTarget)target, (BAbstractPxView)view, (Context)cx);
        if (warnings.isEmpty()) {
            PxViewMediaMigrator.logSuccess(view.getName(), pxViewOrd, cx);
            if (!this.dryRun) {
                view.setMedia(this.media);
            }
        } else {
            String warningString = PxFileMediaMigrator.warningsToString(warnings);
            this.logViewError(view.getName(), pxViewOrd, warningString, cx);
            switch (this.onValidationError.getOrdinal()) {
                case 0: {
                    if (this.dryRun) break;
                    view.setMedia(this.media);
                    break;
                }
                case 1: {
                    return;
                }
                case 2: {
                    throw new CannotValidateException(warningString);
                }
            }
        }
    }

    private static void logSuccess(String viewName, BOrd pxViewOrd, Context cx) {
        LOG.log(Level.INFO, LEX.getText("pxViewMediaMigration.validationSuccessful.write", cx, new Object[]{viewName, pxViewOrd}));
    }

    public void logViewError(String viewName, BOrd pxViewOrd, String validationWarnings, Context cx) {
        LOG.log(Level.SEVERE, LEX.getText(this.getViewKey(), cx, new Object[]{viewName, pxViewOrd, validationWarnings}));
    }

    private String getViewKey() {
        switch (this.onValidationError.getOrdinal()) {
            case 0: {
                return "pxViewMediaMigration.validationError.write";
            }
            case 1: {
                return "pxViewMediaMigration.validationError.skip";
            }
            case 2: {
                return "pxViewMediaMigration.validationError.abort";
            }
        }
        throw new RuntimeException("unrecognized enum");
    }
}

