/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.px;

import com.tridium.nre.ConsumerWithException;
import com.tridium.nre.RunnableWithException;
import com.tridium.ui.util.ValidationUtil;
import com.tridium.workbench.px.BOnMediaMigrationError;
import com.tridium.workbench.px.PxFileMigrationArguments;
import com.tridium.workbench.px.PxFileMigrator;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.naming.BOrd;
import javax.baja.sys.Context;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.BPxMedia;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.px.PxEncoder;
import javax.baja.util.BTypeSpec;
import javax.baja.util.CannotValidateException;

public class PxFileMediaMigrator
extends PxFileMigrator<PxFileMediaMigrator> {
    private BTypeSpec media;
    private PxDecoder decoder;
    private BWidget rootWidget;
    private BOrd pxFileOrd;
    public static final String MEDIA_TYPE = "media-type";
    public static final String ON_VALIDATION_ERROR = "on-validation-error";

    public static void main(String ... args) throws Exception {
        PxFileMigrationArguments migrationArgs = new PxFileMigrationArguments(args);
        PxFileMediaMigrator migrator = (PxFileMediaMigrator)((PxFileMediaMigrator)((PxFileMediaMigrator)new PxFileMediaMigrator().inDryRunMode(migrationArgs.isDryRun())).preservingIdentities(migrationArgs.isPreserveIdentities())).onValidationError(migrationArgs.getOption(ON_VALIDATION_ERROR, "abort"));
        PxFileMediaMigrator.migrateToMedia(migrator, BOrd.make((String)migrationArgs.getRootFilePath()), migrationArgs.getRegex(), null).exceptionally(e -> {
            LOG.log(Level.SEVERE, "Px file migration failed.", (Throwable)e);
            return null;
        });
    }

    public static PxFileMediaMigrator make(BTypeSpec media, boolean dryRun, BOnMediaMigrationError onValidationError) {
        return (PxFileMediaMigrator)((PxFileMediaMigrator)new PxFileMediaMigrator().toMedia(media).inDryRunMode(dryRun)).onValidationError(onValidationError);
    }

    public static PxFileMediaMigrator make(PxFileMigrationArguments args) {
        return (PxFileMediaMigrator)((PxFileMediaMigrator)((PxFileMediaMigrator)new PxFileMediaMigrator().inDryRunMode(args.isDryRun())).toMedia(BTypeSpec.make((String)args.getOption(MEDIA_TYPE, "uxBuilder:UxMedia"))).preservingIdentities(args.isPreserveIdentities())).onValidationError(args.getOption(ON_VALIDATION_ERROR, "abort"));
    }

    public static CompletableFuture<Void> migrateToMedia(PxFileMediaMigrator migrator, BOrd rootFilePath, String regex, Context cx) {
        return PxFileMediaMigrator.processAllAsync(migrator, rootFilePath, regex, cx);
    }

    @Override
    public boolean readyToPersist(BOrd pxFileOrd, InputStream in, Context cx) throws Exception {
        boolean isNStation = pxFileOrd.toString().contains("^nstations/");
        if (isNStation) {
            LOG.log(Level.FINE, LEX.getText("pxFileMediaMigration.virtualsSkipped", cx, new Object[]{pxFileOrd}));
            return false;
        }
        this.pxFileOrd = pxFileOrd;
        this.decoder = new PxDecoder(pxFileOrd, in);
        this.rootWidget = this.decoder.decodeDocument();
        boolean isMedia = this.media.getTypeInfo().equals(this.decoder.getMedia());
        if (isMedia) {
            LOG.log(Level.FINE, LEX.getText("pxFileMediaMigration.alreadyTargetMedia", cx, new Object[]{pxFileOrd}));
            return false;
        }
        return true;
    }

    public void ifValid(RunnableWithException<? extends Exception> r, RunnableWithException<? extends Exception> onValid, ConsumerWithException<String, ? extends Exception> onWarning, Context cx) throws Exception {
        if (this.rootWidget == null) {
            throw new IllegalStateException("must call process() first");
        }
        BPxMedia mediaInstance = (BPxMedia)this.media.getInstance();
        Map warnings = ValidationUtil.getValidationWarnings((BPxMedia)mediaInstance, (BWidget)this.rootWidget, (Context)cx);
        if (warnings.isEmpty()) {
            onValid.run();
            r.run();
        } else {
            String warningString = PxFileMediaMigrator.warningsToString(warnings);
            onWarning.accept((Object)warningString);
            switch (this.onValidationError.getOrdinal()) {
                case 0: {
                    r.run();
                    break;
                }
                case 1: {
                    return;
                }
                case 2: {
                    throw new CannotValidateException(warningString);
                }
            }
        }
    }

    @Override
    public void persist(OutputStream out, Context cx) throws Exception {
        this.ifValid((RunnableWithException<? extends Exception>)((RunnableWithException)() -> {
            if (!this.dryRun) {
                new PxEncoder(out).setPreserveIdentities(this.preserveIdentities).encodeDocumentWithMedia(this.rootWidget, this.decoder.getPxProperties(), this.decoder.getPxLayers(), this.media);
            }
        }), (RunnableWithException<? extends Exception>)((RunnableWithException)() -> this.logInfo(null, LEX.getText("pxFileMediaMigration.validationSuccessful.write", cx, new Object[]{this.pxFileOrd}))), (ConsumerWithException<String, ? extends Exception>)((ConsumerWithException)warningString -> this.logFileError(this.pxFileOrd, (String)warningString, cx)), cx);
    }

    public PxFileMediaMigrator toMedia(BTypeSpec media) {
        this.media = media;
        return this;
    }

    private void logFileError(BOrd ord, String validationWarnings, Context cx) {
        LOG.log(Level.SEVERE, LEX.getText(PxFileMediaMigrator.getFileKey(this.onValidationError), cx, new Object[]{ord, validationWarnings}));
    }

    private static String getFileKey(BOnMediaMigrationError onValidationError) {
        switch (onValidationError.getOrdinal()) {
            case 0: {
                return "pxFileMediaMigration.validationError.write";
            }
            case 1: {
                return "pxFileMediaMigration.validationError.skip";
            }
            case 2: {
                return "pxFileMediaMigration.validationError.abort";
            }
        }
        throw new RuntimeException("unrecognized enum");
    }

    public static String warningsToString(Map<String, String> warnings) {
        return warnings.entrySet().stream().map(e -> (String)e.getKey() + ':' + (String)e.getValue()).collect(Collectors.joining("\n"));
    }
}

