/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.px;

import com.tridium.workbench.px.BOnMediaMigrationError;
import com.tridium.workbench.px.PxFileMediaMigrator;
import com.tridium.workbench.px.PxViewMediaMigrator;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="execute"), @NiagaraAction(name="dryRun")})
@NiagaraProperties(value={@NiagaraProperty(name="processFiles", type="boolean", defaultValue="true"), @NiagaraProperty(name="filePath", type="baja:Ord", defaultValue="BOrd.make(\"file:^\")"), @NiagaraProperty(name="filePathRegex", type="String", defaultValue="\\.px$"), @NiagaraProperty(name="preserveIdentities", type="boolean", defaultValue="false"), @NiagaraProperty(name="processViews", type="boolean", defaultValue="true"), @NiagaraProperty(name="rootViewOrd", type="baja:Ord", defaultValue="BOrd.make(\"station:|slot:/\")"), @NiagaraProperty(name="skipFrozenViews", type="boolean", defaultValue="true"), @NiagaraProperty(name="onValidationError", type="workbench:OnMediaMigrationError", defaultValue="BOnMediaMigrationError.abort"), @NiagaraProperty(name="mediaType", type="baja:TypeSpec", defaultValue="BTypeSpec.make(\"uxBuilder:UxMedia\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="\"bajaui:PxMedia\"")})})
public class BPxMediaMigrator
extends BComponent {
    public static final Property processFiles = BPxMediaMigrator.newProperty((int)0, (boolean)true, null);
    public static final Property filePath = BPxMediaMigrator.newProperty((int)0, (BValue)BOrd.make((String)"file:^"), null);
    public static final Property filePathRegex = BPxMediaMigrator.newProperty((int)0, (String)"\\.px$", null);
    public static final Property preserveIdentities = BPxMediaMigrator.newProperty((int)0, (boolean)false, null);
    public static final Property processViews = BPxMediaMigrator.newProperty((int)0, (boolean)true, null);
    public static final Property rootViewOrd = BPxMediaMigrator.newProperty((int)0, (BValue)BOrd.make((String)"station:|slot:/"), null);
    public static final Property skipFrozenViews = BPxMediaMigrator.newProperty((int)0, (boolean)true, null);
    public static final Property onValidationError = BPxMediaMigrator.newProperty((int)0, (BValue)BOnMediaMigrationError.abort, null);
    public static final Property mediaType = BPxMediaMigrator.newProperty((int)0, (BValue)BTypeSpec.make((String)"uxBuilder:UxMedia"), (BFacets)BFacets.make((String)"targetType", (String)"bajaui:PxMedia"));
    public static final Action execute = BPxMediaMigrator.newAction((int)0, null);
    public static final Action dryRun = BPxMediaMigrator.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BPxMediaMigrator.class);

    public boolean getProcessFiles() {
        return this.getBoolean(processFiles);
    }

    public void setProcessFiles(boolean v) {
        this.setBoolean(processFiles, v, null);
    }

    public BOrd getFilePath() {
        return (BOrd)this.get(filePath);
    }

    public void setFilePath(BOrd v) {
        this.set(filePath, (BValue)v, null);
    }

    public String getFilePathRegex() {
        return this.getString(filePathRegex);
    }

    public void setFilePathRegex(String v) {
        this.setString(filePathRegex, v, null);
    }

    public boolean getPreserveIdentities() {
        return this.getBoolean(preserveIdentities);
    }

    public void setPreserveIdentities(boolean v) {
        this.setBoolean(preserveIdentities, v, null);
    }

    public boolean getProcessViews() {
        return this.getBoolean(processViews);
    }

    public void setProcessViews(boolean v) {
        this.setBoolean(processViews, v, null);
    }

    public BOrd getRootViewOrd() {
        return (BOrd)this.get(rootViewOrd);
    }

    public void setRootViewOrd(BOrd v) {
        this.set(rootViewOrd, (BValue)v, null);
    }

    public boolean getSkipFrozenViews() {
        return this.getBoolean(skipFrozenViews);
    }

    public void setSkipFrozenViews(boolean v) {
        this.setBoolean(skipFrozenViews, v, null);
    }

    public BOnMediaMigrationError getOnValidationError() {
        return (BOnMediaMigrationError)this.get(onValidationError);
    }

    public void setOnValidationError(BOnMediaMigrationError v) {
        this.set(onValidationError, (BValue)v, null);
    }

    public BTypeSpec getMediaType() {
        return (BTypeSpec)this.get(mediaType);
    }

    public void setMediaType(BTypeSpec v) {
        this.set(mediaType, (BValue)v, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public void dryRun() {
        this.invoke(dryRun, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doExecute(Context cx) throws Exception {
        this.doMigration(false, cx);
    }

    public void doDryRun(Context cx) throws Exception {
        this.doMigration(true, cx);
    }

    private static Logger getLogger() {
        return Logger.getLogger("com.tridium.px.editor.util");
    }

    private void doMigration(boolean dryRun, Context cx) {
        if (cx == null) {
            cx = new BasicContext();
        }
        if (this.getProcessFiles()) {
            ((CompletableFuture)this.migrateAllFiles((PxFileMediaMigrator)this.buildFileMigrator().inDryRunMode(dryRun), cx).thenRun(() -> BPxMediaMigrator.getLogger().info("Px file migration " + (dryRun ? "dry run " : "") + "complete"))).exceptionally(e -> {
                BPxMediaMigrator.getLogger().log(Level.SEVERE, "Px file migration failed.", (Throwable)e);
                return null;
            });
        }
        if (this.getProcessViews()) {
            ((CompletableFuture)this.migrateAllViews(this.buildViewMigrator().inDryRunMode(dryRun), cx).thenRun(() -> BPxMediaMigrator.getLogger().info("Px view migration " + (dryRun ? "dry run " : "") + "complete"))).exceptionally(e -> {
                BPxMediaMigrator.getLogger().log(Level.SEVERE, "Px view migration failed.", (Throwable)e);
                return null;
            });
        }
    }

    private CompletableFuture<Void> migrateAllViews(PxViewMediaMigrator migrator, Context cx) {
        return PxViewMediaMigrator.migrateToMedia(migrator, this.getRootViewOrd(), this.getSkipFrozenViews(), cx);
    }

    private CompletableFuture<Void> migrateAllFiles(PxFileMediaMigrator migrator, Context cx) {
        return PxFileMediaMigrator.migrateToMedia(migrator, this.getFilePath(), this.getFilePathRegex(), cx);
    }

    private PxViewMediaMigrator buildViewMigrator() {
        return new PxViewMediaMigrator().toMedia(this.getMediaType()).onValidationError(this.getOnValidationError().getTag());
    }

    private PxFileMediaMigrator buildFileMigrator() {
        return (PxFileMediaMigrator)((PxFileMediaMigrator)new PxFileMediaMigrator().toMedia(this.getMediaType()).preservingIdentities(this.getPreserveIdentities())).onValidationError(this.getOnValidationError().getTag());
    }
}

