/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.preview;

import com.tridium.ui.theme.LabelTheme;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.preview.BComponentPreviewFactory;
import com.tridium.workbench.transfer.TransferUtil;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.util.Lexicon;

public final class BComponentPreviewWidget
extends BTransferWidget {
    public static final Type TYPE = Sys.loadType(BComponentPreviewWidget.class);
    private String dragDisplayName = "";
    private BImage dragImage = BImage.DEFAULT;
    private BWidget prevWid;
    private BComponent comp;
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static final double prevIndent = 5.0;

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        double width = this.getWidth();
        double height = this.getHeight();
        LabelTheme theme = Theme.label();
        g.setBrush(theme.getWindowBackground());
        g.fillRect(0.0, 0.0, width, height);
        boolean available = false;
        if (this.prevWid != null && this.prevWid.getWidth() > 0.0 && this.prevWid.getHeight() > 0.0) {
            available = true;
        }
        if (!available) {
            g.setBrush(theme.getTextBrush());
            BFont font = theme.getTextFont();
            g.setFont(font);
            String txt = lex.getText("PaletteSideBar.noPrevFound");
            double w = font.width(txt);
            double h = font.getDescent();
            double x = width > w + 10.0 ? (width - w) / 2.0 : 0.0;
            double y = height > h ? height / 2.0 + h : font.getHeight();
            g.drawString(txt, x + 5.0, y);
        } else {
            double inw = width - 10.0;
            double inh = height - 10.0;
            BImage img = BImage.make((double)this.prevWid.getWidth(), (double)this.prevWid.getHeight());
            Graphics g2 = img.getGraphics();
            try {
                g2.clip(0.0, 0.0, this.prevWid.getWidth(), this.prevWid.getHeight());
                g2.setBrush(theme.getWindowBackground());
                g2.fillRect(0.0, 0.0, this.prevWid.getWidth(), this.prevWid.getHeight());
                this.prevWid.paint(g2);
            }
            finally {
                g2.dispose();
            }
            if (this.prevWid.getWidth() > inw || this.prevWid.getHeight() > inh) {
                double scaleX = inw / this.prevWid.getWidth();
                double scaleY = inh / this.prevWid.getHeight();
                double scale = Math.min(scaleX, scaleY);
                img = img.transform(BTransform.makeScale((double)scale, (double)scale));
            }
            double x = (width - img.getWidth()) / 2.0;
            double y = (height - img.getHeight()) / 2.0;
            g.drawImage(img, x, y);
        }
    }

    public TransferEnvelope getTransferData() throws Exception {
        if (this.comp == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)new Mark((BObject)this.comp));
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        return TransferUtil.insert((BWidget)this, cx, (BObject)this.comp, null);
    }

    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        return null;
    }

    public void mouseDragStarted(BMouseEvent event) {
        if (this.comp == null) {
            return;
        }
        SimpleDragRenderer dragRenderer = new SimpleDragRenderer(this.dragImage, this.dragDisplayName);
        dragRenderer.font = Theme.tree().getFont((BWidget)this);
        dragRenderer.xCursorOffset = Theme.tree().getExpanderWidth() + 4.0;
        dragRenderer.yCursorOffset = Theme.tree().getExpanderWidth() + 4.0;
        TransferEnvelope envelope = TransferEnvelope.make((Mark)new Mark((BObject)this.comp));
        this.startDrag(event, this.makeTransferContext(envelope), (DragRenderer)dragRenderer);
    }

    public void setCurrentComponent(BComponent comp) {
        this.prevWid = null;
        this.comp = comp;
        this.dragDisplayName = comp == null ? "" : comp.getNavDisplayName(null);
        BImage bImage = this.dragImage = comp == null ? BImage.DEFAULT : BImage.make((BIcon)comp.getNavIcon());
        if (comp != null) {
            this.prevWid = BComponentPreviewFactory.makeFactory(comp, null).getPreviewWidget();
        }
    }
}

