/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.preview;

import com.tridium.workbench.preview.BDefaultComponentPreviewFactory;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.BIAgent;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

public abstract class BComponentPreviewFactory
extends BObject
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BComponentPreviewFactory.class);
    private BComponent comp;
    private Context cx;

    public Type getType() {
        return TYPE;
    }

    public static final BComponentPreviewFactory makeFactory(BComponent comp, Context cx) {
        AgentInfo[] infos = comp.getAgents().filter(new AgentFilter(){

            public boolean include(AgentInfo agent) {
                return agent.getAgentType().is(TYPE);
            }
        }).list();
        BComponentPreviewFactory factory = infos.length > 0 ? (BComponentPreviewFactory)infos[0].getInstance() : new BDefaultComponentPreviewFactory();
        factory.comp = comp;
        factory.cx = cx;
        return factory;
    }

    public abstract BWidget getPreviewWidget();

    protected final BComponent getComponent() {
        return this.comp;
    }

    protected final Context getContext() {
        return this.cx;
    }

    protected final void computeDefaultSize(BWidget widget) {
        widget.computePreferredSize();
        widget.setSize(widget.getPreferredWidth(), widget.getPreferredHeight());
        widget.layout();
    }
}

