/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.pathbar;

import com.tridium.ui.awt.NPopup;
import com.tridium.ui.theme.Theme;
import com.tridium.util.EscUtil;
import com.tridium.workbench.pathbar.BPathBar;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.shell.WbHistory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.text.TextSelection;
import javax.baja.workbench.view.BWbView;

public class BPathBarTextField
extends BTextField {
    public static final Type TYPE = Sys.loadType(BPathBarTextField.class);
    private static final Pattern colonsPattern = Pattern.compile(".*:.*");
    private static final Pattern dotLocalHostPattern = Pattern.compile(".*\\..*|http(s)?://localhost", 2);
    private BPathBar pathBar;
    private BViewTab tab;
    private TextModel model;
    private TextController controller;
    private TextSelection selection;
    private TextRenderer renderer;
    private BList suggestions = new BList();
    private boolean focusFromList;
    private Position lastCaretPosition;
    private NPopup popup;
    private BKeyEvent lastKeyEvent;

    public Type getType() {
        return TYPE;
    }

    BPathBarTextField(BPathBar pathBar) {
        super(pathBar.shell.tab().getOrd().toString());
        this.tab = pathBar.shell.tab();
        this.pathBar = pathBar;
        this.model = this.getModel();
        this.controller = this.getController();
        this.selection = this.getSelection();
        this.renderer = new PathBarTextRenderer();
        this.setRenderer(this.renderer);
        this.suggestions.setRenderer((ListRenderer)new PathListRenderer());
        this.suggestions.setController((ListController)new PathListController());
        this.suggestions.setStyleId("pathbar-list");
        this.setExpandHeight(true);
    }

    protected BInsets getInsets() {
        BInsets insets = super.getInsets();
        return BInsets.make((double)insets.top, (double)insets.right, (double)insets.bottom, (double)(insets.left + 10.0));
    }

    public String getStyleId() {
        return "pathbar-text-field";
    }

    protected void paintBorder(Graphics g) {
    }

    public void fireKeyEvent(BKeyEvent event) {
        super.fireKeyEvent(event);
        if (NPopup.isOpen((BWidget)this.suggestions) && this.suggestions.getItemCount() > 0) {
            this.suggestions.fireKeyEvent(event);
        }
    }

    public void fireCancelled(BWidgetEvent event) {
        super.fireCancelled(event);
        this.pathBar.requestFocus();
    }

    public void keyReleased(BKeyEvent event) {
        super.keyReleased(event);
        event.consume();
        this.lastKeyEvent = event;
        if (event.getKeyCode() == 10) {
            this.hyperlink();
            return;
        }
        if (!this.validKeyEvent(event)) {
            return;
        }
        String prefix = this.getPrefix();
        this.populateSuggestions(prefix);
        BPathBarTextField.invokeLater(this::displaySuggestions);
    }

    public void focusGained(BFocusEvent event) {
        super.focusGained(event);
        if (this.focusFromList) {
            this.selection.deselect();
            this.selection.select(this.end(), this.lastCaretPosition);
            this.focusFromList = false;
        }
    }

    public void focusLost(BFocusEvent event) {
        if (NPopup.isOpen((BWidget)this.suggestions)) {
            this.focusFromList = true;
            this.lastCaretPosition = this.current();
            this.requestFocus();
            return;
        }
        if (this.pathBar != null) {
            this.pathBar.exitEditMode();
            this.pathBar.update(this.tab);
        }
    }

    private void hyperlink() {
        String ordStr = this.getText();
        if (!colonsPattern.matcher(ordStr).matches() && !dotLocalHostPattern.matcher(ordStr = "http://" + ordStr).matches()) {
            ordStr = ordStr + ".com";
        }
        this.hyperlink(BOrd.make((String)ordStr));
    }

    private void hyperlink(BOrd ord) {
        if (NPopup.isOpen((BWidget)this.suggestions)) {
            NPopup.close((BWidget)this.suggestions);
        }
        if (ord != null && !ord.isNull() && this.tab != null && this.tab.shell != null) {
            this.tab.shell.hyperlink(new HyperlinkInfo(ord));
            BWbView view = this.tab.getView();
            if (view != null) {
                view.requestFocus();
            }
        }
    }

    private boolean validKeyEvent(BKeyEvent event) {
        int key = event.getKeyCode();
        if (key == 127 || key == 8) {
            return true;
        }
        char c = event.getKeyChar();
        return EscUtil.ord.isStart((int)c) || EscUtil.ord.isPart((int)c) || event.isControlDown() && key == 86;
    }

    private Iterator<WbHistory.Entry> getRecentEntries() {
        return Arrays.asList(BNiagaraWbShell.getWbHistory().recentList()).iterator();
    }

    private void insertSuggestedText(String suggestion) {
        Position currentPosition = this.current();
        this.setText(suggestion);
        if (!this.selection.isEmpty()) {
            this.selection.deselect();
        }
        this.selection.select(this.end(), currentPosition);
    }

    private void populateSuggestions(String prefix) {
        Iterator<WbHistory.Entry> entries = this.getRecentEntries();
        this.suggestions.removeAllItems();
        if (prefix.isEmpty()) {
            return;
        }
        this.suggestions.addItem((Object)prefix);
        String firstEntry = null;
        while (entries.hasNext()) {
            String ordStr;
            int index;
            WbHistory.Entry entry = entries.next();
            if (entry == null || (index = (ordStr = entry.ord.toString()).indexOf(prefix)) == -1) continue;
            if (firstEntry == null && index == 0) {
                int code;
                firstEntry = ordStr;
                int n = code = this.lastKeyEvent != null ? this.lastKeyEvent.getKeyCode() : 0;
                if (code != 8 && code != 127 && code != 0) {
                    this.insertSuggestedText(ordStr);
                }
            }
            this.suggestions.addItem((Object)ordStr);
        }
        if (this.suggestions.getItemCount() > 0) {
            this.suggestions.setSelectedIndex(0);
        }
    }

    private void displaySuggestions() {
        this.suggestions.computePreferredSize();
        double tenItemHeight = this.suggestions.getRenderer().getItemHeight() * 10.0;
        double listPreferredHeight = this.suggestions.getPreferredHeight();
        double maxHeight = Math.min(tenItemHeight, listPreferredHeight);
        if (!NPopup.isOpen((BWidget)this.suggestions)) {
            try {
                this.popup = NPopup.open((BWidget)this.suggestions, (BWidget)this, (double)0.0, (double)this.getHeight(), (double)this.getWidth(), (double)maxHeight);
                this.popup.releaseTempFocus();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (this.popup != null) {
            this.popup.setSize(this.popup.getWidth(), (int)maxHeight);
        }
    }

    private String getPrefix() {
        Position from = this._start();
        Position to = this.end();
        return this.model.getText(from, to);
    }

    private Position current() {
        return this.getCaretPosition();
    }

    private Position end() {
        return this.model.getEndPosition();
    }

    private Position _start() {
        return this.model.getStartPosition();
    }

    private class PathListController
    extends ListController {
        private PathListController() {
        }

        protected void itemPressed(BMouseEvent event, int index) {
            super.itemPressed(event, index);
            BOrd ord = BOrd.make((String)BPathBarTextField.this.suggestions.getItem(index).toString());
            NPopup.close((BWidget)BPathBarTextField.this.suggestions);
            BPathBarTextField.this.hyperlink(ord);
        }

        protected void itemEntered(BMouseEvent event, int index) {
            super.itemEntered(event, index);
            BPathBarTextField.this.suggestions.setSelectedIndex(index);
        }

        public void keyPressed(BKeyEvent event) {
            int key = event.getKeyCode();
            if (key != 38 && key != 33 && key != 40 && key != 34) {
                return;
            }
            super.keyPressed(event);
            BPathBarTextField.this.setText(this.getList().getSelectedItem().toString());
            BPathBarTextField.this.selection.select(BPathBarTextField.this.end(), BPathBarTextField.this._start());
        }
    }

    private class PathListRenderer
    extends ListRenderer {
        private PathListRenderer() {
        }

        public double getItemHeight() {
            return super.getItemHeight() * 1.5;
        }

        public void paintItem(Graphics g, ListRenderer.Item item) {
            this.paintItemBackground(g, item);
            double x = 10.0;
            if (item.icon != null) {
                g.drawImage(item.icon, x, (item.height - item.icon.getHeight()) / 2.0);
                x += 20.0;
            }
            String s = this.getItemText(item);
            BFont font = Theme.widget().getTextFont();
            font = BFont.make((BFont)font, (double)(font.getSize() * 1.2));
            double th = font.getHeight();
            double ta = font.getAscent();
            double ty = (item.height - th) / 2.0;
            double y = ty + ta;
            g.setFont(font);
            String text = BPathBarTextField.this.getText();
            int index = s.indexOf(text);
            if (index != -1) {
                String pre = s.substring(0, index);
                String post = s.substring(index + text.length());
                g.drawString(pre, x, y);
                x += font.width(pre);
                if (!item.selected) {
                    g.push();
                    font = BFont.make((BFont)font, (int)1);
                    g.setFont(font);
                    g.drawString(text, x, y);
                    g.pop();
                } else {
                    g.drawString(text, x, y);
                }
                g.drawString(post, x += font.width(text), y);
            } else {
                g.drawString(s, x, y);
            }
            if (item.index != this.getList().getItemCount() - 1) {
                g.setBrush(Theme.textField().getSelectionBackground((IStylable)BPathBarTextField.this));
                g.strokeLine(0.0, item.height - 1.0, item.width, item.height - 1.0);
            }
        }
    }

    private class PathBarTextRenderer
    extends TextRenderer {
        public PathBarTextRenderer() {
            super(BFont.make((BFont)Theme.textEditor().getFixedWidthBoldFont(), (double)(Theme.textEditor().getFixedWidthBoldFont().getSize() * 1.2)));
        }

        public BBrush getForeground(Segment seg) {
            return Theme.textEditor().getControlForeground((IStylable)this.getEditor());
        }
    }
}

