/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.pathbar;

import com.tridium.workbench.pathbar.BPathBarAgent;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.util.BFileSearch;
import javax.baja.file.BIDirectory;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.BWbShell;

public class BFilePA
extends BPathBarAgent {
    public static final Type TYPE = Sys.loadType(BFilePA.class);
    static final BImage findIcon = BImage.make((String)"module://icons/x16/find.png");

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BPathBarAgent[] explode() {
        BPathBarAgent[] agents;
        BOrd base = this.base();
        FilePath path = (FilePath)this.query();
        String[] names = path.getNames();
        int off = 1;
        String str = "";
        if (path.isSysHomeAbsolute()) {
            agents = new BPathBarAgent[names.length + 2];
            agents[0] = BPathBarAgent.make(new BFilePA(), base, (OrdQuery)new FilePath(""));
            agents[1] = BPathBarAgent.make(new BFilePA(), base, (OrdQuery)new FilePath("!"));
            ++off;
            str = "!";
        } else if (path.isUserHomeAbsolute()) {
            agents = new BPathBarAgent[names.length + 2];
            agents[0] = BPathBarAgent.make(new BFilePA(), base, (OrdQuery)new FilePath(""));
            agents[1] = BPathBarAgent.make(new BFilePA(), base, (OrdQuery)new FilePath("~"));
            ++off;
            str = "~";
        } else if (path.isStationHomeAbsolute()) {
            agents = new BPathBarAgent[names.length + 1];
            agents[0] = BPathBarAgent.make(new BFilePA(), base, (OrdQuery)new FilePath(""));
            str = "^";
        } else {
            agents = new BPathBarAgent[names.length + 1];
            str = path.getAbsoluteBase();
            agents[0] = BPathBarAgent.make(new BFilePA(), base, (OrdQuery)new FilePath(str));
        }
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                str = str + "/";
            }
            str = str + names[i];
            agents[i + off] = BPathBarAgent.make(new BFilePA(), base, (OrdQuery)new FilePath(str));
        }
        return agents;
    }

    @Override
    public Command[] getCommands(BWbShell shell) {
        if (this.query().getBody().length() > 0 && this.resolved() instanceof BIDirectory) {
            return new Command[]{new Find((BWidget)shell)};
        }
        return null;
    }

    class Find
    extends Command {
        public Find(BWidget owner) {
            super(owner, "Find");
            this.icon = findIcon;
        }

        public CommandArtifact doInvoke() {
            BFileSearch.findFiles((BNiagaraWbShell)this.getOwner(), BFilePA.this.query().toString());
            return null;
        }
    }
}

