/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.nav;

import com.tridium.file.util.LicenseGenerator;
import com.tridium.workbench.shell.HelpGenerator;
import com.tridium.workbench.shell.WbMain;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.tool.BWbNavNodeTool;

public class BWorkbenchScheme
extends BOrdScheme {
    public static final BWorkbenchScheme INSTANCE;
    public static final Type TYPE;
    public static BObject helpAbout;
    public static BObject helpContents;
    public static BObject licenseAgreement;
    public static BObject thirdPartyLicenses;

    private BWorkbenchScheme() {
        super("workbench");
    }

    public OrdQuery parse(String queryBody) {
        return new WorkbenchPath(queryBody);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        String path = query.getBody();
        if (path.startsWith("/help")) {
            if ("/help".equals(path)) {
                return new OrdTarget(base, (BObject)BString.DEFAULT);
            }
            if ("/help/about.html".equals(path)) {
                return new OrdTarget(base, helpAbout);
            }
            if ("/help/contents.html".equals(path)) {
                return new OrdTarget(base, helpContents);
            }
        }
        if (path.startsWith("/tools/")) {
            String toolName = path.substring("/tools/".length());
            int slash = toolName.indexOf(47);
            if (slash > 0) {
                toolName = toolName.substring(0, slash);
            }
            return new OrdTarget(base, (BObject)BWbNavNodeTool.make(toolName));
        }
        if (path.startsWith("/licenses/")) {
            if ("/licenses/licenseAgreement.txt".equals(path)) {
                return new OrdTarget(base, licenseAgreement);
            }
            if ("/licenses/readmeLicenses.txt".equals(path)) {
                return new OrdTarget(base, thirdPartyLicenses);
            }
        }
        throw new UnresolvedException(query.toString());
    }

    public Type getType() {
        return TYPE;
    }

    static {
        block2: {
            INSTANCE = new BWorkbenchScheme();
            TYPE = Sys.loadType(BWorkbenchScheme.class);
            try {
                helpAbout = HelpGenerator.makeAbout();
                helpContents = HelpGenerator.makeContents();
                licenseAgreement = (BObject)LicenseGenerator.makeLicenseAgreement();
                thirdPartyLicenses = (BObject)LicenseGenerator.makeThirdPartyLicenses();
            }
            catch (Throwable e) {
                if (WbMain.brandTitle == null) break block2;
                e.printStackTrace();
            }
        }
    }

    static class WorkbenchPath
    extends FilePath {
        WorkbenchPath(String body) {
            super("workbench", body);
        }

        public void normalize(OrdQueryList list, int index) {
            list.trim(index);
        }

        public OrdQuery makePath(String body) {
            return new WorkbenchPath(body);
        }
    }
}

