/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.kiosk;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.kiosk.BKioskService;
import com.tridium.workbench.shell.WbMain;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.PasswordRenderer;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.kiosk.BKioskSplash;

public class BDefaultKioskSplash
extends BKioskSplash {
    public static final Action errorTimerExpired = BDefaultKioskSplash.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BDefaultKioskSplash.class);
    BKioskService kioskService;
    BTextField username;
    BTextField password;
    BBorderPane loginError;
    BButton login;

    public void errorTimerExpired() {
        this.invoke(errorTimerExpired, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BDefaultKioskSplash() {
        UiLexicon lex = UiLexicon.bajaui();
        BFont bold = Theme.widget().getBoldText();
        this.username = new BTextField("", 16);
        this.password = new BTextField("", 16);
        this.password.setRenderer((TextRenderer)new PasswordRenderer());
        this.login = new BButton((Command)new ReflectCommand((BWidget)this, lex.getText("login"), "tryLogin"));
        this.login.linkTo((BComponent)this.username, (Slot)BTextField.actionPerformed, (Slot)BButton.invokeAction);
        this.login.linkTo((BComponent)this.password, (Slot)BTextField.actionPerformed, (Slot)BButton.invokeAction);
        BGridPane input = new BGridPane(2);
        input.add(null, (BValue)new BLabel(lex.getText("username"), bold));
        input.add(null, (BValue)this.username);
        input.add(null, (BValue)new BLabel(lex.getText("password"), bold));
        input.add(null, (BValue)this.password);
        BGridPane input2 = new BGridPane(1);
        input2.setColumnAlign(BHalign.center);
        input2.setRowGap(10.0);
        input2.add(null, (BValue)input);
        input2.add(null, (BValue)this.login);
        BBorderPane inputPane = new BBorderPane((BWidget)input2, BBorder.solid);
        inputPane.setFill(BBrush.make((String)"#ddd"));
        BLabel errorMsg = new BLabel(lex.getText("loginFailed"), bold);
        this.loginError = new BBorderPane((BWidget)errorMsg);
        this.loginError.setFill(BColor.make((int)0xFFEEEE).toBrush());
        this.loginError.setBorder(BBorder.make((double)1.0, (int)1, (BBrush)BColor.make((int)0x800000).toBrush()));
        BLabel splash = new BLabel(this.getSplashImage());
        BGridPane pane = new BGridPane(1);
        pane.setValign(BValign.top);
        pane.setColumnAlign(BHalign.fill);
        pane.setRowGap(14.0);
        pane.add(null, (BValue)splash);
        pane.add(null, (BValue)inputPane);
        pane.add(null, (BValue)this.loginError);
        pane.computePreferredSize();
        BConstrainedPane constraint = new BConstrainedPane((BWidget)pane);
        constraint.setMinHeight(pane.getPreferredHeight());
        this.loginError.setVisible(false);
        BBorderPane border = new BBorderPane((BWidget)new BGridPane(1, new BWidget[]{constraint}));
        border.setFill(this.getSplashFill());
        this.setContent((BWidget)border);
    }

    private BImage getSplashImage() {
        try {
            BKioskService service = (BKioskService)Sys.getService((Type)BKioskService.TYPE);
            BOrd ord = service.getSplashImage();
            if (!ord.isNull()) {
                return BImage.make((BOrd)BOrd.make((BOrd)service.getAbsoluteOrd(), (BOrd)ord));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BImage.make((String)WbMain.brandSplash);
    }

    private BBrush getSplashFill() {
        try {
            BKioskService service = (BKioskService)Sys.getService((Type)BKioskService.TYPE);
            BBrush fill = service.getSplashFill();
            if (!fill.isNull()) {
                return fill;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BColor.make((String)"#eee").toBrush();
    }

    public void tryLogin() throws Exception {
        if (!this.login(this.username.getText(), this.password.getText())) {
            this.loginError.setVisible(true);
            this.loginError.relayout();
            Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)10000L), (Action)errorTimerExpired, null);
        }
    }

    public void doErrorTimerExpired() {
        this.loginError.setVisible(false);
        this.loginError.relayout();
    }
}

