/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.job;

import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BISession;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;

public class JobEvent {
    public static final int SERVICE_ADDED = 1;
    public static final int SERVICE_REMOVED = 2;
    public static final int JOB_ADDED = 3;
    public static final int JOB_REMOVED = 4;
    public static final int JOB_CHANGED = 5;
    final int id;
    final BJobService service;
    final BJob job;
    final BComponentEvent componentEvent;

    public JobEvent(int id, BJobService service) {
        this.id = id;
        this.service = service;
        this.job = null;
        this.componentEvent = null;
    }

    public JobEvent(int id, BJob job, BComponentEvent componentEvent) {
        this.id = id;
        this.service = (BJobService)job.getParent();
        this.job = job;
        this.componentEvent = componentEvent;
    }

    public int getId() {
        return this.id;
    }

    public BJobService getService() {
        return this.service;
    }

    public BJob getJob() {
        return this.job;
    }

    public BComponentEvent getComponentEvent() {
        return this.componentEvent;
    }

    public String toString() {
        switch (this.id) {
            case 1: {
                return "ServiceAdded " + this.toString((BComponent)this.service);
            }
            case 2: {
                return "ServiceRemoved " + this.toString((BComponent)this.service);
            }
            case 3: {
                return "JobAdded " + this.toString((BComponent)this.job);
            }
            case 4: {
                return "JobRemoved " + this.toString((BComponent)this.job);
            }
            case 5: {
                return "JobChanged " + this.toString((BComponent)this.job);
            }
        }
        return "JobEvent ????";
    }

    String toString(BComponent c) {
        String prefix = "???";
        BISession session = c.getSession();
        if (session != null) {
            prefix = "" + session.getNavOrd();
        }
        return prefix + " [" + c.getType() + "]";
    }
}

