/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.workbench.ord.BFileOrdChooser;
import java.security.AccessController;
import javax.baja.file.BDataFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.ord.BIOrdChooser;

@NiagaraType(agent={@AgentOn(types={"baja:X509Certificate"})})
@NiagaraProperty(name="ordFieldLength", type="int", defaultValue="40")
public class BX509CertFE
extends BWbFieldEditor {
    public static final Property ordFieldLength = BX509CertFE.newProperty((int)0, (int)40, null);
    public static final Type TYPE = Sys.loadType(BX509CertFE.class);
    private static final BImage browseIcon = BImage.make((String)"module://icons/x16/open.png");
    private static final String CERT_HOME = AccessController.doPrivileged(() -> System.getProperty("niagara.user.home") + System.getProperty("file.separator") + "certManagement");
    private BWbShell shell;
    private final BLabel subjectDnLabel = new BLabel();
    private final BLabel warningLabel = new BLabel();
    private final BTextField field = new BTextField("", 40, false);
    private final BButton button = new BButton((Command)new Browse());
    private BX509Certificate cachedCert;
    private BOrd fileOrd;
    public static final Lexicon lexicon = Lexicon.make(BX509CertFE.class);
    private String warningText = "";

    public int getOrdFieldLength() {
        return this.getInt(ordFieldLength);
    }

    public void setOrdFieldLength(int v) {
        this.setInt(ordFieldLength, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BX509CertFE() {
        this.button.setButtonStyle(BButtonStyle.toolBar);
        this.button.setVisible(true);
        this.warningLabel.setHalign(BHalign.left);
        this.warningLabel.setForeground(BBrush.makeSolid((BColor)BColor.red));
        BWidget[] pair = new BWidget[]{this.field, this.button};
        BGridPane pairPane = new BGridPane(2, pair);
        BWidget[] childWidgets = new BWidget[]{this.subjectDnLabel, this.warningLabel, pairPane};
        BGridPane grid = new BGridPane(1, childWidgets);
        this.setContent((BWidget)grid);
    }

    public void started() {
        BObject val = this.getCurrentValue();
        if (val != null) {
            this.lockModifiedState();
            this.doLoadValue(val, this.getCurrentContext());
            this.unlockModifiedState();
        }
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.button.setEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject v, Context cx) {
        BObject warning;
        if (v == null) {
            return;
        }
        this.cachedCert = (BX509Certificate)v;
        if (this.cachedCert.getX509Certificate() == null) {
            return;
        }
        if (cx != null && (warning = cx.getFacet("warningText")) != null) {
            this.warningText = BFormat.format((String)warning.toString(), null, (Context)cx);
        }
        if (this.fileOrd != null) {
            this.updateCertSelection();
        } else {
            String subjectDn = this.cachedCert.getX509Certificate().getSubjectDN().toString();
            this.subjectDnLabel.setText(subjectDn);
        }
        this.shell = this.getWbShell();
    }

    @Override
    protected BObject doSaveValue(BObject v, Context cx) {
        return this.cachedCert;
    }

    @Override
    public void setModified() {
        this.updateCertSelection();
        super.setModified();
    }

    private void updateCertSelection() {
        BDataFile dataFile = (BDataFile)this.fileOrd.resolve().get();
        try {
            this.cachedCert = BX509Certificate.make((String)new String(dataFile.read()));
            String subjectDn = this.cachedCert.getX509Certificate().getSubjectDN().toString();
            this.subjectDnLabel.setText(subjectDn);
            this.warningLabel.setText(this.warningText);
            this.warningLabel.setWordWrapEnabled(true, 300.0);
        }
        catch (Exception e) {
            this.subjectDnLabel.setText(String.format(lexicon.getText("clientCert.certFormat"), this.fileOrd.toString()));
        }
    }

    protected class Browse
    extends Command {
        private final TypeInfo info;

        Browse() {
            super((BWidget)BX509CertFE.this, "");
            this.info = BFileOrdChooser.TYPE.getTypeInfo();
        }

        public CommandArtifact doInvoke() {
            String trim;
            BObject base = null;
            if (BX509CertFE.this.shell != null) {
                base = BX509CertFE.this.shell.getActiveOrdTarget().get();
            }
            String location = CERT_HOME;
            if (BX509CertFE.this.field.getText() != null && (trim = BX509CertFE.this.field.getText().trim()).isEmpty()) {
                location = trim;
            }
            BOrd temp = BOrd.make((String)location);
            BIOrdChooser chooser = (BIOrdChooser)this.info.getInstance();
            BX509CertFE.this.fileOrd = chooser.openChooser(BX509CertFE.this, base, temp, BX509CertFE.this.getCurrentContext());
            if (BX509CertFE.this.fileOrd != null) {
                BX509CertFE.this.field.setText(BX509CertFE.this.fileOrd.encodeToString());
                BX509CertFE.this.setModified();
            }
            return null;
        }

        public BImage getIcon() {
            return browseIcon;
        }
    }
}

