/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.security.BPermissions;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BPermissionsEditor
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BPermissionsEditor.class);
    static final String lexOperator = UiLexicon.bajaui().getText("security.operator");
    static final String lexAdmin = UiLexicon.bajaui().getText("security.admin");
    static final String[] lexPermissions = new String[]{UiLexicon.bajaui().getText("security.r").trim(), UiLexicon.bajaui().getText("security.w").trim(), UiLexicon.bajaui().getText("security.i").trim(), UiLexicon.bajaui().getText("security.r").trim(), UiLexicon.bajaui().getText("security.w").trim(), UiLexicon.bajaui().getText("security.i").trim()};
    static final int r = 0;
    static final int w = 1;
    static final int i = 2;
    static final int R = 3;
    static final int W = 4;
    static final int I = 5;
    static BFont font = Theme.widget().getBoldText();
    static BColor selected = BColor.make((int)32768);
    static BColor implied = BColor.make((int)0x999999);
    int blockWidth = 0;
    int blockHeight = 16;
    BLabel operator;
    BLabel admin;
    BLabel oRead;
    BLabel oWrite;
    BLabel oInvoke;
    BLabel aRead;
    BLabel aWrite;
    BLabel aInvoke;
    boolean[] mode = new boolean[6];

    @Override
    public Type getType() {
        return TYPE;
    }

    public BPermissionsEditor() {
        this.operator = this.make(lexOperator);
        this.add(null, (BValue)this.operator);
        this.admin = this.make(lexAdmin);
        this.add(null, (BValue)this.admin);
        this.oRead = this.make(lexPermissions[0]);
        this.add(null, (BValue)this.oRead);
        this.oWrite = this.make(lexPermissions[1]);
        this.add(null, (BValue)this.oWrite);
        this.oInvoke = this.make(lexPermissions[2]);
        this.add(null, (BValue)this.oInvoke);
        this.aRead = this.make(lexPermissions[3]);
        this.add(null, (BValue)this.aRead);
        this.aWrite = this.make(lexPermissions[4]);
        this.add(null, (BValue)this.aWrite);
        this.aInvoke = this.make(lexPermissions[5]);
        this.add(null, (BValue)this.aInvoke);
    }

    private BLabel make(String text) {
        return new BLabel(text, font);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        BPermissions p = (BPermissions)value;
        this.mode[0] = p.hasOperatorRead();
        this.mode[1] = p.hasOperatorWrite();
        this.mode[2] = p.hasOperatorInvoke();
        this.mode[3] = p.hasAdminRead();
        this.mode[4] = p.hasAdminWrite();
        this.mode[5] = p.hasAdminInvoke();
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String s = "";
        if (this.mode[0]) {
            s = s + "r";
        }
        if (this.mode[1]) {
            s = s + "w";
        }
        if (this.mode[2]) {
            s = s + "i";
        }
        if (this.mode[3]) {
            s = s + "R";
        }
        if (this.mode[4]) {
            s = s + "W";
        }
        if (this.mode[5]) {
            s = s + "I";
        }
        return BPermissions.make((String)s);
    }

    @Override
    public void computePreferredSize() {
        this.blockWidth = 16;
        this.blockHeight = 16;
        double tw = Math.max(font.width(lexOperator), font.width(lexAdmin)) + 20.0;
        this.blockWidth = Math.max(this.blockWidth, (int)(tw / 3.0));
        for (int i = 0; i < lexPermissions.length; ++i) {
            this.blockWidth = Math.max(this.blockWidth, (int)(font.width(lexPermissions[i]) + 10.0));
        }
        this.setPreferredSize(this.blockWidth * 6 + 4, this.blockHeight * 3);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        double ox = 2.0;
        double oy = 2.0;
        double tw = this.blockWidth + 1;
        double th = 14.0;
        this.operator.setBounds(ox, oy, (double)(this.blockWidth * 3), th);
        this.admin.setBounds(ox + (double)(this.blockWidth * 3), oy, (double)(this.blockWidth * 3), th);
        this.oRead.setBounds(ox, oy + th, tw, th);
        this.oWrite.setBounds(ox + (double)this.blockWidth, oy + th, tw, th);
        this.oInvoke.setBounds(ox + (double)(this.blockWidth * 2), oy + th, tw, th);
        this.aRead.setBounds(ox + (double)(this.blockWidth * 3), oy + th, tw, th);
        this.aWrite.setBounds(ox + (double)(this.blockWidth * 4), oy + th, tw, th);
        this.aInvoke.setBounds(ox + (double)(this.blockWidth * 5), oy + th, tw, th);
    }

    public void paint(Graphics g) {
        double ww = this.getWidth() - 1.0;
        double wh = this.getHeight() - 1.0;
        double bh = 30.0;
        g.setBrush(Theme.widget().getControlBackground());
        g.fillRect(0.0, 0.0, ww, bh);
        if (this.isReadonly()) {
            g.setBrush(Theme.widget().getControlBackground());
        } else {
            g.setBrush(Theme.widget().getWindowBackground());
        }
        g.fillRect(0.0, bh, ww, 16.0);
        g.setBrush(BColor.black);
        g.strokeLine(0.0, bh, ww, bh);
        g.strokeLine((double)(this.blockWidth * 3 + 2), 4.0, (double)(this.blockWidth * 3 + 2), bh - 3.0);
        for (int i = 1; i < 6; ++i) {
            g.strokeLine((double)(2 + i * this.blockWidth), bh, (double)(2 + i * this.blockWidth), bh + (double)this.blockHeight);
        }
        if (this.mode[4]) {
            this.paintMark(g, 4, selected);
            this.paintMark(g, 3, implied);
            this.paintMark(g, 1, implied);
            this.paintMark(g, 0, implied);
        } else if (this.mode[3]) {
            this.paintMark(g, 3, selected);
            this.paintMark(g, 0, implied);
            if (this.mode[1]) {
                this.paintMark(g, 1, selected);
            }
        } else if (this.mode[1]) {
            this.paintMark(g, 1, selected);
            this.paintMark(g, 0, implied);
        } else if (this.mode[0]) {
            this.paintMark(g, 0, selected);
        }
        if (this.mode[5]) {
            this.paintMark(g, 5, selected);
            this.paintMark(g, 2, implied);
        } else if (this.mode[2]) {
            this.paintMark(g, 2, selected);
        }
        this.paintChildren(g);
        g.setBrush(BColor.black);
        g.strokeRect(1.0, 1.0, ww - 2.0, wh - 2.0);
        g.setBrush(Theme.widget().getControlHighlight());
        g.strokeLine(0.0, wh, ww, wh);
        g.strokeLine(ww, 0.0, ww, wh);
        g.setBrush(Theme.widget().getControlShadow());
        g.strokeLine(0.0, 0.0, ww, 0.0);
        g.strokeLine(0.0, 0.0, 0.0, wh);
    }

    private void paintMark(Graphics g, int index, BColor c) {
        double dx = index * this.blockWidth + (this.blockWidth - 6) / 2;
        double dy = 35.0;
        g.setBrush(c);
        g.strokeLine(dx, dy + 4.0, dx + 2.0, dy + 6.0);
        g.strokeLine(dx + 1.0, dy + 4.0, dx + 2.0, dy + 5.0);
        g.strokeLine(dx + 1.0, dy + 3.0, dx + 3.0, dy + 5.0);
        g.strokeLine(dx + 2.0, dy + 4.0, dx + 6.0, dy);
        g.strokeLine(dx + 2.0, dy + 5.0, dx + 6.0, dy + 1.0);
        g.strokeLine(dx + 3.0, dy + 5.0, dx + 7.0, dy + 1.0);
    }

    public void mousePressed(BMouseEvent event) {
        if (this.isReadonly()) {
            return;
        }
        double mx = event.getX();
        double my = event.getY();
        if (my >= 30.0 && my <= 46.0 && mx >= 2.0 && my <= 98.0) {
            int index = (int)((mx - 4.0) / (double)this.blockWidth);
            if (index == 4) {
                this.mode[4] = !this.mode[4];
                this.mode[3] = false;
                this.mode[1] = false;
                this.mode[0] = false;
                this.setModified();
            } else if (index == 3 && !this.mode[4]) {
                this.mode[3] = !this.mode[3];
                this.mode[0] = false;
                this.setModified();
            } else if (index == 1 && !this.mode[4]) {
                this.mode[1] = !this.mode[1];
                this.mode[0] = false;
                this.setModified();
            } else if (!(index != 0 || this.mode[4] || this.mode[3] || this.mode[1])) {
                this.mode[0] = !this.mode[0];
                this.setModified();
            } else if (index == 5) {
                this.mode[5] = !this.mode[5];
                this.mode[2] = false;
                this.setModified();
            } else if (index == 2 && !this.mode[5]) {
                this.mode[2] = !this.mode[2];
                this.setModified();
            }
            this.repaint();
        }
    }
}

