/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.ui.theme.Theme;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Locale;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BFontFE
extends BWbFieldEditor {
    public static final Action updateFont = BFontFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BFontFE.class);
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(Locale.ENGLISH);
    private static int[] fontSizes = new int[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72};
    private BCheckBox isNull = new BCheckBox((ToggleCommand)new Null());
    private BListDropDown name = new BListDropDown();
    private BTextDropDown size = new BTextDropDown(4, true);
    private BCheckBox bold = new BCheckBox(BFontFE.text("bold"));
    private BCheckBox italic = new BCheckBox(BFontFE.text("italic"));
    private BCheckBox underline = new BCheckBox(BFontFE.text("underline"));
    private BLabel sample = new BLabel("AaBbYyZz", BFont.make((String)"SansSerif", (double)20.0));
    private boolean frozen = false;

    public void updateFont() {
        this.invoke(updateFont, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BFontFE() {
        int i;
        this.sample.computePreferredSize();
        BConstrainedPane consSample = new BConstrainedPane((BWidget)this.sample);
        consSample.setMinWidth((double)((int)this.sample.getPreferredWidth()));
        consSample.setMinHeight((double)((int)this.sample.getPreferredHeight()));
        consSample.setMaxWidth((double)((int)this.sample.getPreferredWidth()));
        consSample.setMaxHeight((double)((int)this.sample.getPreferredHeight()));
        BBorderPane border1 = new BBorderPane((BWidget)consSample, BBorder.make((int)6), BInsets.make((double)5.0));
        for (i = 0; i < fontNames.length; ++i) {
            String fontFamilyLocale;
            String menuEntry = fontNames[i];
            Font f = Font.decode(fontNames[i] + " plain");
            if (f != null && (fontFamilyLocale = f.getFamily(Locale.forLanguageTag(Sys.getLanguage()))) != null && !menuEntry.equals(fontFamilyLocale)) {
                menuEntry = fontFamilyLocale;
            }
            this.name.getList().addItem((Object)menuEntry);
        }
        for (i = 0; i < fontSizes.length; ++i) {
            this.size.getList().addItem((Object)Integer.toString(fontSizes[i]));
        }
        this.name.computePreferredSize();
        this.size.computePreferredSize();
        BConstrainedPane consName = new BConstrainedPane((BWidget)this.name);
        BConstrainedPane consSize = new BConstrainedPane((BWidget)this.size);
        consName.setMinWidth((double)((int)this.name.getPreferredWidth()));
        consSize.setMinWidth((double)((int)this.size.getPreferredWidth()));
        BGridPane box1 = new BGridPane(2);
        box1.add(null, (BValue)consName);
        box1.add(null, (BValue)consSize);
        BGridPane box2 = new BGridPane(4);
        box2.add(null, (BValue)new BBorderPane((BWidget)this.bold, 0.0, 5.0, 0.0, 5.0));
        box2.add(null, (BValue)this.italic);
        box2.add(null, (BValue)this.underline);
        box2.add(null, (BValue)this.isNull);
        BGridPane box3 = new BGridPane(1);
        box3.add(null, (BValue)box1);
        box3.add(null, (BValue)box2);
        BGridPane box4 = new BGridPane(2);
        box4.add(null, (BValue)box3);
        box4.add(null, (BValue)border1);
        this.setContent((BWidget)box4);
        this.addUpdateFontLinks();
        this.linkTo((BComponent)this.name, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo((BComponent)this.size, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo((BComponent)this.name, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo((BComponent)this.size, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo((BComponent)this.bold, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo((BComponent)this.italic, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo((BComponent)this.underline, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        this.linkTo((BComponent)this.isNull, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
    }

    private void addUpdateFontLinks() {
        this.linkTo("lnkNameA", (BComponent)this.name, (Slot)BListDropDown.actionPerformed, (Slot)updateFont);
        this.linkTo("lnkSizeA", (BComponent)this.size, (Slot)BListDropDown.actionPerformed, (Slot)updateFont);
        this.linkTo("lnkNameV", (BComponent)this.name, (Slot)BListDropDown.valueModified, (Slot)updateFont);
        this.linkTo("lnkSizeV", (BComponent)this.size, (Slot)BListDropDown.valueModified, (Slot)updateFont);
        this.linkTo("lnkBold", (BComponent)this.bold, (Slot)BCheckBox.actionPerformed, (Slot)updateFont);
        this.linkTo("lnkItalic", (BComponent)this.italic, (Slot)BCheckBox.actionPerformed, (Slot)updateFont);
        this.linkTo("lnkUnderline", (BComponent)this.underline, (Slot)BCheckBox.actionPerformed, (Slot)updateFont);
        this.linkTo("lnkIsNull", (BComponent)this.isNull, (Slot)BCheckBox.actionPerformed, (Slot)updateFont);
    }

    private void removeUpdateFontLinks() {
        this.remove("lnkNameA");
        this.remove("lnkSizeA");
        this.remove("lnkNameV");
        this.remove("lnkSizeV");
        this.remove("lnkBold");
        this.remove("lnkItalic");
        this.remove("lnkUnderline");
        this.remove("lnkIsNull");
    }

    public void doUpdateFont() {
        this.sample.setFont(this.saveFont());
        this.sample.relayout();
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.name.setDropDownEnabled(!readonly);
        this.size.setDropDownEnabled(!readonly);
        this.size.getEditor().setEditable(!readonly);
        this.bold.setEnabled(!readonly);
        this.italic.setEnabled(!readonly);
        this.underline.setEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.removeUpdateFontLinks();
        this.frozen = true;
        BFont font = value instanceof BString ? (BFont)BFont.DEFAULT.decodeFromString(((BString)value).getString()) : (BFont)value;
        this.sample.setFont(font);
        this.sample.relayout();
        if (font.equals((Object)BFont.NULL)) {
            this.isNull.setSelected(true);
            this.enable(false);
            this.nullFont();
        } else {
            this.isNull.setSelected(false);
            this.enable(true);
            this.font(font);
        }
        this.frozen = false;
        this.addUpdateFontLinks();
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BFont font = this.saveFont();
        if (value instanceof BString) {
            return BString.make((String)font.encodeToString());
        }
        return font;
    }

    private BFont saveFont() {
        String fontFamilyLocale;
        Font f;
        if (this.isNull.isSelected()) {
            return BFont.NULL;
        }
        String nm = (String)this.name.getSelectedItem();
        if (nm == null) {
            nm = "null";
        }
        if ((f = Font.decode(nm + " plain")) != null && (fontFamilyLocale = f.getFamily(Locale.ENGLISH)) != null && !nm.equals(fontFamilyLocale)) {
            nm = fontFamilyLocale;
        }
        double sz = Double.parseDouble(this.size.getText());
        int style = 0;
        if (this.bold.getSelected()) {
            style |= 1;
        }
        if (this.italic.getSelected()) {
            style |= 2;
        }
        if (this.underline.getSelected()) {
            style |= 4;
        }
        return BFont.make((String)nm, (double)sz, (int)style);
    }

    private void enable(boolean flag) {
        this.name.setEnabled(flag);
        this.size.setEnabled(flag);
        this.bold.setEnabled(flag);
        this.italic.setEnabled(flag);
        this.underline.setEnabled(flag);
    }

    private void font(BFont font) {
        String fontFamilyLocale;
        String selectedFontName = font.getName();
        Font f = Font.decode(selectedFontName + " plain");
        if (f != null && (fontFamilyLocale = f.getFamily(Locale.forLanguageTag(Sys.getLanguage()))) != null && !selectedFontName.equals(fontFamilyLocale)) {
            selectedFontName = fontFamilyLocale;
        }
        this.name.setSelectedItem((Object)selectedFontName);
        this.size.setText(Double.toString(font.getSize()));
        this.bold.setSelected(font.isBold());
        this.italic.setSelected(font.isItalic());
        this.underline.setSelected(font.isUnderline());
    }

    private void nullFont() {
        this.name.getList().getSelection().deselectAll();
        this.size.setText("");
        this.bold.setSelected(false);
        this.italic.setSelected(false);
        this.underline.setSelected(false);
    }

    private static String text(String s) {
        return lex.getText("fontFE." + s);
    }

    private class Null
    extends ToggleCommand {
        private Null() {
            super((BWidget)BFontFE.this, BFontFE.text("null"));
        }

        public CommandArtifact doInvoke() {
            if (BFontFE.this.frozen) {
                return null;
            }
            BFontFE.this.removeUpdateFontLinks();
            if (this.isSelected()) {
                BFontFE.this.enable(false);
                BFontFE.this.nullFont();
            } else {
                BFontFE.this.enable(true);
                BFontFE.this.font(Theme.label().getTextFont());
            }
            BFontFE.this.doUpdateFont();
            BFontFE.this.addUpdateFontLinks();
            return null;
        }
    }
}

