/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.ui.KeyboardLayout;
import com.tridium.ui.UiEnv;
import com.tridium.workbench.util.FloatingPointHelper;
import javax.baja.gx.BBrush;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextRenderer;
import javax.baja.units.BUnit;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BFloatFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BFloatFE.class);
    private int width = 10;
    private final BTextField field = new BTextField("", this.width);
    private final BLabel postlabel = new BLabel("");
    private final BLabel prelabel = new BLabel("");
    private String range = "";
    private boolean isFloat = true;
    BBrush fg = BBrush.NULL;
    BBrush bg = BBrush.NULL;
    private FloatingPointHelper helper;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BFloatFE() {
        this.field.setRenderer((TextRenderer)new Renderer());
        this.field.setController((TextController)new Controller());
        BGridPane pane = new BGridPane(3);
        pane.add("pre", (BValue)this.prelabel);
        pane.add("field", (BValue)this.field);
        pane.add("post", (BValue)this.postlabel);
        this.setContent((BWidget)pane);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.field.setEditable(!readonly);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        BInteger widthFacet;
        this.isFloat = value instanceof BFloat;
        this.helper = FloatingPointHelper.makeFor(value, cx);
        this.width = 10;
        double v = ((BNumber)value).getDouble();
        if (cx != null && (widthFacet = (BInteger)cx.getFacet("fieldWidth")) != null) {
            this.width = widthFacet.getInt();
        }
        if (this.width != 10) {
            this.field.setVisibleColumns(this.width);
        }
        String postmeta = "";
        String premeta = "";
        BUnit displayUnits = this.helper.getDisplayUnits();
        if (displayUnits != null) {
            if (displayUnits.getIsPrefix()) {
                premeta = displayUnits.getSymbol();
            } else {
                postmeta = displayUnits.getSymbol();
            }
        }
        this.range = this.helper.getRangeDisplay();
        if (!this.range.isEmpty()) {
            if (!postmeta.isEmpty()) {
                postmeta = postmeta + ' ';
            }
            postmeta = postmeta + this.range;
        }
        this.field.setText(this.helper.format(v));
        this.prelabel.setText(premeta);
        this.postlabel.setText(postmeta);
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        String text = this.field.getText();
        double v = this.helper.parseAndValidate(text);
        this.field.setText(this.helper.format(v));
        return this.isFloat ? BFloat.make((float)((float)v)) : BDouble.make((double)v);
    }

    public void requestFocus() {
        this.field.requestFocus();
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 306: {
                this.fg = (BBrush)a;
                this.bg = (BBrush)b;
                this.repaint();
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public static final class Controller
    extends TextController {
        private static final BOrd defNumberpad = BOrd.make((String)"module://bajaui/com/tridium/ui/numberpad.xml");
        private static KeyboardLayout numberpad;

        public void mouseReleased(BMouseEvent event) {
            BTextEditor editor = this.getEditor();
            if (!UiEnv.get().hasKeyboard() && editor.isEditable()) {
                UiEnv.get().input(editor, numberpad);
            }
        }

        static {
            String lang = Sys.getLanguage();
            try {
                numberpad = "en".equals(lang) ? KeyboardLayout.make((BOrd)defNumberpad) : KeyboardLayout.make((BOrd)BOrd.make((String)("file:~lexicon/" + lang + "/numberpad.xml")));
            }
            catch (Exception x) {
                try {
                    numberpad = KeyboardLayout.make();
                }
                catch (Exception xx) {
                    throw new BajaRuntimeException((Throwable)xx);
                }
            }
        }
    }

    class Renderer
    extends TextRenderer {
        Renderer() {
        }

        public BBrush getBackground() {
            if (BFloatFE.this.bg.isNull()) {
                return super.getBackground();
            }
            return BFloatFE.this.bg;
        }

        public BBrush getForeground(Segment seg) {
            if (BFloatFE.this.fg.isNull()) {
                return super.getForeground(seg);
            }
            return BFloatFE.this.fg;
        }
    }
}

