/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.export.provider;

import com.tridium.export.BITransformOperationProvider;
import com.tridium.export.impl.provider.BOrdTargetTransformOperation;
import com.tridium.export.ui.impl.provider.BBindingAwareExporterTransformer;
import com.tridium.sys.registry.NAgentList;
import com.tridium.util.PxUtil;
import com.tridium.workbench.export.WorkbenchExportContext;
import com.tridium.workbench.web.browser.BWebWidget;
import java.util.ArrayList;
import java.util.List;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.collection.BITable;
import javax.baja.export.BITransformOperation;
import javax.baja.file.BExporter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.transform.BITransformer;
import javax.baja.ui.BWidget;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.px.BWbPxView;
import javax.baja.workbench.view.BIExportableTableView;
import javax.baja.workbench.view.BIWbViewExporter;
import javax.baja.workbench.view.BWbView;

@NiagaraType
@NiagaraSingleton
public class BWbViewTransformOperationProvider
extends BSingleton
implements BITransformOperationProvider<OrdTarget, WorkbenchExportContext> {
    public static final BWbViewTransformOperationProvider INSTANCE = new BWbViewTransformOperationProvider();
    public static final Type TYPE = Sys.loadType(BWbViewTransformOperationProvider.class);
    private static final AgentFilter IS_EXPORTER = AgentFilter.is((Type)BExporter.TYPE);
    private static final AgentFilter IS_VIEW_EXPORTER = AgentFilter.is((Type)BIWbViewExporter.TYPE);

    public Type getType() {
        return TYPE;
    }

    private BWbViewTransformOperationProvider() {
    }

    public List<BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext>> getTransformOperations(OrdTarget target, WorkbenchExportContext cx) {
        ArrayList<BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext>> acc = new ArrayList<BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext>>();
        BWbProfile profile = cx.getProfile();
        BWbView view = cx.getView();
        if (view != null) {
            BWbViewTransformOperationProvider.findViewExporters(acc, view, profile);
        }
        if (view instanceof BWbPxView) {
            BWbViewTransformOperationProvider.findPxViewExporters(acc, view, target, profile);
        }
        if (view instanceof BIExportableTableView) {
            BWbViewTransformOperationProvider.findTableViewExporters(acc, (BIExportableTableView)((Object)view), profile);
        }
        if (target != null) {
            BWbViewTransformOperationProvider.findOrdTargetExporters(acc, target, profile);
        }
        return acc;
    }

    private static void findViewExporters(List<BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext>> acc, BWbView view, BWbProfile profile) {
        BOrd ord = BOrd.make((String)("view:" + view.getType()));
        OrdTarget target = ord.resolve((BObject)view);
        AgentList viewExporters = BWbViewTransformOperationProvider.getViewExporters(profile, (BObject)view);
        BWbViewTransformOperationProvider.addExporters(acc, viewExporters, target);
        if (view instanceof BWebWidget) {
            ((BWebWidget)view).getTypeInfoFromJs().ifPresent(typeInfo -> {
                AgentList wwList = BWbViewTransformOperationProvider.getViewExporters(profile, typeInfo.getInstance());
                BWbViewTransformOperationProvider.addExporters(acc, wwList, target);
            });
        }
    }

    private static void findPxViewExporters(List<BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext>> acc, BWbView view, OrdTarget target, BWbProfile profile) {
        BAbstractPxView pxView = ((BWbPxView)view).getPxAgent();
        AgentList exporters = BWbViewTransformOperationProvider.getExporters(profile, target.get());
        NAgentList remove = new NAgentList();
        for (int i = 0; i < exporters.size(); ++i) {
            String b;
            String a;
            AgentInfo info = exporters.get(i);
            if (info instanceof PxUtil.PxAgent && (a = pxView.getAgentId()).equals(b = ((PxUtil.PxAgent)info).getPxView().getAgentId())) continue;
            remove.add(info);
        }
        exporters.remove((AgentList)remove);
        BWbViewTransformOperationProvider.addExporters(acc, exporters, target);
        BWbViewTransformOperationProvider.findEmbeddedViews(acc, view, profile);
    }

    private static void findEmbeddedViews(List<BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext>> acc, BWidget widget, BWbProfile profile) {
        for (BWidget child : widget.getChildWidgets()) {
            if (child instanceof BWbView) {
                BWbViewTransformOperationProvider.findViewExporters(acc, (BWbView)child, profile);
                continue;
            }
            BWbViewTransformOperationProvider.findEmbeddedViews(acc, child, profile);
        }
    }

    private static void findTableViewExporters(List<BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext>> acc, BIExportableTableView view, BWbProfile profile) {
        BITable table = view.getExportTable().getModel().export();
        OrdTarget target = BOrd.make((String)"view:?dummy=dummy").resolve((BObject)table, (Context)table.getTableFacets());
        BWbViewTransformOperationProvider.findOrdTargetExporters(acc, target, profile);
    }

    private static void findOrdTargetExporters(List<BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext>> acc, OrdTarget target, BWbProfile profile) {
        AgentList exporters = BWbViewTransformOperationProvider.getExporters(profile, target.get());
        exporters = BWbViewTransformOperationProvider.pruneViewExporters(exporters);
        BWbViewTransformOperationProvider.addExporters(acc, exporters, target);
    }

    private static void addExporters(List<BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext>> acc, AgentList agents, OrdTarget target) {
        for (int i = 0; i < agents.size(); ++i) {
            acc.add((BITransformOperation<? super OrdTarget, ? super WorkbenchExportContext>)new BOrdTargetTransformOperation((BITransformer)new BBindingAwareExporterTransformer(agents.get(i), target), target));
        }
    }

    private static AgentList pruneViewExporters(AgentList list) {
        NAgentList removeList = new NAgentList();
        block0: for (int i = 0; i < list.size(); ++i) {
            TypeInfo[] interfaces;
            AgentInfo info = list.get(i);
            if (info instanceof PxUtil.PxAgent) {
                removeList.add(info);
                continue;
            }
            for (TypeInfo iface : interfaces = info.getAgentType().getInterfaces()) {
                if (!iface.is(BIWbViewExporter.TYPE)) continue;
                removeList.add(info);
                continue block0;
            }
        }
        list.remove((AgentList)removeList);
        return list;
    }

    private static AgentList getExporters(BWbProfile profile, BObject obj) {
        return profile.getAgents(obj).filter(IS_EXPORTER);
    }

    private static AgentList getViewExporters(BWbProfile profile, BObject obj) {
        return profile.getAgents(obj).filter(IS_VIEW_EXPORTER);
    }
}

