/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.export.destination;

import com.tridium.workbench.export.WorkbenchExportContext;
import com.tridium.workbench.shell.BNiagaraWbWebShell;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.baja.export.BIExportDestinationType;
import javax.baja.export.BITransformOperation;
import javax.baja.export.ExportException;
import javax.baja.file.BFileSystem;
import javax.baja.file.BajaFileUtil;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.LexiconModule;
import javax.baja.workbench.BWbShell;

@NiagaraType
@NiagaraSingleton
public final class BViewInWorkbenchDestinationType
extends BSingleton
implements BIExportDestinationType<WorkbenchExportContext> {
    public static final BViewInWorkbenchDestinationType INSTANCE = new BViewInWorkbenchDestinationType();
    public static final Type TYPE = Sys.loadType(BViewInWorkbenchDestinationType.class);
    private static final LexiconModule LEX = LexiconModule.make((String)"bajaui");

    public Type getType() {
        return TYPE;
    }

    private BViewInWorkbenchDestinationType() {
    }

    public void checkValid(WorkbenchExportContext cx) throws ExportException {
        if (Sys.getStation() != null) {
            throw new ExportException("Only valid in Workbench");
        }
        if (BViewInWorkbenchDestinationType.isAppletEnvironment(cx)) {
            throw new ExportException("Not valid in applet environment");
        }
    }

    private static boolean isAppletEnvironment(WorkbenchExportContext cx) {
        BWbShell wbShell = BWbShell.getWbShell(cx.getOwnerDetails().getOwner());
        return wbShell instanceof BNiagaraWbWebShell;
    }

    public String getDisplayName(Context cx) {
        return LEX.get("exporter.action.viewInternal.label", cx);
    }

    public <T, X extends WorkbenchExportContext> void transform(BITransformOperation<T, ? super X> transformOperation, X cx) throws IOException, ExportException {
        String fileExtension = BViewInWorkbenchDestinationType.getFileExtension(cx);
        BWidget owner = cx.getOwnerDetails().getOwner();
        try (InputStream data = transformOperation.doTransform(cx);){
            File file = BViewInWorkbenchDestinationType.writeToTempFile(data, fileExtension);
            BViewInWorkbenchDestinationType.hyperlinkToFile(file, owner);
        }
    }

    private static String getFileExtension(Context cx) throws ExportException {
        BObject fileOrd = cx.getFacet("fileExtension");
        if (fileOrd == null) {
            throw new ExportException("fileExtension facet required");
        }
        return fileOrd.toString();
    }

    private static File writeToTempFile(InputStream in, String fileExtension) throws IOException {
        File file = BajaFileUtil.createTempFile((String)fileExtension);
        Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return file;
    }

    private static void hyperlinkToFile(File file, BWidget owner) {
        BOrd ord = BFileSystem.INSTANCE.localFileToOrd(file);
        BWbShell.getWbShell(owner).hyperlink(ord);
    }
}

