/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.console;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.console.BConsole;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextField;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.text.Position;

public class BConsoleEntry
extends BTextField {
    public static final Type TYPE = Sys.loadType(BConsoleEntry.class);
    BConsole console;
    BInsets insets = BInsets.make((double)3.0, (double)3.0, (double)3.0, (double)3.0);

    public Type getType() {
        return TYPE;
    }

    public BConsoleEntry() {
        throw new IllegalStateException();
    }

    public BConsoleEntry(BConsole console) {
        this.console = console;
    }

    public void setCommand(String cmd) {
        this.setText(cmd);
        this.moveCaretPosition(new Position(0, cmd.length()));
    }

    public BInsets getInsets() {
        return this.insets;
    }

    public void paint(Graphics g) {
        if (!this.console.nsh.inExec()) {
            super.paint(g);
            return;
        }
        g.setBrush(Theme.textEditor().getWindowBackground((IStylable)this));
        g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        g.setBrush(BColor.red);
        g.setFont(Theme.textEditor().getFont());
        g.drawString("Running command...", 3.0, 14.0);
    }

    public String getStyleSelector() {
        return "console";
    }

    protected void paintBorder(Graphics g) {
    }

    public void keyPressed(BKeyEvent event) {
        if (this.console.nsh.inExec()) {
            if (event.getKeyCode() == 27) {
                this.console.kill();
            }
            return;
        }
        this.console.scrollToEnd();
        if (event.getKeyCode() == 10) {
            this.console.exec(this.getText());
        } else if (event.getKeyCode() == 38) {
            event.consume();
            this.console.prevCommand();
        } else if (event.getKeyCode() == 40) {
            event.consume();
            this.console.nextCommand();
        } else {
            super.keyPressed(event);
        }
    }
}

