/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.cellmini;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.cellmini.BMiniTextField;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.text.TextRenderer;
import javax.baja.workbench.celleditor.BWbCellEditor;

public class BMiniTextDropDown
extends BTextDropDown {
    public static final Type TYPE = Sys.loadType(BMiniTextDropDown.class);
    private BMiniTextField editor;
    private RectGeom buttonBounds = new RectGeom();

    public Type getType() {
        return TYPE;
    }

    public BMiniTextDropDown() {
        super((BTextField)new BMiniTextField(), new BList());
        this.editor = (BMiniTextField)this.getDisplayWidget();
        this.editor.setRenderer(new TextRenderer(){

            public void paintBackground(Graphics g) {
            }
        });
    }

    public void computePreferredSize() {
        this.editor.computePreferredSize();
        double pw = this.editor.getPreferredWidth();
        double ph = this.getList().getRenderer().getItemHeight();
        if (this.getDropDownEnabled()) {
            pw += ph;
        }
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        double ph = Math.min(h, this.getList().getRenderer().getItemHeight());
        if (this.getDropDownEnabled()) {
            this.buttonBounds.width = ph;
            this.buttonBounds.height = h - 4.0;
            this.buttonBounds.x = w - ph - 2.0;
            this.buttonBounds.y = 1.0;
        } else {
            this.buttonBounds.x = 0.0;
            this.buttonBounds.y = 0.0;
            this.buttonBounds.width = 0.0;
            this.buttonBounds.height = 0.0;
        }
        this.editor.setBounds(2.0, 0.0, w - ph - 6.0, h - 2.0);
        if (!this.isDropDownOpen()) {
            BWidget dropDown = this.getDropDownWidget();
            dropDown.setBounds(0.0, h, 0.0, 0.0);
        }
    }

    public void paint(Graphics g) {
        this.paintChild(g, (BWidget)this.editor);
        if (this.getDropDownEnabled()) {
            Theme.dropDown().paintButton(g, (BWidget)this, this.buttonBounds, this.isDropDownOpen());
        }
    }

    public void mousePressed(BMouseEvent event) {
        BWbCellEditor ce = (BWbCellEditor)this.getParent();
        ce.cellSelected();
        if (event.isButton1Down()) {
            this.openDropDown();
        } else if (event.isButton3Down()) {
            ce.cellPopup(event);
        }
        this.repaint();
    }
}

