/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bql.filter;

import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.bql.filter.BFilterEntryFE;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.CannotSaveException;

public class BFilterSetEditor
extends BWbEditor {
    public static final Property colorRows = BFilterSetEditor.newProperty((int)0, (boolean)true, null);
    public static final Property bandColor = BFilterSetEditor.newProperty((int)0, (BValue)BColor.NULL, null);
    public static final Type TYPE = Sys.loadType(BFilterSetEditor.class);

    public boolean getColorRows() {
        return this.getBoolean(colorRows);
    }

    public void setColorRows(boolean v) {
        this.setBoolean(colorRows, v, null);
    }

    public BColor getBandColor() {
        return (BColor)this.get(bandColor);
    }

    public void setBandColor(BColor v) {
        this.set(bandColor, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doLoadValue(BObject value, Context context) throws Exception {
        BFilterSet set = (BFilterSet)value;
        this.removeAll();
        SlotCursor c = set.loadSlots().getProperties();
        while (c.next(BFilterEntry.class)) {
            BFilterEntry entry = (BFilterEntry)c.get();
            BFilterEntryFE ed = new BFilterEntryFE();
            ed.loadValue((BObject)entry, (Context)set.getSlotFacets((Slot)c.property()));
            if (ed.hasFilterEditor()) {
                this.add(c.property().getName(), (BValue)ed);
                if (Flags.isHidden((BComplex)set, (Slot)c.property())) {
                    ed.setVisible(false);
                }
            }
            this.add(null, (BValue)new BLink((BComponent)ed, (Slot)BFilterEntryFE.pluginModified, (Slot)setModified));
        }
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        SlotCursor editors = this.getProperties();
        while (editors.next(BFilterEntryFE.class)) {
            ((BFilterEntryFE)editors.get()).saveValue();
        }
        return value;
    }

    public void disableAll() {
        SlotCursor c = this.getProperties();
        while (c.next(BFilterEntryFE.class)) {
            BFilterEntryFE ed = (BFilterEntryFE)c.get();
            ed.setFilterEnabled(false);
        }
    }

    @Override
    public void computePreferredSize() {
        BFilterEntryFE entry;
        double w = 0.0;
        double h = 0.0;
        double maxEd = 0.0;
        SlotCursor editors = this.getProperties();
        while (editors.next(BFilterEntryFE.class)) {
            entry = (BFilterEntryFE)editors.get();
            if (!entry.isVisible()) continue;
            maxEd = Math.max(maxEd, entry.getPreferredEditorLocation());
        }
        editors = this.getProperties();
        while (editors.next(BFilterEntryFE.class)) {
            entry = (BFilterEntryFE)editors.get();
            if (!entry.isVisible()) continue;
            entry.setEditorLocation(maxEd);
        }
        int count = 0;
        editors = this.getProperties();
        while (editors.next(BFilterEntryFE.class)) {
            BFilterEntryFE entry2 = (BFilterEntryFE)editors.get();
            if (!entry2.isVisible()) continue;
            entry2.computePreferredSize();
            w = Math.max(w, entry2.getPreferredWidth());
            h += entry2.getPreferredHeight();
            ++count;
        }
        if (count != 0) {
            h += (double)((count - 1) * 4);
        }
        this.setPreferredSize(w + 6.0, h);
    }

    @Override
    public void doLayout(BWidget[] kids) {
        BFilterEntryFE entry;
        double maxEd = 0.0;
        SlotCursor editors = this.getProperties();
        while (editors.next(BFilterEntryFE.class)) {
            entry = (BFilterEntryFE)editors.get();
            if (!entry.isVisible()) continue;
            maxEd = Math.max(maxEd, entry.getPreferredEditorLocation());
        }
        editors = this.getProperties();
        while (editors.next(BFilterEntryFE.class)) {
            entry = (BFilterEntryFE)editors.get();
            if (!entry.isVisible()) continue;
            entry.setEditorLocation(maxEd);
        }
        double y = 0.0;
        editors = this.getProperties();
        while (editors.next(BFilterEntryFE.class)) {
            BFilterEntryFE entry2 = (BFilterEntryFE)editors.get();
            if (!entry2.isVisible()) continue;
            entry2.computePreferredSize();
            entry2.setBounds(3.0, y, entry2.getPreferredWidth(), entry2.getPreferredHeight());
            y += entry2.getPreferredHeight();
            y += 4.0;
        }
    }

    public void paint(Graphics g) {
        if (this.getColorRows()) {
            double w = this.getWidth();
            SlotCursor editors = this.getProperties();
            int count = 0;
            while (editors.next(BFilterEntryFE.class)) {
                BFilterEntryFE entry = (BFilterEntryFE)editors.get();
                if (!entry.isVisible()) continue;
                if (count % 2 == 0) {
                    BColor bandColor = this.getBandColor();
                    if (bandColor.isNull()) {
                        g.setBrush(Theme.table().getBandBrush());
                    } else {
                        g.setBrush(bandColor);
                    }
                    g.fillRect(0.0, entry.getY() - 2.0, w, entry.getHeight() + 4.0);
                }
                ++count;
            }
        }
        super.paint(g);
    }
}

