/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bql.builder;

import java.util.ArrayList;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.Lexicon;

public class BBqlQueryManager
extends BEdgePane {
    public static final Type TYPE = Sys.loadType(BBqlQueryManager.class);
    private static BModule module = Sys.getModuleForClass(BBqlQueryManager.class);
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static String lexName = lex.getText("bqlQueryBuilder.name");
    private static String lexQuery = lex.getText("bqlQueryBuilder.query");
    private static String lexRename = lex.getText("bqlQueryBuilder.rename.label");
    private ArrayList<Item> list = new ArrayList();
    private Model model;
    private Rename rename;
    private Remove remove;
    private MoveUp moveUp;
    private MoveDown moveDown;

    public Type getType() {
        return TYPE;
    }

    public static void openInDialog(BWidget owner, BOptions options) {
        BBqlQueryManager manager = new BBqlQueryManager(options.getChildComponents());
        if (1 == BDialog.open((BWidget)owner, (String)lex.getText("bqlQueryBuilder.manageQueries.label"), (Object)((Object)manager), (int)3)) {
            options.removeAll();
            for (int i = 0; i < manager.list.size(); ++i) {
                Item item = manager.list.get(i);
                BComponent c = new BComponent();
                c.add("name", (BValue)BString.make((String)item.name));
                c.add("query", (BValue)item.query);
                options.add(null, (BValue)c);
            }
            options.save();
        }
    }

    public BBqlQueryManager() {
        throw new IllegalStateException();
    }

    public BBqlQueryManager(BComponent[] blist) {
        for (int i = 0; i < blist.length; ++i) {
            String name = ((BString)blist[i].get("name")).getString();
            BOrd ord = (BOrd)blist[i].get("query");
            this.list.add(new Item(name, ord));
        }
        this.model = new Model();
        BTable table = new BTable((TableModel)this.model);
        table.setMultipleSelection(true);
        table.setSelection((TableSelection)new Selection());
        table.setController((TableController)new Controller());
        BConstrainedPane pane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        pane.setMinHeight(200.0);
        pane.setMaxHeight(400.0);
        pane.setMinWidth(450.0);
        pane.setMaxWidth(450.0);
        BGridPane buttons = new BGridPane(1);
        buttons.setValign(BValign.top);
        buttons.setColumnAlign(BHalign.fill);
        this.rename = new Rename((BWidget)this);
        buttons.add(null, (BValue)new BButton((Command)this.rename));
        this.remove = new Remove((BWidget)this);
        buttons.add(null, (BValue)new BButton((Command)this.remove));
        this.moveUp = new MoveUp((BWidget)this);
        buttons.add(null, (BValue)new BButton((Command)this.moveUp));
        this.moveDown = new MoveDown((BWidget)this);
        buttons.add(null, (BValue)new BButton((Command)this.moveDown));
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)pane);
        edge.setRight((BWidget)new BBorderPane((BWidget)buttons, 0.0, 0.0, 0.0, 5.0));
        this.setCenter((BWidget)new BBorderPane((BWidget)edge, 10.0, 10.0, 10.0, 10.0));
        table.getSelection().updateTable();
    }

    class MoveDown
    extends Command {
        public MoveDown(BWidget owner) {
            super(owner, module, "bqlQueryBuilder.moveDown");
        }

        public CommandArtifact doInvoke() {
            int[] rows = BBqlQueryManager.this.model.getSelection().getRows();
            if (rows[rows.length - 1] == BBqlQueryManager.this.list.size() - 1) {
                return null;
            }
            BBqlQueryManager.this.model.getSelection().deselectAll();
            for (int i = rows.length - 1; i >= 0; --i) {
                Object obj = BBqlQueryManager.this.list.remove(rows[i]);
                BBqlQueryManager.this.list.add(rows[i] + 1, (Item)obj);
                BBqlQueryManager.this.model.getSelection().select(rows[i] + 1);
            }
            return null;
        }
    }

    class MoveUp
    extends Command {
        public MoveUp(BWidget owner) {
            super(owner, module, "bqlQueryBuilder.moveUp");
        }

        public CommandArtifact doInvoke() {
            int[] rows = BBqlQueryManager.this.model.getSelection().getRows();
            if (rows[0] == 0) {
                return null;
            }
            BBqlQueryManager.this.model.getSelection().deselectAll();
            for (int i = 0; i < rows.length; ++i) {
                Object obj = BBqlQueryManager.this.list.remove(rows[i]);
                BBqlQueryManager.this.list.add(rows[i] - 1, (Item)obj);
                BBqlQueryManager.this.model.getSelection().select(rows[i] - 1);
            }
            return null;
        }
    }

    class Remove
    extends Command {
        public Remove(BWidget owner) {
            super(owner, module, "bqlQueryBuilder.remove");
        }

        public CommandArtifact doInvoke() {
            int[] rows = BBqlQueryManager.this.model.getSelection().getRows();
            BBqlQueryManager.this.model.getSelection().deselectAll();
            for (int i = 0; i < rows.length; ++i) {
                BBqlQueryManager.this.list.remove(rows[i] - i);
            }
            BBqlQueryManager.this.model.getTable().relayout();
            return null;
        }
    }

    class Rename
    extends Command {
        public Rename(BWidget owner) {
            super(owner, module, "bqlQueryBuilder.rename");
        }

        public CommandArtifact doInvoke() {
            int[] rows = BBqlQueryManager.this.model.getSelection().getRows();
            Item c = (Item)BBqlQueryManager.this.list.get(rows[0]);
            String s = BDialog.prompt((BWidget)this.getOwner(), (String)lexRename, (String)c.name, (int)50);
            if (s != null) {
                c.name = s;
                BBqlQueryManager.this.model.getTable().sizeColumnsToFit();
            }
            return null;
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            if (BBqlQueryManager.this.rename.isEnabled()) {
                BBqlQueryManager.this.rename.invoke();
            }
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            boolean selected = this.getRows().length > 0;
            BBqlQueryManager.this.rename.setEnabled(selected);
            BBqlQueryManager.this.remove.setEnabled(selected);
            BBqlQueryManager.this.moveUp.setEnabled(selected);
            BBqlQueryManager.this.moveDown.setEnabled(selected);
        }
    }

    class Item {
        public String name;
        public BOrd query;

        public Item(String n, BOrd q) {
            this.name = n;
            this.query = q;
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int c) {
            return c == 0 ? lexName : lexQuery;
        }

        public int getRowCount() {
            return BBqlQueryManager.this.list.size();
        }

        public Object getValueAt(int row, int col) {
            Item item = (Item)BBqlQueryManager.this.list.get(row);
            return col == 0 ? item.name : item.query.toString();
        }
    }
}

