/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bookmark;

import com.tridium.workbench.bookmark.BBookmarkMenu;
import com.tridium.workbench.bookmark.BookmarkEvents;
import com.tridium.workbench.bookmark.BookmarkUtil;
import com.tridium.workbench.fieldeditors.BOrdFE;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkItem;
import javax.baja.ui.bookmark.BBookmarkOptions;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSubject;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BBookmarkTree
extends BTree {
    public static final Type TYPE = Sys.loadType(BBookmarkTree.class);
    private static BModule module = Sys.getModuleForClass(BBookmarkTree.class);
    private static Lexicon lex = Lexicon.make((String)"workbench");

    public Type getType() {
        return TYPE;
    }

    public BBookmarkTree() {
        BBookmarkOptions op = BBookmarkOptions.make();
        this.setModel(new Model(op.getRootFolder()));
        this.setController(new Controller());
    }

    public void reload() {
        BBookmarkOptions op = BBookmarkOptions.make();
        this.setModel(new Model(op.getRootFolder()));
        this.relayout();
    }

    private class Remove
    extends Command {
        private BBookmarkItem item;

        public Remove(BWidget owner, BBookmarkItem item) {
            super(owner, module, "bookmark.remove");
            this.item = item;
        }

        public CommandArtifact doInvoke() {
            if (BDialog.confirm((BWidget)this.getOwner(), (String)lex.getText("bookmark.remove.label"), (Object)lex.getText("bookmark.removePrompt")) == 4) {
                BBookmarkTree.this.getSelection().deselectAll();
                this.item.getParent().asComponent().remove((BComplex)this.item);
                BBookmarkOptions.make().save();
                BookmarkEvents.fireBookmarkChanged();
                BBookmarkTree.this.reload();
            }
            return null;
        }
    }

    private class Edit
    extends Command {
        private BBookmarkItem item;

        public Edit(BWidget owner, BBookmarkItem item) {
            super(owner, module, "bookmark.edit");
            this.item = item;
        }

        public CommandArtifact doInvoke() {
            BBookmarkFolder f;
            String str;
            if (this.item instanceof BBookmark) {
                BBookmark b = (BBookmark)this.item;
                Object[] str2 = this.doEditBookmark(b);
                if (str2 != null) {
                    b.setText((String)str2[0]);
                    b.setBookmarkOrd((BOrd)str2[1]);
                    BBookmarkOptions.make().save();
                    BookmarkEvents.fireBookmarkChanged();
                    BBookmarkTree.this.reload();
                }
            } else if (this.item instanceof BBookmarkFolder && (str = this.doEditFolder(f = (BBookmarkFolder)this.item)) != null) {
                f.setText(str);
                BBookmarkOptions.make().save();
                BookmarkEvents.fireBookmarkChanged();
                BBookmarkTree.this.reload();
            }
            return null;
        }

        public Object[] doEditBookmark(BBookmark mark) {
            try {
                BTextField name = new BTextField(mark.getText(), 60);
                BOrdFE editor = new BOrdFE();
                editor.loadValue((BObject)mark.getBookmarkOrd(), (Context)BFacets.make((String)"ordRelativize", (BIDataValue)BBoolean.FALSE));
                BGridPane grid = new BGridPane(2);
                grid.add(null, (BValue)new BLabel(lex.getText("bookmark.name")));
                grid.add(null, (BValue)name);
                grid.add(null, (BValue)new BLabel(lex.getText("bookmark.ord")));
                grid.add(null, (BValue)editor);
                if (1 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("bookmark.edit.label"), (Object)grid, (int)3)) {
                    return new Object[]{name.getText(), editor.saveValue()};
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public String doEditFolder(BBookmarkFolder folder) {
            BTextField name = new BTextField(folder.getText(), 30);
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(lex.getText("bookmark.name")));
            grid.add(null, (BValue)name);
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("bookmark.edit.label"), (Object)grid, (int)3)) {
                return name.getText();
            }
            return null;
        }
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        protected void nodeDoubleClicked(BMouseEvent event, TreeNode target) {
            Node node = (Node)target;
            if (node.item instanceof BBookmark) {
                BBookmark b = (BBookmark)node.item;
                try {
                    BObject obj = b.getBookmarkOrd().resolve().get();
                    b.setIcon(obj.getIcon());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BookmarkUtil.open((BWbShell)this.getShell(), b, event.isControlDown());
            }
        }

        protected BMenu makePopup(TreeSubject subject) {
            Node node = (Node)subject.getActiveNode();
            Node nodeParent = null;
            if (node != null && !(node.item instanceof BBookmarkFolder)) {
                nodeParent = (Node)node.getParent();
            }
            BMenu menu = new BMenu();
            if (nodeParent == null) {
                menu.add(null, (Command)new BBookmarkMenu.Add((BWidget)this.getTree()));
            } else {
                menu.add(null, (Command)new BBookmarkMenu.Add((BWidget)this.getTree(), (BBookmarkFolder)nodeParent.item));
            }
            menu.add(null, (Command)new BBookmarkMenu.Manage((BWidget)this.getTree()));
            if (node != null) {
                menu.add(null, (BValue)new BSeparator());
                menu.add(null, (Command)new Edit((BWidget)this.getTree(), node.item));
                menu.add(null, (Command)new Remove((BWidget)this.getTree(), node.item));
            }
            return menu;
        }
    }

    class Node
    extends TreeNode {
        BBookmarkItem item;
        Node[] kids;

        public Node(TreeModel model, BBookmarkItem item) {
            super(model);
            this.item = item;
            this.load();
        }

        public Node(TreeNode parent, BBookmarkItem item) {
            super(parent);
            this.item = item;
            this.load();
        }

        public void load() {
            BBookmarkItem[] c = (BBookmarkItem[])this.item.getChildren(BBookmarkItem.class);
            this.kids = new Node[c.length];
            for (int i = 0; i < c.length; ++i) {
                this.kids[i] = new Node(this, c[i]);
            }
        }

        public Object getSubject() {
            return this.item;
        }

        public String getText() {
            return this.item.getText();
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.item.getIcon());
        }

        public int getChildCount() {
            return this.kids.length;
        }

        public TreeNode getChild(int index) {
            return this.kids[index];
        }
    }

    class Model
    extends TreeModel {
        Node[] roots;

        public Model(BBookmarkFolder rootFolder) {
            BBookmarkItem[] kids = (BBookmarkItem[])rootFolder.getChildren(BBookmarkItem.class);
            this.roots = new Node[kids.length];
            for (int i = 0; i < kids.length; ++i) {
                this.roots[i] = new Node(this, kids[i]);
            }
        }

        public int getRootCount() {
            return this.roots.length;
        }

        public TreeNode getRoot(int index) {
            return this.roots[index];
        }
    }
}

