/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bookmark;

import com.tridium.workbench.bookmark.BBookmarkManager;
import com.tridium.workbench.bookmark.BFolderSubMenuItem;
import com.tridium.workbench.bookmark.BookmarkEvents;
import com.tridium.workbench.bookmark.BookmarkSpy;
import com.tridium.workbench.bookmark.BookmarkUtil;
import com.tridium.workbench.shell.BViewTab;
import javax.baja.gx.BImage;
import javax.baja.nre.util.Array;
import javax.baja.spy.Spy;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.bookmark.BBookmark;
import javax.baja.ui.bookmark.BBookmarkFolder;
import javax.baja.ui.bookmark.BBookmarkOptions;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BBookmarkMenu
extends BMenu {
    public static final Type TYPE = Sys.loadType(BBookmarkMenu.class);

    public Type getType() {
        return TYPE;
    }

    public BBookmarkMenu(String text) {
        super(text);
    }

    public BBookmarkMenu() {
        super(Lexicon.make((String)"workbench").getText("menu.bookmark.label"));
    }

    public void update() {
        this.buildMenu();
    }

    public boolean isDynamic() {
        return true;
    }

    private void buildMenu() {
        this.removeAll();
        BWidget parent = this.getParentWidget();
        BViewTab[] tabs = BookmarkUtil.tabs((BWbShell)parent.getShell());
        AddAll addAll = new AddAll(parent, tabs);
        addAll.setEnabled(tabs.length > 1);
        Add add = new Add(parent);
        add.setEnabled(((BWbShell)parent.getShell()).getActiveOrdTarget() != null);
        this.add(null, add);
        this.add(null, addAll);
        this.add(null, new Manage(parent));
        this.add(null, (BValue)new BSeparator());
        BBookmarkOptions options = BBookmarkOptions.make();
        BBookmarkFolder folder = options.getRootFolder();
        BComponent[] kids = folder.getChildComponents();
        for (int i = 0; i < kids.length; ++i) {
            if (kids[i] instanceof BBookmarkFolder) {
                this.addSubMenu(this, (BBookmarkFolder)kids[i]);
                continue;
            }
            if (!(kids[i] instanceof BBookmark)) continue;
            this.add(null, new Open(parent, (BBookmark)kids[i]));
        }
    }

    private void addSubMenu(BMenu menu, BBookmarkFolder folder) {
        BMenu sub = new BMenu();
        BComponent[] kids = folder.getChildComponents();
        int numBookmarks = 0;
        for (int i = 0; i < kids.length; ++i) {
            if (kids[i] instanceof BBookmarkFolder) {
                this.addSubMenu(sub, (BBookmarkFolder)kids[i]);
                continue;
            }
            if (!(kids[i] instanceof BBookmark)) continue;
            ++numBookmarks;
            sub.add(null, (Command)new Open(this.getParentWidget(), (BBookmark)kids[i]));
        }
        if (numBookmarks > 1) {
            sub.reorderToTop(sub.add(null, (BValue)new BSeparator()));
            sub.reorderToTop(sub.add(null, (Command)new OpenInTabs(this.getParentWidget(), sub.getMenuItems())).getPropertyInParent());
        }
        BFolderSubMenuItem subItem = new BFolderSubMenuItem(folder.getText(), sub);
        subItem.setImage(BImage.make((BIcon)folder.getIcon()));
        menu.add(null, (BValue)subItem);
    }

    private boolean isNewTabOpen(CommandEvent event) {
        BInputEvent inputEvent = event.getInputEvent();
        return event.isControlDown() || inputEvent instanceof BMouseEvent && ((BMouseEvent)inputEvent).isButton2Down();
    }

    static {
        Spy.ROOT.add("bookmarks", (Spy)new BookmarkSpy());
    }

    class OpenInTabs
    extends Command {
        BMenuItem[] items;

        public OpenInTabs(BWidget owner, BMenuItem[] items) {
            super(owner, TYPE.getModule(), "bookmark.openAll");
            this.items = items;
        }

        public CommandArtifact doInvoke(CommandEvent event) throws Exception {
            boolean doneOneOpen = false;
            for (int i = 0; i < this.items.length; ++i) {
                if (!(this.items[i].getCommand() instanceof Open)) continue;
                Open open = (Open)this.items[i].getCommand();
                if (!doneOneOpen) {
                    doneOneOpen = true;
                    open.invoke(event);
                    continue;
                }
                try {
                    BObject obj = open.mark.getBookmarkOrd().resolve().get();
                    open.mark.setIcon(obj.getIcon());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BookmarkUtil.open((BWbShell)this.getShell(), open.mark, true);
            }
            return null;
        }
    }

    class Open
    extends Command {
        BBookmark mark;

        public Open(BWidget owner, BBookmark mark) {
            super(owner, mark.getText());
            this.mark = mark;
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.mark.getIcon());
        }

        public CommandArtifact doInvoke(CommandEvent event) {
            try {
                BObject obj = this.mark.getBookmarkOrd().resolve().get();
                this.mark.setIcon(obj.getIcon());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (BBookmarkMenu.this.isNewTabOpen(event)) {
                BookmarkUtil.open((BWbShell)this.getShell(), this.mark, true);
            } else {
                BookmarkUtil.open((BWbShell)this.getShell(), this.mark);
            }
            return null;
        }
    }

    public static class Manage
    extends Command {
        public Manage(BWidget owner) {
            super(owner, TYPE.getModule(), "bookmark.manage");
        }

        public CommandArtifact doInvoke() {
            BBookmarkManager.open(this.getOwner());
            return null;
        }
    }

    public static class Add
    extends Command {
        private BBookmarkFolder folder;

        public Add(BWidget owner) {
            super(owner, TYPE.getModule(), "bookmark.add");
        }

        public Add(BWidget owner, BBookmarkFolder folder) {
            super(owner, TYPE.getModule(), "bookmark.add");
            this.folder = folder;
        }

        public CommandArtifact doInvoke() {
            try {
                BBookmark bookmark = BookmarkUtil.makeForCurrentContext((BWbShell)this.getShell());
                BBookmarkOptions options = BBookmarkOptions.make();
                if (this.folder == null) {
                    BookmarkUtil.add(this.getOwner(), options.getRootFolder(), bookmark);
                } else {
                    BookmarkUtil.add(this.getOwner(), options.getRootFolder(), this.folder, bookmark);
                }
                options.save();
                BookmarkEvents.fireBookmarkChanged();
            }
            catch (Exception e) {
                BDialog.error((BWidget)this.getOwner(), (String)"Error", (Object)"Add failed", (Throwable)e);
            }
            return null;
        }
    }

    public static class AddAll
    extends Command {
        private BViewTab[] tabs;

        public AddAll(BWidget owner, BViewTab[] tabs) {
            super(owner, TYPE.getModule(), "bookmark.addAll");
            this.tabs = tabs;
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                Array bookmarksArray = new Array(BBookmark.class);
                for (int i = 0; i < this.tabs.length; ++i) {
                    if (this.tabs[i].getTarget() == null) continue;
                    bookmarksArray.add((Object)BookmarkUtil.makeForTab(this.tabs[i]));
                }
                BBookmark[] bookmarks = (BBookmark[])bookmarksArray.trim();
                BBookmarkOptions options = BBookmarkOptions.make();
                BookmarkUtil.add(this.getOwner(), options.getRootFolder(), bookmarks);
                options.save();
                BookmarkEvents.fireBookmarkChanged();
            }
            catch (Exception e) {
                BDialog.error((BWidget)this.getOwner(), (String)"Error", (Object)"Add failed", (Throwable)e);
            }
            return null;
        }
    }
}

