/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.security.AuthenticationRealm;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.workbench.authn.BCredInputPane;

public class BWbLoginPane
extends BEdgePane {
    public static final Type TYPE = Sys.loadType(BWbLoginPane.class);
    static final BImage icon = BImage.make((String)"module://icons/x32/keys.png");
    private BCredInputPane credInputPane;

    public Type getType() {
        return TYPE;
    }

    public BWbLoginPane(AuthenticationRealm realm, BCredInputPane inputPane, boolean showError) {
        this(realm, inputPane, showError, null);
    }

    public BWbLoginPane(AuthenticationRealm realm, BCredInputPane inputPane, boolean showError, String errorMessage) {
        UiLexicon lex = UiLexicon.bajaui();
        String lexTitle = lex.getText("auth.title");
        String lexDesc = lex.getText("auth.description");
        String lexRealm = lex.getText("auth.realm");
        String lexRealmName = lex.getText("auth.realmName");
        String lexScheme = lex.getText("auth.scheme");
        String lexCred = lex.getText("auth.credentials");
        BFont bold = Theme.widget().getBoldText();
        BGridPane sessionSummary = new BGridPane(2);
        sessionSummary.setHalign(BHalign.left);
        sessionSummary.setColumnGap(20.0);
        sessionSummary.add(null, (BValue)new BLabel(lexRealmName));
        sessionSummary.add(null, (BValue)new BLabel(realm.getAuthenticationRealmName()));
        sessionSummary.add(null, (BValue)new BLabel(lexScheme));
        String schemeName = realm.getAuthenticationScheme();
        if (schemeName == null) {
            schemeName = "Unknown";
        }
        sessionSummary.add(null, (BValue)new BLabel(schemeName));
        BBorderPane sessionBorder = new BBorderPane((BWidget)sessionSummary);
        sessionBorder.setBorder(BBorder.none);
        sessionBorder.setMargin(BInsets.NULL);
        sessionBorder.setPadding(BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)10.0));
        BGridPane session = new BGridPane(1);
        session.add(null, (BValue)new BLabel(lexRealm, bold));
        session.add(null, (BValue)sessionBorder);
        this.credInputPane = inputPane;
        BGridPane credentialInputPane = new BGridPane(1);
        credentialInputPane.setHalign(BHalign.left);
        credentialInputPane.add(null, (BValue)new BLabel(lexCred, bold));
        credentialInputPane.add(null, (BValue)new BBorderPane((BWidget)this.credInputPane, 0.0, 0.0, 0.0, 10.0));
        BGridPane content = new BGridPane(1);
        content.setHalign(BHalign.left);
        content.setRowGap(10.0);
        content.add(null, (BValue)session);
        content.add(null, (BValue)credentialInputPane);
        this.setCenter((BWidget)new BBorderPane((BWidget)content, 5.0, 5.0, 5.0, 5.0));
        this.setTop((BWidget)new BWizardHeader(icon, lexTitle, lexDesc));
        if (showError) {
            if (errorMessage == null) {
                errorMessage = lex.getText("loginFailed");
            }
            BLabel errLabel = new BLabel(icon, errorMessage);
            errLabel.setHalign(BHalign.left);
            errLabel.setFont(bold);
            errLabel.setWordWrapEnabled(true, 200.0);
            BBorderPane err = new BBorderPane((BWidget)errLabel);
            err.setFill(BColor.make((int)0xFFEEEE).toBrush());
            err.setBorder(BBorder.make((double)1.0, (int)1, (BBrush)BColor.make((int)0x800000).toBrush()));
            err.computePreferredSize();
            this.setTop((BWidget)err);
        } else {
            this.setTop((BWidget)new BWizardHeader(icon, lexTitle, lexDesc));
        }
    }

    public BCredInputPane getCredInputPane() {
        return this.credInputPane;
    }
}

