/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameCredential;
import javax.baja.security.BUsernameSchemeCredentials;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.authn.BCredInputPane;

@NiagaraSlots
public class BUsernameInputPane
extends BCredInputPane {
    public static final Type TYPE = Sys.loadType(BUsernameInputPane.class);
    protected BCheckBox saveCredBox;
    private BTextField usernameEditor = new BTextField();
    private BListDropDown schemeDropDown;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BUsernameInputPane(AuthenticationRealm realm) {
        UiLexicon lex = UiLexicon.bajaui();
        BGridPane credPane = new BGridPane(2);
        credPane.setHalign(BHalign.left);
        credPane.setColumnGap(20.0);
        credPane.add(null, (BValue)new BLabel(lex.getText("auth.username")));
        credPane.add(null, (BValue)this.usernameEditor);
        String[] availableSchemes = realm.getAvailableAuthenticationSchemes();
        if (availableSchemes != null) {
            this.schemeDropDown = new BListDropDown();
            BList schemeList = this.schemeDropDown.getList();
            for (String scheme : availableSchemes) {
                schemeList.addItem((Object)scheme);
            }
            schemeList.setSelectedItem((Object)realm.getDefaultAuthenticationScheme());
            credPane.add(null, (BValue)new BLabel(lex.getText("auth.scheme")));
            credPane.add(null, (BValue)this.schemeDropDown);
        }
        this.add(null, (BValue)credPane);
        this.saveCredBox = new BCheckBox(lex.getText("auth.saveUser"), true);
        this.add(null, (BValue)this.saveCredBox);
    }

    @Override
    protected BICredentials doGetCredentials() throws Exception {
        String username = this.usernameEditor.getText();
        String selectedScheme = this.getSelectedScheme();
        if (selectedScheme != null) {
            return new BUsernameSchemeCredentials(username, selectedScheme);
        }
        return new BUsernameCredential(username);
    }

    @Override
    protected void doCleanCredentials() {
        this.usernameEditor.setText("");
        this.usernameEditor = null;
        if (this.schemeDropDown != null) {
            this.schemeDropDown.setSelectedIndex(-1);
            this.schemeDropDown = null;
        }
    }

    @Override
    public boolean shouldSaveCredentials() {
        return this.saveCredBox.isSelected();
    }

    @Override
    public boolean shouldDeleteCredentials() {
        return !this.saveCredBox.isSelected();
    }

    private String getSelectedScheme() {
        if (this.schemeDropDown != null) {
            return (String)this.schemeDropDown.getSelectedItem();
        }
        return null;
    }
}

