/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.shell.BGeneralOptions;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.authn.BCredInputPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraSlots
public class BSaveCredInputPane
extends BCredInputPane {
    public static final Type TYPE = Sys.loadType(BSaveCredInputPane.class);
    protected BCheckBox saveCredBox;
    protected BWbFieldEditor editor;

    @Override
    public Type getType() {
        return TYPE;
    }

    protected BSaveCredInputPane() {
        this((BICredentials)new BUsernameAndPassword(), null, "");
    }

    public BSaveCredInputPane(BICredentials credentials, AuthenticationRealm realm, String realmPrefix) {
        this.editor = BWbFieldEditor.makeFor(credentials.asObject());
        this.editor.loadValue(credentials.asObject());
        this.add(null, (BValue)this.editor);
        UiLexicon lex = UiLexicon.bajaui();
        String lexSaveCred = lex.getText("auth.saveCredentials");
        BGeneralOptions gopt = BGeneralOptions.make();
        boolean allowCaching = gopt.getAllowUserCredentialCaching();
        this.saveCredBox = new BCheckBox(lexSaveCred, allowCaching && AuthUtil.hasSavedCredentials(realmPrefix + realm.getAuthenticationRealmName()));
        this.saveCredBox.setEnabled(allowCaching);
        this.add(null, (BValue)this.saveCredBox);
    }

    @Override
    protected BICredentials doGetCredentials() throws Exception {
        BICredentials credentials = (BICredentials)this.editor.saveValue();
        return credentials;
    }

    @Override
    protected void doCleanCredentials() {
        this.editor = null;
    }

    @Override
    public boolean shouldSaveCredentials() {
        return this.saveCredBox.isSelected();
    }

    @Override
    public boolean shouldDeleteCredentials() {
        return !this.saveCredBox.isSelected();
    }
}

