/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.auth;

import com.tridium.workbench.auth.CredentialsList;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;

public class BCredentialsManager
extends BEdgePane {
    public static final Type TYPE = Sys.loadType(BCredentialsManager.class);
    static final BImage icon = BImage.make((String)"module://icons/x16/keys.png");
    static final int COL_REALM = 0;
    static final int COL_CREDENTIALS = 1;
    static final int COL_TYPE = 2;
    final UiLexicon lex = UiLexicon.bajaui();
    final String LEX_REALM = this.lex.getText("auth.realmName");
    final String LEX_TYPE = this.lex.getText("auth.type");
    final String LEX_CREDENTIALS = this.lex.getText("auth.credentials");
    final String LEX_REMOVE = this.lex.getText("auth.credentialsManager.remove");
    final String LEX_REMOVE_ALL = this.lex.getText("auth.credentialsManager.removeAll");
    final String LEX_RESET = this.lex.getText("auth.credentialsManager.reset");
    final String LEX_OPEN = this.lex.getText("auth.credentialsManager.open");
    BWidget owner;
    CredentialsList orig;
    CredentialsList list;
    CredentialsList users;
    CredentialsList origUsers;
    BTable table;
    Row[] rows = new Row[0];
    Command remove;
    Command removeAll;
    Command reset;
    Command open;

    public Type getType() {
        return TYPE;
    }

    public BCredentialsManager() {
        throw new IllegalStateException();
    }

    public BCredentialsManager(BWidget owner, CredentialsList list, CredentialsList users) {
        this.owner = owner;
        this.list = list;
        this.users = users;
        this.orig = new CredentialsList(list);
        this.origUsers = new CredentialsList(users);
        this.table = new BTable((TableModel)new Model(), (TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        BGridPane buttons = new BGridPane(1);
        buttons.setValign(BValign.top);
        buttons.setColumnAlign(BHalign.fill);
        this.reset = new ReflectCommand((BWidget)this, this.LEX_RESET, "cmdReset");
        buttons.add(null, (BValue)new BButton(this.reset));
        this.remove = new ReflectCommand((BWidget)this, this.LEX_REMOVE, "cmdRemove");
        buttons.add(null, (BValue)new BButton(this.remove));
        this.removeAll = new ReflectCommand((BWidget)this, this.LEX_REMOVE_ALL, "cmdRemoveAll");
        buttons.add(null, (BValue)new BButton(this.removeAll));
        this.open = new ReflectCommand((BWidget)this, this.LEX_OPEN, "cmdOpen");
        buttons.add(null, (BValue)new BButton(this.open));
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        edge.setRight((BWidget)new BBorderPane((BWidget)buttons, 0.0, 0.0, 0.0, 10.0));
        this.setCenter((BWidget)new BBorderPane((BWidget)edge));
        this.updateRows();
        this.updateCommands();
        this.table.sortByColumn(0, true);
    }

    public void computePreferredSize() {
        this.setPreferredSize(550.0, 220.0);
    }

    public void updateCommands() {
        int numSel = this.table.getSelection().getRows().length;
        this.remove.setEnabled(numSel > 0);
        this.removeAll.setEnabled(this.rows.length > 0);
        this.open.setEnabled(numSel == 1);
    }

    public void cmdRemove() {
        int[] sel = this.table.getSelection().getRows();
        for (int i = 0; i < sel.length; ++i) {
            Row row = this.rows[sel[i]];
            this.list.remove(row.realm);
            this.users.remove(row.realm);
        }
        this.updateRows();
        this.relayout();
    }

    public void cmdRemoveAll() {
        this.list.clear();
        this.users.clear();
        this.updateRows();
        this.relayout();
    }

    public void cmdReset() {
        this.list.copyFrom(this.orig);
        this.users.copyFrom(this.origUsers);
        this.updateRows();
        this.relayout();
    }

    public void cmdOpen() {
        int[] sel = this.table.getSelection().getRows();
        if (sel.length < 1) {
            return;
        }
        Row row = this.rows[sel[0]];
        BOrd ord = null;
        try {
            ord = BOrd.make((String)row.realm);
            ord.parse();
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (Object)("Realm does not map to an ord: " + row.realm));
            return;
        }
        BDialog dialog = (BDialog)this.getShell();
        dialog.close();
        BWbShell shell = (BWbShell)this.owner.getShell();
        shell.hyperlink(ord);
    }

    public void updateRows() {
        String[] spaces = this.list.keys();
        this.rows = new Row[spaces.length];
        for (int i = 0; i < spaces.length; ++i) {
            this.rows[i] = new Row(spaces[i], this.list.lookup(spaces[i]));
        }
    }

    static class Row {
        String realm;
        BICredentials credentials;
        String type;
        String summary;

        Row(String realm, BICredentials credentials) {
            try {
                this.realm = realm;
                this.credentials = credentials;
                this.type = credentials.getType().toString();
                this.summary = credentials instanceof BUsernameAndPassword ? ((BUsernameAndPassword)credentials).getUsername() : credentials.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Object getSortKey(int col) {
            switch (col) {
                case 0: {
                    return this.realm;
                }
                case 2: {
                    return this.type;
                }
                case 1: {
                    return this.summary;
                }
            }
            throw new IllegalStateException();
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BCredentialsManager.this.rows.length;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BCredentialsManager.this.LEX_REALM;
                }
                case 1: {
                    return BCredentialsManager.this.LEX_CREDENTIALS;
                }
                case 2: {
                    return BCredentialsManager.this.LEX_TYPE;
                }
            }
            return "?";
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return BCredentialsManager.this.rows[row].realm;
                }
                case 1: {
                    return BCredentialsManager.this.rows[row].summary;
                }
                case 2: {
                    return BCredentialsManager.this.rows[row].type;
                }
            }
            return "?";
        }

        public Object getSubject(int row) {
            return BCredentialsManager.this.rows[row];
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            Object[] keys = new Object[BCredentialsManager.this.rows.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = BCredentialsManager.this.rows[i].getSortKey(col);
            }
            SortUtil.sort((Object[])keys, (Object[])BCredentialsManager.this.rows, (boolean)ascending);
        }

        public BImage getRowIcon(int row) {
            return icon;
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void keyPressed(BKeyEvent event) {
            if (event.getKeyCode() == 10) {
                event.consume();
                BCredentialsManager.this.cmdOpen();
            } else if (event.getKeyCode() == 127) {
                event.consume();
                BCredentialsManager.this.cmdRemove();
            }
            super.keyPressed(event);
        }

        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
            super.cellDoubleClicked(event, row, col);
            BCredentialsManager.this.cmdOpen();
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BCredentialsManager.this.updateCommands();
        }
    }
}

