/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.program.ui.BProgramModuleBuilder;
import com.tridium.security.BPermissionGroupInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.Lexicon;

public class Permissions
extends TableModel {
    BProgramModuleBuilder builder;
    BTable table;
    private Lexicon bajaLex = null;

    Permissions(BProgramModuleBuilder builder) {
        this.builder = builder;
        this.table = new BTable((TableModel)this);
        this.table.setController((TableController)new Controller());
        builder.linkTo((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)BProgramModuleBuilder.handlePermissionSelection);
    }

    public int getRowCount() {
        return ((BPermissionGroupInfo[])this.builder.pmod.getPermissions().getChildren(BPermissionGroupInfo.class)).length;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int col) {
        if (this.bajaLex == null) {
            this.bajaLex = Lexicon.make((String)"baja");
        }
        switch (col) {
            case 0: {
                return this.bajaLex.get("permissions.type", "Type");
            }
            case 1: {
                return this.bajaLex.get("permissions.policyType", "Policy Type");
            }
            case 2: {
                return this.bajaLex.get("permissions.purpose", "Purpose");
            }
            case 3: {
                return this.bajaLex.get("permissions.params", "Parameters");
            }
            case 4: {
                return this.bajaLex.get("permissions.required", "Required");
            }
        }
        return "Error: unknown column name";
    }

    public Object getValueAt(int row, int col) {
        BPermissionGroupInfo[] permissionGroups = (BPermissionGroupInfo[])this.builder.pmod.getPermissions().getChildren(BPermissionGroupInfo.class);
        BPermissionGroupInfo permissionGroup = permissionGroups[row];
        switch (col) {
            case 0: {
                return permissionGroup.getGroupType();
            }
            case 1: {
                return permissionGroup.getPolicyType();
            }
            case 2: {
                return permissionGroup.getPurpose();
            }
            case 3: {
                return permissionGroup.getParameters();
            }
            case 4: {
                return permissionGroup.getRequired();
            }
        }
        return "Error: unknown column";
    }

    void add(BPermissionGroupInfo permissionGroup) {
        this.builder.pmod.getPermissions().add("permissionGroup?", (BValue)permissionGroup);
        this.updateTable();
    }

    BPermissionGroupInfo getSelectedPermission() {
        TableSelection selection = this.builder.permissions.table.getSelection();
        int row = selection.getRow();
        if (row >= 0) {
            return ((BPermissionGroupInfo[])this.builder.pmod.getPermissions().getChildren(BPermissionGroupInfo.class))[row];
        }
        return null;
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void cellPopup(BMouseEvent event, int row, int column) {
            this.popup(event);
        }

        public void backgroundPopup(BMouseEvent event) {
            this.popup(event);
        }

        public void popup(BMouseEvent event) {
            BMenu menu = new BMenu();
            menu.add(null, (Command)Permissions.this.builder.commands.addPermissionCommand);
            menu.add(null, (Command)Permissions.this.builder.commands.editPermissionCommand);
            menu.add(null, (Command)Permissions.this.builder.commands.removePermissionCommand);
            menu.open((BWidget)Permissions.this.table, event.getX(), event.getY());
        }
    }
}

