/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.bql.BSelect;
import com.tridium.bql.SelectQuery;
import com.tridium.bql.expression.BPath;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.program.BProgram;
import com.tridium.program.ui.Compiler;
import com.tridium.program.ui.RecompileTool;
import com.tridium.program.ui.signing.BCertificateNotSelectedDialog;
import com.tridium.program.ui.signing.BCodeSigningOptions;
import com.tridium.util.ObjectUtil;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.util.Columns;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"program:ProgramService"})})
public class BProgramRecompileTool
extends BWbView {
    public static final Type TYPE = Sys.loadType(BProgramRecompileTool.class);
    List<BProgram> programs;
    BTable table;
    BTitlePane titlePane;
    protected static Lexicon lex = Lexicon.make((String)"program");
    Logger log = Logger.getLogger("program");

    public Type getType() {
        return TYPE;
    }

    public BProgramRecompileTool() {
        this.table = new BTable((TableModel)new ProgramTableModel());
        BGridPane buttons = new BGridPane(5);
        buttons.add(null, (BValue)new BButton((Command)new RecompileCommand()));
        BEdgePane pane = new BEdgePane();
        this.titlePane = BTitlePane.makePane((String)this.getTypeDisplayName(null), (BTable)this.table);
        pane.setCenter((BWidget)this.titlePane);
        pane.setBottom((BWidget)new BBorderPane((BWidget)buttons, 5.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)pane);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.programs = new ArrayList<BProgram>();
        BStation station = ObjectUtil.getStation((BComponentSpace)value.asComponent().getComponentSpace());
        BOrd base = value.asComponent().getComponentSpace().getAbsoluteOrd();
        BOrd ord = BOrd.make((BOrd)base, (BOrd)BOrd.make((String)"slot:/|bql:select * from program:Program"));
        OrdQuery[] query = ord.parse();
        SelectQuery q = (SelectQuery)query[query.length - 1];
        BSelect s = q.getSelect();
        BPath path = new BPath("toPathString");
        if (s.hasProjection() && s.getProjection().isDistinct()) {
            s.select(Columns.distinctProjection().add(Columns.make((BExpression)path)));
        } else {
            s.select(Columns.projection((BProjectionColumn)Columns.make((BExpression)path)));
        }
        query[query.length - 1] = new SelectQuery(s);
        ord = BOrd.make((OrdQuery[])query);
        BITable table = (BITable)ord.resolve(value).get();
        ColumnList cols = table.getColumns();
        try (TableCursor c = table.cursor();){
            while (c.next()) {
                BOrd temp = BOrd.make((String)(base.toString() + "|slot:" + c.cell(cols.get(0))));
                temp = BOrd.make((BOrd)this.getWbShell().getActiveOrd(), (BOrd)temp).normalize();
                BObject obj = temp.resolve().get();
                if (!(obj instanceof BProgram)) continue;
                ((BProgram)obj).lease(1);
                this.programs.add((BProgram)obj);
            }
        }
        this.titlePane.setCount(this.programs.size());
    }

    class RecompileWorker
    extends BProgressDialog.Worker {
        boolean canceled = false;
        RecompileTool recompiler;
        List<BProgram> programs;
        Map<SlotPath, Exception> errors = new HashMap<SlotPath, Exception>();

        public RecompileWorker(List<BProgram> programs, RecompileTool recompiler) {
            this.programs = programs;
            this.recompiler = recompiler;
        }

        public void doRun() throws Exception {
            for (int i = 0; i < this.programs.size() && !this.canceled; ++i) {
                int progress = (i + 1) * 100 / this.programs.size();
                this.updateProgress(progress, lex.getText("recompile.progress", new Object[]{i + 1, this.programs.size()}));
                try {
                    this.recompiler.recompile(this.programs.get(i));
                    continue;
                }
                catch (Exception e) {
                    this.errors.put(this.programs.get(i).getSlotPath(), e);
                }
            }
            if (this.canceled) {
                return;
            }
            if (this.errors.isEmpty()) {
                BDialog.info((BWidget)BProgramRecompileTool.this, (String)lex.getText("recompile.complete.title"), (Object)lex.getText("recompile.complete.description"));
            } else {
                StringBuilder message = new StringBuilder();
                for (Map.Entry<SlotPath, Exception> entry : this.errors.entrySet()) {
                    message.append(entry.getKey() + ": \n\n");
                    message.append(entry.getValue().getMessage());
                    message.append("\n\n");
                }
                BDialog.error((BWidget)BProgramRecompileTool.this, (String)lex.getText("recompile.complete.title"), (Object)lex.getText("recompile.complete.errors.description"), (String)message.toString());
            }
        }

        public void doCancel() throws Exception {
            this.canceled = true;
        }
    }

    class RecompileCommand
    extends Command {
        public RecompileCommand() {
            super((BWidget)BProgramRecompileTool.this, lex.getText("recompile.recompileAll"));
        }

        public CommandArtifact doInvoke() throws Exception {
            BCodeSigningOptions options = BCodeSigningOptions.make();
            String alias = options.getSigningCert();
            char[] keyPassword = null;
            if ((alias == null || alias.isEmpty()) && AccessController.doPrivileged(() -> Boolean.getBoolean("program.requireSigning")).booleanValue()) {
                CoreCryptoManager ccm = AccessController.doPrivileged(() -> {
                    try {
                        return CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
                    }
                    catch (Exception e) {
                        return null;
                    }
                });
                String newAlias = BCertificateNotSelectedDialog.show(this.getOwner());
                if (newAlias != null && !newAlias.isEmpty()) {
                    options.setSigningCert(newAlias);
                    alias = newAlias;
                }
            }
            if (alias != null && !alias.isEmpty()) {
                keyPassword = AccessController.doPrivileged(() -> {
                    try {
                        return options.getKeyPassword(this.getOwner());
                    }
                    catch (Exception exception) {
                        return new char[0];
                    }
                });
            }
            if (alias == null || alias.isEmpty()) {
                BProgramRecompileTool.this.log.warning(lex.getText("program.willNotSign"));
            } else {
                try {
                    Compiler.checkSigningKey(alias, (char[])keyPassword.clone());
                }
                catch (LocalizableException e) {
                    BDialog.error((BWidget)this.getOwner(), (Object)e.getLocalizedMessage());
                    return null;
                }
            }
            String tsaUrl = options.getTsaUrl();
            RecompileTool recompiler = new RecompileTool(alias, tsaUrl, keyPassword);
            BProgressDialog.open((BWidget)this.getOwner(), (String)lex.getText("recompile.title"), (BProgressDialog.Worker)new RecompileWorker(BProgramRecompileTool.this.programs, recompiler));
            return null;
        }
    }

    class ProgramTableModel
    extends TableModel {
        private final String[] cols = new String[]{lex.get("recompile.columns.path"), lex.get("recompile.columns.status"), lex.get("recompile.columns.fault"), lex.get("recompile.columns.signed")};

        ProgramTableModel() {
        }

        public int getRowCount() {
            return BProgramRecompileTool.this.programs.size();
        }

        public int getColumnCount() {
            return this.cols.length;
        }

        public String getColumnName(int col) {
            return this.cols[col];
        }

        public Object getValueAt(int row, int col) {
            BProgram program = BProgramRecompileTool.this.programs.get(row);
            switch (col) {
                case 0: {
                    return program.getSlotPath();
                }
                case 1: {
                    return program.getCode().getStatus();
                }
                case 2: {
                    return program.getCode().getFaultCause();
                }
                case 3: {
                    return program.getCode().getSignature() != null && program.getCode().getSignature().length() > 0;
                }
            }
            return null;
        }
    }
}

