/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.program.BCode;
import com.tridium.program.BProgram;
import com.tridium.program.module.BProgramModule;
import com.tridium.program.ui.BBuilderTable;
import com.tridium.program.ui.BFieldSheet;
import com.tridium.program.ui.BProgramEditor;
import com.tridium.program.ui.Compiler;
import com.tridium.program.ui.Permissions;
import com.tridium.program.ui.ProgramModuleBuilderCommands;
import com.tridium.program.ui.SourceWriter;
import com.tridium.program.ui.module.BuildHelper;
import com.tridium.program.ui.module.IBuildListener;
import com.tridium.program.ui.module.ValidateModel;
import com.tridium.ui.theme.Theme;
import com.tridium.util.EscUtil;
import com.tridium.workbench.console.BConsole;
import com.tridium.workbench.transfer.TransferUtil;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BExpandablePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.util.BFolder;
import javax.baja.util.BNameMap;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableCellRenderer;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;

public class BProgramModuleBuilder
extends BFolderManager {
    public static final Action handleSelection = BProgramModuleBuilder.newAction((int)4, null);
    public static final Action handleModified = BProgramModuleBuilder.newAction((int)4, null);
    public static final Action handlePermissionSelection = BProgramModuleBuilder.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BProgramModuleBuilder.class);
    Lexicon lex = Lexicon.make(BProgramModuleBuilder.class);
    static final BImage CHECK = BImage.make((BIcon)BIcon.std((String)"check.png"));
    static final BImage BLANK = BImage.make((BIcon)BIcon.std((String)"blank.png"));
    BProgramModule pmod;
    BuildHelper buildHelper;
    BSplitPane split;
    BFieldSheet sheet = new BFieldSheet();
    Map<BValue, ValidateModel> verify;
    ProgramModuleBuilderCommands commands = new ProgramModuleBuilderCommands(this);
    Permissions permissions = new Permissions(this);

    public void handleSelection() {
        this.invoke(handleSelection, null, null);
    }

    public void handleModified() {
        this.invoke(handleModified, null, null);
    }

    public void handlePermissionSelection() {
        this.invoke(handlePermissionSelection, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject obj, Context cx) {
        this.pmod = (BProgramModule)obj;
        this.buildHelper = new BuildHelper(this.pmod);
        this.verify = new HashMap<BValue, ValidateModel>();
        this.verify.put((BValue)this.pmod, ValidateModel.make(this.pmod));
        super.doLoadValue(obj, cx);
    }

    protected void init() {
        super.init();
        ViewQuery query = this.getWbShell().getActiveOrdTarget().getViewQuery();
        if (query != null) {
            try {
                String name = query.getParameter("program");
                int toSelect = ((BBuilderTable)this.getModel().getTable()).getRowOfProgram(name);
                this.getModel().getTable().getSelection().select(toSelect);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void handleComponentEvent(BComponentEvent event) {
        BComponent source = event.getSourceComponent();
        BValue value = event.getValue();
        if (source == this.pmod) {
            this.verify.put((BValue)this.pmod, ValidateModel.make(this.pmod));
        } else if (event.getId() == 3) {
            this.verify.put((BValue)this.getSelectedProgram(), ValidateModel.make(this.getSelectedProgram()));
            this.handleSelection();
        } else if (value instanceof BProgram) {
            switch (event.getId()) {
                case 0: 
                case 1: {
                    this.verify.put(value, ValidateModel.make((BProgram)value));
                    this.handleSelection();
                    break;
                }
                case 2: {
                    if (value == this.getSelectedProgram()) {
                        this.getModel().getTable().getSelection().deselectAll();
                    }
                    this.verify.remove(value);
                }
            }
            this.verify.put((BValue)this.pmod, ValidateModel.make(this.pmod));
        }
        super.handleComponentEvent(event);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        try {
            this.sheet.saveValue((BObject)this.pmod, cx);
            this.verify.put((BValue)this.pmod, ValidateModel.make(this.pmod));
        }
        catch (Exception e) {
            this.verify.get(this.pmod).err(e.getMessage());
            throw e;
        }
        finally {
            this.getModel().getTable().getSelection().select(-1);
        }
        return this.pmod;
    }

    public void doHandleModified() {
        if (this.sheet.isModified()) {
            this.getController().updateCommands();
        }
    }

    protected MgrModel makeModel() {
        return new BuilderModel(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    public void doHandleSelection() {
        ValidateModel m = this.verify.get(this.pmod);
        BProgram selected = this.getSelectedProgram();
        if (selected != null) {
            m = this.verify.get(selected);
        }
        if (m.getTable() != null) {
            m.setTable(null);
        }
        this.split.setWidget2((BWidget)new BTable((TableModel)m));
        if (this.split.getDividerPosition() > 75.0) {
            this.split.setDividerPosition(75.0);
            this.split.relayout();
        }
    }

    public void doHandlePermissionSelection() {
        int numSelected = this.permissions.table.getSelection().getRowCount();
        if (numSelected == 0) {
            this.commands.editPermissionCommand.setEnabled(false);
            this.commands.removePermissionCommand.setEnabled(false);
        } else if (numSelected == 1) {
            this.commands.editPermissionCommand.setEnabled(true);
            this.commands.removePermissionCommand.setEnabled(true);
        } else {
            this.commands.editPermissionCommand.setEnabled(false);
            this.commands.removePermissionCommand.setEnabled(true);
        }
    }

    private BProgram getSelectedProgram() {
        return (BProgram)this.getModel().getTable().getSelectedComponent();
    }

    class BuilderModel
    extends FolderModel {
        MgrColumn colProgramName;
        MgrColumn colComp;
        MgrColumn[] columns;

        public BuilderModel(BFolderManager manager) {
            super(manager);
            this.colProgramName = new ProgName(1);
            this.colComp = new CompName();
            this.columns = new MgrColumn[]{this.colProgramName, this.colComp};
        }

        protected BMgrTable makeTable() {
            BBuilderTable table = new BBuilderTable((MgrModel)this);
            BProgramModuleBuilder.this.linkTo((BComponent)table, (Slot)BTable.selectionModified, (Slot)handleSelection);
            return table;
        }

        public Type getFolderType() {
            return BFolder.TYPE;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BProgram.TYPE};
        }

        public boolean accept(BComponent component) {
            if (component.getParent().equals((Object)BProgramModuleBuilder.this.pmod.getPrograms())) {
                BProgramModuleBuilder.this.verify.put((BValue)component, ValidateModel.make((BProgram)component));
                return true;
            }
            return false;
        }

        public int getSubscribeDepth() {
            return 2;
        }

        protected String makeTableTitle() {
            return BProgramModuleBuilder.this.lex.getText("modBuilder.title");
        }

        public BWidget makePane() {
            BProgramModuleBuilder.this.sheet = new BFieldSheet();
            BProgramModuleBuilder.this.sheet.loadValue((BObject)BProgramModuleBuilder.this.pmod, BProgramModuleBuilder.this.getCurrentContext());
            BProgramModuleBuilder.this.linkTo((BComponent)BProgramModuleBuilder.this.sheet, (Slot)BFieldSheet.pluginModified, (Slot)BAbstractManager.setModified);
            BProgramModuleBuilder.this.linkTo((BComponent)BProgramModuleBuilder.this.sheet, (Slot)BFieldSheet.pluginModified, (Slot)handleModified);
            BExpandablePane expand = new BExpandablePane();
            BEdgePane editorPane = new BEdgePane();
            editorPane.setCenter((BWidget)BProgramModuleBuilder.this.sheet);
            expand.setSummary((BWidget)new BLabel(BProgramModuleBuilder.this.lex.getText("modBuilder.settings")));
            expand.setExpansion((BWidget)new BBorderPane((BWidget)editorPane, 0.0, 0.0, 5.0, 0.0));
            expand.setExpanded(true);
            BWidget managerPane = this.makeManagerPane();
            BProgramModuleBuilder.this.split = new BSplitPane(BOrientation.vertical, 75.0);
            BProgramModuleBuilder.this.split.setWidget1(managerPane);
            BProgramModuleBuilder.this.split.setWidget2((BWidget)new BNullWidget());
            BEdgePane edge = new BEdgePane();
            edge.setTop((BWidget)expand);
            edge.setCenter((BWidget)BProgramModuleBuilder.this.split);
            return edge;
        }

        private BWidget makeManagerPane() {
            super.initTable();
            BMgrTable table = super.getTable();
            BWidget requestTab = this.makeRequestsPane();
            BTabbedPane tabbedPane = new BTabbedPane();
            tabbedPane.add(this.makeTableTitle(), (BValue)new BLabelPane(this.makeTableTitle(), (BWidget)table));
            tabbedPane.add("permissionRequests", (BValue)new BLabelPane(BProgramModuleBuilder.this.lex.getText("modBuilder.permissions.title"), requestTab));
            return tabbedPane;
        }

        private BWidget makeRequestsPane() {
            BGridPane buttons = new BGridPane(3);
            buttons.add(null, (BValue)new BButton((Command)BProgramModuleBuilder.this.commands.addPermissionCommand));
            buttons.add(null, (BValue)new BButton((Command)BProgramModuleBuilder.this.commands.editPermissionCommand));
            buttons.add(null, (BValue)new BButton((Command)BProgramModuleBuilder.this.commands.removePermissionCommand));
            buttons.setUniformColumnWidth(true);
            buttons.setColumnAlign(BHalign.fill);
            BEdgePane edge = new BEdgePane();
            edge.setCenter((BWidget)BProgramModuleBuilder.this.permissions.table);
            edge.setBottom((BWidget)new BBorderPane((BWidget)buttons));
            return edge;
        }

        protected MgrColumn[] makeColumns() {
            return this.columns;
        }

        protected class CompName
        extends MgrColumn {
            public CompName() {
                super("BComponent Name", 6);
            }

            public Object get(Object row) {
                return BuildHelper.toComponentName((BProgram)row);
            }
        }

        protected class ProgName
        extends MgrColumn.Name {
            private CellRenderer rend;

            public ProgName(int flags) {
                super(flags);
                this.rend = new CellRenderer();
            }

            public TableCellRenderer getCellRenderer() {
                return this.rend;
            }

            private class CellRenderer
            extends ComponentTableCellRenderer {
                private CellRenderer() {
                }

                public double getPreferredCellWidth(TableCellRenderer.Cell s) {
                    return 20.0 + this.getFont(s).width("VeryLongBProgramNameExample");
                }

                public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
                    this.paintCellBackground(g, cell);
                    double x = 2.0;
                    double y = (cell.height - 16.0) / 2.0;
                    ValidateModel v = BProgramModuleBuilder.this.verify.get(this.getComponentTable().getComponentAt(cell.row));
                    g.drawImage(v.getProgramStatusIcon(), x, y);
                    String s = (String)cell.value;
                    BFont font = this.getFont(cell);
                    g.setFont(font);
                    g.drawString(s, x += 20.0, (cell.height + font.getAscent() - font.getDescent()) / 2.0);
                }

                protected BComponentTable getComponentTable() {
                    return ProgName.this.getManager().getModel().getTable();
                }
            }
        }
    }

    class Controller
    extends FolderController {
        CompileCommand compileCmd;
        BuildCommand buildCmd;
        EditDepends dependsCmd;

        public Controller(BFolderManager manager) {
            super(manager);
            this.compileCmd = new CompileCommand((BWidget)manager);
            this.buildCmd = new BuildCommand((BWidget)manager);
            this.dependsCmd = new EditDepends((BWidget)manager);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            this.allDescendants.setSelected(true);
            return new MgrController.IMgrCommand[]{this.edit, this.compileCmd, this.buildCmd, this.dependsCmd};
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            BProgram p = (BProgram)table.getComponentAt(row);
            BWbShell shell = table.getManager().getWbShell();
            shell.hyperlink(BOrd.make((BOrd)p.getNavOrd(), (String)"view:program:ProgramEditor"));
        }

        public BToolBar makeToolBar() {
            return super.makeToolBar();
        }

        public void updateCommands() {
            super.updateCommands();
            boolean buildEnabled = true;
            for (ValidateModel validateModel : BProgramModuleBuilder.this.verify.values()) {
                if (validateModel.getErrCount() <= 0) continue;
                buildEnabled = false;
                break;
            }
            if (BProgramModuleBuilder.this.sheet != null && BProgramModuleBuilder.this.sheet.isModified()) {
                buildEnabled = false;
            }
            this.buildCmd.setEnabled(buildEnabled);
            this.dependsCmd.setEnabled(buildEnabled);
            this.compileCmd.setEnabled(!buildEnabled && !BProgramModuleBuilder.this.sheet.isModified());
        }

        public CommandArtifact drop(BMgrTable table, TransferContext cx) throws Exception {
            return TransferUtil.insert((BWidget)BProgramModuleBuilder.this, (TransferContext)cx, (BObject)BProgramModuleBuilder.this.pmod.getPrograms(), null);
        }

        protected class EditDepends
        extends MgrController.MgrCommand {
            public EditDepends(BWidget owner) {
                super(owner, BProgramModuleBuilder.this.lex, "modBuilder.cmd.editDepends");
                this.setFlags(3);
            }

            public CommandArtifact doInvoke() throws Exception {
                Property[] props;
                BVector vector = new BVector();
                BFieldSheet sheet = this.makeDependsSheet(vector);
                BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)sheet, BInsets.make((double)10.0)));
                scroll.setVpolicy(BScrollBarPolicy.always);
                scroll.setViewportBackground(Theme.widget().getControlBackground());
                while (true) {
                    if (2 == BDialog.open((BWidget)BProgramModuleBuilder.this, (String)BProgramModuleBuilder.this.lex.getText("modBuilder.cmd.editDepends.title"), (Object)scroll, (int)3)) {
                        return null;
                    }
                    try {
                        sheet.saveValue((BObject)vector, null);
                    }
                    catch (Exception e) {
                        BDialog.error((BWidget)BProgramModuleBuilder.this, (String)"Error", (Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    break;
                }
                BNameMap depends = BNameMap.DEFAULT;
                for (Property prop : props = vector.getPropertiesArray()) {
                    String module = EscUtil.slot.unescape(prop.getName());
                    String version = vector.getString(prop);
                    depends = BNameMap.make((BNameMap)depends, (String)module, (String)version);
                }
                BProgramModuleBuilder.this.pmod.setDependencies(depends);
                return null;
            }

            private BFieldSheet makeDependsSheet(BVector vector) {
                BFieldSheet sheet = new BFieldSheet(true);
                BFacets facets = BFacets.make((String)"validator", (String)"baja:VersionValidator");
                facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)"fieldSheetShow", (boolean)true));
                facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)"iconOverride", (String)"module://icons/x16/module.png"));
                BNameMap fullDepends = BProgramModule.rationalizeDependencies((BProgramModule)BProgramModuleBuilder.this.pmod);
                Object[] names = fullDepends.list();
                SortUtil.sort((Object[])names);
                for (Object name : names) {
                    Property p = vector.add(EscUtil.slot.escape((String)name), (BValue)BString.make((String)fullDepends.get((String)name).getFormat()));
                    vector.setFacets((Slot)p, facets);
                }
                sheet.loadValue((BObject)vector);
                return sheet;
            }
        }

        protected class BuildCommand
        extends MgrController.MgrCommand {
            public BuildCommand(BWidget owner) {
                super(owner, BProgramModuleBuilder.this.lex, "modBuilder.cmd.build");
                this.setFlags(7);
            }

            public CommandArtifact doInvoke() throws Exception {
                BProgramModuleBuilder.this.saveValue();
                BProgressDialog.open((BWidget)this.getOwner(), (String)BProgramModuleBuilder.this.lex.getText("modBuilder.cmd.build.title"), (BProgressDialog.Worker)new BuildWorker());
                return null;
            }

            class BuildWorker
            extends BProgressDialog.Worker
            implements IBuildListener {
                int curStep = 0;

                BuildWorker() {
                }

                @Override
                public void setNumBuildSteps(int steps) {
                    this.getDialog().getProgressBar().setMax((double)steps);
                }

                @Override
                public void nextStep(String desc) {
                    this.getDialog().getProgressBar().setValue((double)(++this.curStep));
                    this.updateDesc(desc);
                }

                @Override
                public void updateDesc(String desc) {
                    this.getDialog().getMessageLabel().setText(desc);
                }

                @Override
                public BWidget getOwner() {
                    return BProgramModuleBuilder.this;
                }

                public void doCancel() throws Exception {
                }

                public void doRun() throws Exception {
                    try {
                        BProgramModuleBuilder.this.buildHelper.buildModule(this);
                    }
                    catch (Exception e) {
                        BDialog.error((BWidget)this.getDialog(), (String)BProgramModuleBuilder.this.lex.getText("programModule.nbuild.fail"), (Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }

        protected class CompileCommand
        extends MgrController.MgrCommand {
            public CompileCommand(BWidget owner) {
                super(owner, BProgramModuleBuilder.this.lex, "modBuilder.cmd.compile");
                this.setFlags(7);
            }

            public CommandArtifact doInvoke() throws Exception {
                BProgram[] programs;
                for (BProgram program : programs = BProgramModuleBuilder.this.pmod.listPrograms()) {
                    if (BProgramModuleBuilder.this.verify.get(program).getErrCount() == 0) continue;
                    try {
                        PCompiler compiler = new PCompiler(this.getOwner(), program);
                        compiler.compile(BCode.generateClassName(), (BCode)program.getCode(), null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }

            private class PCompiler
            extends Compiler {
                BProgram program;
                BProgramEditor pe;

                public PCompiler(BWidget owner, BProgram program) {
                    super(owner);
                    this.program = program;
                    this.pe = new BProgramEditor();
                    this.pe.loadValue((BObject)program);
                }

                @Override
                public void writeSource(FileWriter out, String source) throws Exception {
                    SourceWriter writer = new SourceWriter((Writer)out, this.pe);
                    writer.generate(this.className);
                }

                @Override
                public synchronized void compile(String className, BCode code, String source) throws Exception {
                    super.compile(className, code, source);
                }

                @Override
                public synchronized void consoleExecDone(BConsole console, int exitCode) {
                    super.consoleExecDone(console, exitCode);
                }

                @Override
                public void compileFailed(BConsole console) throws Exception {
                    console.cls();
                    BProgramModuleBuilder.this.verify.get(this.program).err(lex.getText("vprogram.err.compile"));
                }

                @Override
                public void compileSuccess(BConsole console) throws Exception {
                    super.compileSuccess(console);
                    int old = this.program.getCode().getChecksum();
                    int now = this.pe.computeChecksum(this.program.getCode().getSource());
                    if (old != now) {
                        this.program.getCode().setChecksum(now);
                        BProgramModuleBuilder.this.handleComponentEvent(new BComponentEvent(0, (BComponent)BProgramModuleBuilder.this.pmod.getPrograms(), null, (BValue)this.program));
                    }
                }
            }
        }
    }
}

