/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.test.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.test.file.BMockFileSpace;

@NiagaraType
@NiagaraSlots
public class BMockFileStore
extends BObject
implements BIFileStore {
    public static final Type TYPE = Sys.loadType(BMockFileStore.class);
    private final FilePath filePath;
    private final boolean isDirectory;
    private long size = 0L;
    private long crc = 0L;
    private BAbsTime lastModified = BAbsTime.NULL;
    private boolean readonly = true;
    private BPermissions permissions = BPermissions.none;
    private BMockFileSpace space;
    private Optional<Supplier<InputStream>> inputStreamSupplier = Optional.empty();

    public Type getType() {
        return TYPE;
    }

    public BMockFileStore(BMockFileSpace space, String pathBody, boolean isDirectory) {
        this.filePath = new FilePath(pathBody);
        this.space = space;
        this.isDirectory = isDirectory;
    }

    public void setSize(long value) {
        this.size = value;
    }

    public void setReadonly(boolean value) {
        this.readonly = value;
    }

    public void setCrc(long value) {
        this.crc = value;
    }

    public void setPermissions(BPermissions value) {
        this.permissions = value;
    }

    public void setInputStreamSupplier(Supplier<InputStream> value) {
        this.inputStreamSupplier = Optional.of(value);
    }

    public void setInputStreamSupplier(Consumer<OutputStream> value) {
        this.setInputStreamSupplier(() -> {
            try {
                PipedOutputStream outputStream = new PipedOutputStream();
                PipedInputStream inputStream = new PipedInputStream(outputStream);
                value.accept(outputStream);
                return inputStream;
            }
            catch (IOException ioe) {
                throw new BajaRuntimeException((Throwable)ioe);
            }
        });
    }

    public String toString(Context cx) {
        return String.valueOf(this.filePath);
    }

    public BFileSpace getFileSpace() {
        return this.space;
    }

    public FilePath getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        return this.getFilePath().getName();
    }

    public String getExtension() {
        return FileUtil.getExtension((String)this.getFileName());
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public long getSize() {
        return this.size;
    }

    public BAbsTime getLastModified() {
        return this.lastModified;
    }

    public boolean setLastModified(BAbsTime absTime) {
        this.lastModified = absTime;
        return true;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public BPermissions getPermissions(BIFile file, Context cx) {
        return this.permissions;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStreamSupplier.isPresent()) {
            return this.inputStreamSupplier.get().get();
        }
        throw new UnsupportedOperationException();
    }

    public byte[] read() throws IOException {
        return this.filePath.getBody().getBytes();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] content) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long getCrc() throws IOException {
        return this.crc;
    }
}

