/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import com.tridium.fox.sys.BFoxService;
import com.tridium.template.file.BINtplFile;
import java.util.Objects;
import javax.baja.category.BCategoryMask;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.firewall.BServerPort;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.web.BWebService;

public final class StationBuilder {
    private static final boolean COPY_EXACT = true;
    private String templatePath = null;
    private String stationName = null;
    private String username = null;
    private String password = null;
    private boolean useHttp = false;
    private int httpPort = 8080;
    private int httpsPort = 8443;
    private boolean useFox = false;
    private int foxPort = 1911;
    private int foxsPort = 4911;

    private StationBuilder() {
    }

    public static StationBuilder builder() {
        return new StationBuilder();
    }

    public BStation build() {
        BStation station;
        Objects.requireNonNull(this.templatePath);
        Objects.requireNonNull(this.stationName);
        Objects.requireNonNull(this.username);
        Objects.requireNonNull(this.password);
        try (BINtplFile stationTemplate = (BINtplFile)BFileSystem.INSTANCE.findFile(new FilePath(this.templatePath));){
            station = (BStation)stationTemplate.getBaseComponent().newCopy(true);
        }
        station.setCategoryMask(BCategoryMask.make((String)"1"), null);
        station.setStationName(this.stationName);
        BUserService userService = ((BUserService[])station.getServices().getChildren(BUserService.class))[0];
        BUser adminUser = userService.getUser(this.username);
        if (adminUser == null) {
            adminUser = new BUser();
            userService.add(this.username, (BValue)adminUser);
        }
        adminUser.setAuthenticator((BAbstractAuthenticator)new BPasswordAuthenticator(BPassword.make((String)this.password, (String)BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE)));
        adminUser.setRoles("admin");
        BFoxService foxService = ((BFoxService[])station.getServices().getChildren(BFoxService.class))[0];
        foxService.setFoxEnabled(this.useFox);
        foxService.setFoxPort(new BServerPort(this.foxPort));
        foxService.setFoxsPort(new BServerPort(this.foxsPort));
        BWebService webService = ((BWebService[])station.getServices().getChildren(BWebService.class))[0];
        webService.setHttpEnabled(this.useHttp);
        webService.setHttpPort(new BServerPort(this.httpPort));
        webService.setHttpsPort(new BServerPort(this.httpsPort));
        return station;
    }

    public StationBuilder withTemplateFile(String templatePath) {
        this.templatePath = templatePath;
        return this;
    }

    public StationBuilder withStationName(String stationName) {
        this.stationName = stationName;
        return this;
    }

    public StationBuilder withAdminCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public StationBuilder withHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public StationBuilder withHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public StationBuilder useHttp() {
        this.useHttp = true;
        return this;
    }

    public StationBuilder withFoxPort(int foxPort) {
        this.foxPort = foxPort;
        return this;
    }

    public StationBuilder withFoxsPort(int foxsPort) {
        this.foxsPort = foxsPort;
        return this;
    }

    public StationBuilder useFox() {
        this.useFox = true;
        return this;
    }
}

