/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import com.tridium.testng.annotation.IntegrationTest;
import com.tridium.testng.annotation.UnitTest;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.testng.IAnnotationTransformer;
import org.testng.annotations.ITestAnnotation;

public class NiagaraAnnotationTransformer
implements IAnnotationTransformer {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    @SafeVarargs
    private static <T> List<T> listOf(T ... elements) {
        LinkedList<T> list = new LinkedList<T>();
        list.addAll(Arrays.asList(elements));
        return list;
    }

    @Override
    public void transform(ITestAnnotation annotation, Class testClass, Constructor testConstructor, Method testMethod) {
        NiagaraAnnotationTransformer.listOf(testClass, testConstructor, testMethod).stream().filter(Objects::nonNull).map(this::getGroups).forEach(groups -> NiagaraAnnotationTransformer.addGroupsToAnnotation(annotation, groups));
    }

    private List<String> getGroups(AnnotatedElement element) {
        LinkedList<String> groups = new LinkedList<String>();
        if (element.getDeclaredAnnotation(IntegrationTest.class) != null) {
            groups.add("integrationTest");
        }
        if (element.getDeclaredAnnotation(UnitTest.class) != null) {
            groups.add("ci");
        }
        return groups;
    }

    private static void addGroupsToAnnotation(ITestAnnotation annotation, List<String> groups) {
        if (groups == null || groups.isEmpty()) {
            return;
        }
        String[] existingGroups = annotation.getGroups();
        LinkedList<String> transformedGroups = new LinkedList<String>();
        if (existingGroups == null || existingGroups.length == 0) {
            transformedGroups.addAll(groups);
        } else {
            transformedGroups.addAll(Arrays.asList(existingGroups));
            for (String group : groups) {
                if (transformedGroups.contains(group)) continue;
                transformedGroups.add(group);
            }
        }
        annotation.setGroups(transformedGroups.toArray(EMPTY_STRING_ARRAY));
    }
}

